/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetConfiguration;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetType;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.application.JavaeeModule;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.service.project.data.javaee.JavaeeProjectDataService;

@Order(value=1000)
public class EarModuleGradleDataService
extends JavaeeProjectDataService<EarConfigurationModelData, JavaeeApplicationFacet, JavaeeApplicationFacetConfiguration, JavaeeApplicationFacetType> {
    private static final Logger LOG = Logger.getInstance(EarModuleGradleDataService.class);

    public EarModuleGradleDataService() {
        super(JavaeeApplicationFacetType.getInstance());
    }

    @NotNull
    public Key<EarConfigurationModelData> getTargetDataKey() {
        Key key = EarConfigurationModelData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void configureJavaeeModule(@NotNull ModuleData moduleData, @NotNull EarConfigurationModelData javaeeData, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "configureJavaeeModule"));
        }
        if (javaeeData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeData", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "configureJavaeeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "configureJavaeeModule"));
        }
        JavaeeApplicationFacetType javaeeFacetType = (JavaeeApplicationFacetType)this.getJavaeeFacetType();
        Module module = modelsProvider.findIdeModule(moduleData);
        if (module != null) {
            String facetNamePrefix = this.getFacetNamePrefix((FacetType)javaeeFacetType);
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Collection javaeeApplicationFacets = facetModel.getFacetsByType(javaeeFacetType.getId());
            for (JavaeeApplicationFacet facet : javaeeApplicationFacets) {
                if (!facet.getName().startsWith(facetNamePrefix)) continue;
                facetModel.removeFacet((Facet)facet);
            }
            for (Ear ear : javaeeData.getArtifacts()) {
                LibraryData libraryData;
                Object moduleArchiveName;
                ModuleData moduleDependencyData;
                ArrayList<ApplicationXmlAppender> appenders = new ArrayList<ApplicationXmlAppender>();
                String facetName = this.adjustName(facetNamePrefix, ear.getName());
                JavaeeApplicationFacet javaeeApplicationFacet = (JavaeeApplicationFacet)this.createOrReplaceFacet(facetModel, module, facetName, javaeeFacetType);
                String explodedArtifactName = this.resolveArtifactName(moduleData, ear.getName(), true);
                ModifiableArtifact explodedArtifact = this.prepareArtifact(modelsProvider, module, explodedArtifactName, (Jar)ear, javaeeFacetType.getExplodedArtifactType());
                CompositePackagingElement rootElement = explodedArtifact.getRootElement();
                rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)javaeeApplicationFacet));
                PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
                String appDirName = ear.getAppDirName();
                if (!new File(appDirName).isAbsolute()) {
                    appDirName = moduleData.getLinkedExternalProjectPath() + '/' + appDirName;
                }
                String appDirPath = FileUtil.toSystemIndependentName((String)appDirName);
                rootElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(appDirPath, "/"));
                for (EarResource resource : ear.getResources()) {
                    String filePath;
                    if (!resource.getFile().isFile() || FileUtil.isAncestor((String)appDirPath, (String)(filePath = FileUtil.toSystemIndependentName((String)resource.getFile().getPath())), (boolean)true)) continue;
                    rootElement.addOrFindChild(packagingElementFactory.createFileCopyWithParentDirectories(filePath, resource.getEarDirectory(), new File(resource.getRelativePath()).getName()));
                }
                for (DependencyData dependencyData : javaeeData.getDeployDependencies()) {
                    if (dependencyData instanceof ModuleDependencyData) {
                        CompositePackagingElement moduleArchive;
                        moduleDependencyData = (ModuleData)dependencyData.getTarget();
                        boolean isWeb = false;
                        moduleArchiveName = null;
                        for (String path : ((ModuleDependencyData)dependencyData).getModuleDependencyArtifacts()) {
                            if (FileUtilRt.extensionEquals((String)path, (String)"war") || FileUtilRt.extensionEquals((String)path, (String)"WAR")) {
                                isWeb = true;
                                moduleArchiveName = FileUtil.getNameWithoutExtension((File)new File(path)) + ".war";
                                break;
                            }
                            moduleArchiveName = FileUtil.getNameWithoutExtension((File)new File(path)) + ".jar";
                        }
                        if (moduleArchiveName == null) {
                            moduleArchiveName = this.formatModuleArchiveFileName(moduleDependencyData);
                        }
                        Artifact webArtifactCandidate = null;
                        if (isWeb) {
                            String webArtifactNamePrefix = this.resolveArtifactName(moduleDependencyData, "", true);
                            String webArtifactName = this.resolveArtifactName(moduleDependencyData, (String)moduleArchiveName, true);
                            ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
                            for (Artifact artifact : artifactModel.getArtifactsByType((ArtifactType)ExplodedWarArtifactType.getInstance())) {
                                if (webArtifactName.equals(artifact.getName())) {
                                    webArtifactCandidate = artifact;
                                    break;
                                }
                                if (!artifact.getName().startsWith(webArtifactNamePrefix)) continue;
                                webArtifactCandidate = artifact;
                            }
                        }
                        if (webArtifactCandidate == null) {
                            Module depModule = modelsProvider.findIdeModule(moduleDependencyData);
                            if (depModule == null) continue;
                            moduleArchive = packagingElementFactory.createDirectory((String)moduleArchiveName);
                            moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(depModule));
                            String moduleResourceOutputDir = moduleDependencyData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE);
                            if (StringUtil.isNotEmpty((String)moduleResourceOutputDir)) {
                                moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(moduleResourceOutputDir, "/"));
                            }
                            rootElement.addOrFindChild((PackagingElement)moduleArchive);
                        } else {
                            PackagingElement artifactElement = packagingElementFactory.createArtifactElement(webArtifactCandidate, module.getProject());
                            moduleArchive = packagingElementFactory.createDirectory((String)moduleArchiveName);
                            moduleArchive.addOrFindChild(artifactElement);
                            rootElement.addOrFindChild((PackagingElement)moduleArchive);
                        }
                        EarModuleGradleDataService.link((String)moduleArchiveName, isWeb, appenders);
                        continue;
                    }
                    if (!(dependencyData instanceof LibraryDependencyData)) continue;
                    libraryData = (LibraryData)dependencyData.getTarget();
                    Set libraryDataPaths = libraryData.getPaths(LibraryPathType.BINARY);
                    for (String libraryDataPath : libraryDataPaths) {
                        rootElement.addOrFindChild(packagingElementFactory.createFileCopy(libraryDataPath, null));
                    }
                }
                for (DependencyData dependencyData : javaeeData.getEarlibDependencies()) {
                    if (dependencyData instanceof ModuleDependencyData) {
                        moduleDependencyData = (ModuleData)dependencyData.getTarget();
                        Module depModule = modelsProvider.findIdeModule(moduleDependencyData);
                        if (depModule == null) continue;
                        moduleArchiveName = this.formatModuleArchiveFileName(moduleDependencyData);
                        CompositePackagingElement moduleArchive = packagingElementFactory.createArchive((String)moduleArchiveName);
                        moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(depModule));
                        String moduleResourceOutputDir = moduleDependencyData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE);
                        if (StringUtil.isNotEmpty((String)moduleResourceOutputDir)) {
                            moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(moduleResourceOutputDir, "/"));
                        }
                        packagingElementFactory.getOrCreateDirectory(rootElement, ear.getLibDirName()).addOrFindChild((PackagingElement)moduleArchive);
                        continue;
                    }
                    if (!(dependencyData instanceof LibraryDependencyData)) continue;
                    libraryData = (LibraryData)dependencyData.getTarget();
                    Set libraryDataPaths = libraryData.getPaths(LibraryPathType.BINARY);
                    for (String libraryDataPath : libraryDataPaths) {
                        packagingElementFactory.getOrCreateDirectory(rootElement, ear.getLibDirName()).addOrFindChild(packagingElementFactory.createFileCopy(libraryDataPath, null));
                    }
                }
                EarModuleGradleDataService.configureDescriptor(moduleData, module, ear, appenders, explodedArtifact, javaeeApplicationFacet);
                String artifactName = this.resolveArtifactName(moduleData, ear.getName(), false);
                ModifiableArtifact archiveArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)ear, javaeeFacetType.getArchiveArtifactType());
                PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)explodedArtifact, module.getProject());
                archiveArtifact.getRootElement().addOrFindChild(artifactElement);
            }
        }
    }

    private static void configureDescriptor(@NotNull ModuleData moduleData, Module module, Ear ear, List<ApplicationXmlAppender> appenders, ModifiableArtifact explodedArtifact, JavaeeApplicationFacet javaeeApplicationFacet) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "configureDescriptor"));
        }
        String descriptorPath = (String)ObjectUtils.chooseNotNull((Object)explodedArtifact.getOutputPath(), (Object)(moduleData.getLinkedExternalProjectPath() + "build")) + "/META-INF/application.xml";
        javaeeApplicationFacet.getDescriptorsContainer().getConfiguration().replaceConfigFile(DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA, VfsUtilCore.pathToUrl((String)descriptorPath));
        Project project = module.getProject();
        ArtifactProperties artifactProperties = explodedArtifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance());
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return;
        }
        GradleArtifactProperties gradleArtifactProperties = (GradleArtifactProperties)((Object)artifactProperties.getState());
        ConfigFile descriptor = javaeeApplicationFacet.getApplicationDescriptor();
        if (descriptor == null) {
            return;
        }
        String deploymentDescriptor = ear.getDeploymentDescriptor();
        ConfigFileMetaData metaData = DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA;
        String fileText = StringUtil.convertLineSeparators((String)deploymentDescriptor);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(metaData.getFileName(), (FileType)StdFileTypes.XML, (CharSequence)fileText);
        JavaeeApplication root = (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)psiFile, JavaeeApplication.class, (Module)module);
        if (root != null) {
            for (ApplicationXmlAppender appender : appenders) {
                appender.append(root);
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
            HashMap files = ContainerUtil.newHashMap();
            String text = StringUtil.convertLineSeparators((String)psiFile.getText(), (String)SystemProperties.getLineSeparator());
            files.put(descriptorPath, Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
            gradleArtifactProperties.setAdditionalFiles(files);
        }
    }

    private static void link(final String archiveName, final boolean isWeb, List<ApplicationXmlAppender> appenders) {
        appenders.add(new ApplicationXmlAppender(){

            @Override
            public void append(@NotNull JavaeeApplication root) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService$1", "append"));
                }
                for (JavaeeModule module : root.getModules()) {
                    String uri = isWeb ? (String)module.getWeb().getWebUri().getValue() : (String)module.getEjb().getValue();
                    if (uri == null || !uri.equals(archiveName)) continue;
                    return;
                }
                JavaeeModule module = root.addModule();
                (isWeb ? module.getWeb().getWebUri() : module.getEjb()).setValue((Object)archiveName);
                if (isWeb) {
                    module.getWeb().getContextRoot().setValue((Object)FileUtil.getNameWithoutExtension((String)archiveName));
                }
            }
        });
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? JavaeeArtifactUtil.getInstance().getExplodedEarArtifactType() : JavaeeArtifactUtil.getInstance().getEarArtifactType();
    }

    @Override
    protected Collection<String> resolveArtifactNames(@NotNull ModuleData moduleData, @NotNull EarConfigurationModelData data) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "resolveArtifactNames"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/gradle/service/project/data/javaee/EarModuleGradleDataService", "resolveArtifactNames"));
        }
        List names = ContainerUtil.newSmartList();
        for (Ear ear : data.getArtifacts()) {
            names.add(this.resolveArtifactName(moduleData, ear.getName(), false));
            names.add(this.resolveArtifactName(moduleData, ear.getName(), true));
        }
        return names;
    }

    private static interface ApplicationXmlAppender {
        public void append(@NotNull JavaeeApplication var1);
    }
}

