/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.service.project.data.javaee.JavaeeProjectDataService;

@Order(value=1000)
public class WebModuleGradleDataService
extends JavaeeProjectDataService<WebConfigurationModelData, WebFacet, WebFacetConfiguration, WebFacetType> {
    private static final Logger LOG = Logger.getInstance(WebModuleGradleDataService.class);
    private static final String WEB_INF_DIR_NAME = "WEB-INF";

    public WebModuleGradleDataService() {
        super(WebFacetType.getInstance());
    }

    @NotNull
    public Key<WebConfigurationModelData> getTargetDataKey() {
        Key key = WebConfigurationModelData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void configureJavaeeModule(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData javaeeData, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "configureJavaeeModule"));
        }
        if (javaeeData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeData", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "configureJavaeeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "configureJavaeeModule"));
        }
        WebFacetType webFacetType = (WebFacetType)this.getJavaeeFacetType();
        Module module = modelsProvider.findIdeModule(moduleData);
        if (module != null) {
            HashSet outputDirs = ContainerUtil.newHashSet();
            ContainerUtil.addIfNotNull((Collection)outputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            String facetNamePrefix = this.getFacetNamePrefix((FacetType)webFacetType);
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
            for (WebFacet webFacet : webFacets) {
                if (!webFacet.getName().startsWith(facetNamePrefix)) continue;
                facetModel.removeFacet((Facet)webFacet);
            }
            for (War war : javaeeData.getArtifacts()) {
                String facetName = this.adjustName(facetNamePrefix, war.getName());
                WebFacet webFacet = WebModuleGradleDataService.createOrReplaceWebFacet(facetModel, module, facetName, webFacetType, war);
                String explodedArtifactName = this.resolveArtifactName(moduleData, war.getName(), true);
                ModifiableArtifact explodedArtifact = this.createOrUpdateArtifact(modelsProvider, module, explodedArtifactName, webFacetType, webFacet, war, webFacetType.getExplodedArtifactType(), outputDirs);
                String artifactName = this.resolveArtifactName(moduleData, war.getName(), false);
                ModifiableArtifact archiveArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)war, webFacetType.getArchiveArtifactType());
                PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)explodedArtifact, module.getProject());
                archiveArtifact.getRootElement().addOrFindChild(artifactElement);
            }
        }
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? WebArtifactUtil.getInstance().getExplodedWarArtifactType() : WebArtifactUtil.getInstance().getWarArtifactType();
    }

    @Override
    protected Collection<String> resolveArtifactNames(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData data) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "resolveArtifactNames"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "resolveArtifactNames"));
        }
        List names = ContainerUtil.newSmartList();
        for (War war : data.getArtifacts()) {
            names.add(this.resolveArtifactName(moduleData, war.getName(), false));
            names.add(this.resolveArtifactName(moduleData, war.getName(), true));
        }
        return names;
    }

    private static WebFacet createOrReplaceWebFacet(@NotNull ModifiableFacetModel facetModel, @NotNull Module module, @NotNull String facetName, @NotNull WebFacetType webFacetType, @NotNull War war) {
        File webXml;
        if (facetModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetModel", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrReplaceWebFacet"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrReplaceWebFacet"));
        }
        if (facetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetName", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrReplaceWebFacet"));
        }
        if (webFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrReplaceWebFacet"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrReplaceWebFacet"));
        }
        Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
        for (WebFacet webFacet : webFacets) {
            if (!facetName.equals(webFacet.getName())) continue;
            facetModel.removeFacet((Facet)webFacet);
            break;
        }
        WebFacet webFacet = webFacetType.createFacet(module, facetName, webFacetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)webFacet);
        WebModuleGradleDataService.addWebRoot(webFacet, war.getWebAppDir().getAbsolutePath(), "/");
        HashSet<String> added = new HashSet<String>();
        for (Object webResource : war.getWebResources()) {
            String relativePath;
            String dir;
            WarDirectory warDirectory = webResource.getWarDirectory();
            if (!WarDirectory.WAR_ROOT.equals((Object)warDirectory) && !WarDirectory.WEB_INF.equals((Object)warDirectory) && !warDirectory.isCustomDirectory()) continue;
            if (webResource.getFile().isFile()) {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getParent());
                relativePath = WebModuleGradleDataService.normalizeRelativePath(warDirectory.getRelativePath(), StringUtil.trimEnd((String)webResource.getWarRelativePath(), (String)webResource.getFile().getName()));
            } else {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getPath());
                relativePath = WebModuleGradleDataService.normalizeRelativePath(warDirectory.getRelativePath(), webResource.getWarRelativePath());
            }
            if (!added.add(dir) || FileUtil.isAncestor((File)war.getWebAppDir(), (File)new File(dir), (boolean)false)) continue;
            WebModuleGradleDataService.addWebRoot(webFacet, dir, relativePath);
        }
        HashSet sourceRoots = ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false));
        for (String sourceRoot : sourceRoots) {
            webFacet.addWebSourceRoot(sourceRoot);
        }
        File file = webXml = war.getWebXml() != null ? war.getWebXml() : new File(war.getWebAppDir(), "WEB-INF/web.xml");
        if (webXml.isFile()) {
            ConfigFileInfoSet descriptors = webFacet.getDescriptorsContainer().getConfiguration();
            descriptors.addConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)webXml.getPath())));
        }
        return webFacet;
    }

    private static void addWebRoot(@NotNull WebFacet webFacet, @NotNull String dir, @NotNull String relativePath) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "addWebRoot"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "addWebRoot"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "addWebRoot"));
        }
        VirtualFile webDir = null;
        try {
            webDir = VfsUtil.createDirectoryIfMissing((String)dir);
        }
        catch (IOException e) {
            LOG.warn(String.format("Can't add web root for dir: '%s'", dir), (Throwable)e);
        }
        if (webDir != null && !WebUtil.isInsideWebRoots((VirtualFile)webDir, (List)webFacet.getWebRoots())) {
            webFacet.addWebRoot(webDir, relativePath);
        }
    }

    private static String normalizeRelativePath(String ... paths) {
        String relativePath = StringUtil.trimEnd((String)FileUtil.normalize((String)FileUtil.toSystemIndependentName((String)StringUtil.join((String[])paths, (String)"/"))), (String)"/");
        return relativePath.startsWith("//") ? relativePath.substring(1) : relativePath;
    }

    private ModifiableArtifact createOrUpdateArtifact(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module, @NotNull String artifactName, @NotNull WebFacetType webFacetType, @NotNull WebFacet webFacet, @NotNull War war, @NotNull ArtifactType artifactType, @NotNull Set<String> outputDirs) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (webFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        if (outputDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirs", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "createOrUpdateArtifact"));
        }
        ModifiableArtifact modifiableArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)war, artifactType);
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        CompositePackagingElement rootElement = modifiableArtifact.getRootElement();
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)webFacet));
        CompositePackagingElement moduleOutputPackagingElement = packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForDirectory());
        moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createModuleOutput(module));
        for (String outputDir : outputDirs) {
            moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
        }
        List warClasspath = ContainerUtil.mapNotNull((Collection)war.getClasspath(), file -> !file.exists() ? null : FileUtil.toSystemIndependentName((String)file.getAbsolutePath()));
        ArrayList additionalGradleWarClasspath = ContainerUtil.newArrayList((Iterable)warClasspath);
        this.addModuleDependencies(module, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, ContainerUtil.newHashSet());
        for (String path : additionalGradleWarClasspath) {
            if (!new File(path).isFile()) continue;
            FileCopyPackagingElement element = new FileCopyPackagingElement(path);
            packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForJar()).addOrFindChildren(Collections.singletonList(element));
        }
        return modifiableArtifact;
    }

    private void addModuleDependencies(Module module, List<String> warClasspath, List<String> additionalGradleWarClasspath, PackagingElementFactory packagingElementFactory, IdeModifiableModelsProvider modelsProvider, WebFacetType webFacetType, ModifiableArtifact modifiableArtifact, HashSet<Module> processedModules) {
        if (processedModules.contains(module)) {
            return;
        }
        processedModules.add(module);
        for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
            String moduleArchiveName;
            ExportableOrderEntry exportableOrderEntry;
            if (entry instanceof ExportableOrderEntry && (exportableOrderEntry = (ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE && exportableOrderEntry.getScope() != DependencyScope.RUNTIME) continue;
            if (entry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                boolean onGradleWarClasspathLibrary = false;
                for (VirtualFile virtualFile : libraryOrderEntry.getFiles(OrderRootType.CLASSES)) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)virtualFile.getPresentableUrl());
                    onGradleWarClasspathLibrary = onGradleWarClasspathLibrary || warClasspath.contains(systemIndependentName);
                    additionalGradleWarClasspath.remove(systemIndependentName);
                }
                if (!onGradleWarClasspathLibrary || libraryOrderEntry.getLibrary() == null) continue;
                List elements = packagingElementFactory.createLibraryElements(libraryOrderEntry.getLibrary());
                for (PackagingElement element : elements) {
                    String relativePath = WebModuleGradleDataService.getRelativePath(modelsProvider, webFacetType, element);
                    packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), relativePath).addOrFindChildren(Collections.singletonList(element));
                }
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
            Module moduleOrderEntryModule = moduleOrderEntry.getModule();
            HashSet moduleResourceOutputDirs = ContainerUtil.newHashSet();
            if (moduleOrderEntryModule == null) continue;
            ModuleData moduleData = (ModuleData)moduleOrderEntryModule.getUserData(AbstractModuleDataService.MODULE_DATA_KEY);
            if (moduleData != null) {
                moduleArchiveName = this.formatModuleArchiveFileName(moduleData);
                for (File gradleArtifact : moduleData.getArtifacts()) {
                    additionalGradleWarClasspath.remove(FileUtil.toSystemIndependentName((String)gradleArtifact.getAbsolutePath()));
                }
                ContainerUtil.addIfNotNull((Collection)moduleResourceOutputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            } else {
                moduleArchiveName = moduleOrderEntry.getModuleName();
            }
            CompositePackagingElement moduleArchive = packagingElementFactory.createArchive(moduleArchiveName);
            moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(moduleOrderEntryModule));
            for (String outputDir : moduleResourceOutputDirs) {
                moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
            }
            packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), webFacetType.getDefaultUriForJar()).addOrFindChild((PackagingElement)moduleArchive);
            this.addModuleDependencies(moduleOrderEntryModule, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, processedModules);
        }
    }

    private static String getRelativePath(IdeModifiableModelsProvider modelsProvider, WebFacetType webFacetType, PackagingElement<?> element) {
        if (element instanceof DirectoryCopyPackagingElement) {
            return webFacetType.getDefaultUriForDirectory();
        }
        return element.getFilesKind(modelsProvider.getPackagingElementResolvingContext()).containsJarFiles() ? webFacetType.getDefaultUriForJar() : webFacetType.getDefaultUriForDirectory();
    }
}

