/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.jpa.model.xml.impl.converters.ClassConverterBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.xml.ConvertContext;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassWithShortcutsResolvingConverter
extends ClassConverterBase {
    @NotNull
    protected abstract Map<String, String> getShortcutsMap(ConvertContext var1);

    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        String generatorClassName = this.getShortcutsMap(context).get(s);
        return super.fromString(StringUtil.isNotEmpty((String)generatorClassName) ? generatorClassName : s, context);
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/hibernate/model/converters/ClassWithShortcutsResolvingConverter", "getAdditionalVariants"));
        }
        Set<String> set = this.getShortcutsMap(context).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/ClassWithShortcutsResolvingConverter", "getAdditionalVariants"));
        }
        return set;
    }

    protected void setJavaClassReferenceProviderOptions(JavaClassReferenceProvider referenceProvider, ConvertContext context) {
        super.setJavaClassReferenceProviderOptions(referenceProvider, context);
        referenceProvider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
    }
}

