/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentKotlinGradleVersionInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinVersionInfoProvider;", "Lorg/jetbrains/kotlin/idea/facet/KotlinVersionInfoProvider;", "()V", "getCompilerVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "getGradleFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "getLibraryVersions", "", "targetPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "idea"})
public final class GradleKotlinVersionInfoProvider
implements KotlinVersionInfoProvider {
    private final GroovyFileBase getGradleFile(Module module) {
        PsiFile psiFile;
        PsiFile psiFile2;
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string == null) {
            return null;
        }
        String rootDir = string;
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance((Project)module.getProject());
        ExternalProject externalProject = externalProjectDataCache.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(rootDir));
        if (externalProject == null) {
            return null;
        }
        ExternalProject rootProject = externalProject;
        File file2 = rootProject.getBuildFile();
        if (file2 == null) {
            return null;
        }
        File buildFile = file2;
        VirtualFile virtualFile2 = KotlinRefactoringUtilKt.toVirtualFile(buildFile);
        if (virtualFile2 != null) {
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            psiFile2 = KotlinRefactoringUtilKt.toPsiFile(virtualFile2, project);
        } else {
            psiFile2 = psiFile = null;
        }
        if (!(psiFile2 instanceof GroovyFileBase)) {
            psiFile = null;
        }
        GroovyFileBase groovyFileBase = (GroovyFileBase)psiFile;
        if (groovyFileBase == null) {
            return null;
        }
        return groovyFileBase;
    }

    @Override
    @Nullable
    public String getCompilerVersion(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(this, module){
            final /* synthetic */ GradleKotlinVersionInfoProvider this$0;
            final /* synthetic */ Module $module;

            @Nullable
            public final String invoke() {
                String string;
                GroovyFileBase groovyFileBase = GradleKotlinVersionInfoProvider.access$getGradleFile(this.this$0, this.$module);
                if (groovyFileBase != null) {
                    GroovyFileBase groovyFileBase2;
                    GroovyFileBase it = groovyFileBase2 = groovyFileBase;
                    string = DifferentKotlinGradleVersionInspection.Companion.getKotlinPluginVersion(it);
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = gradleKotlinVersionInfoProvider;
                this.$module = module;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public Collection<String> getLibraryVersions(@NotNull Module module, @NotNull TargetPlatformKind<?> targetPlatform, @Nullable ModuleRootModel rootModel) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull(targetPlatform, (String)"targetPlatform");
        Collection collection = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends String>>(this, module, targetPlatform){
            final /* synthetic */ GradleKotlinVersionInfoProvider this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ TargetPlatformKind $targetPlatform;

            @Nullable
            public final Collection<String> invoke() {
                Collection<String> collection;
                GroovyFileBase groovyFileBase = GradleKotlinVersionInfoProvider.access$getGradleFile(this.this$0, this.$module);
                if (groovyFileBase != null) {
                    GroovyFileBase groovyFileBase2;
                    GroovyFileBase it = groovyFileBase2 = groovyFileBase;
                    collection = DifferentStdlibGradleVersionInspection.Companion.getKotlinStdlibVersions(it, FacetUtilsKt.getMavenLibraryIds(this.$targetPlatform));
                } else {
                    collection = null;
                }
                return collection;
            }
            {
                this.this$0 = gradleKotlinVersionInfoProvider;
                this.$module = module;
                this.$targetPlatform = targetPlatformKind;
                super(0);
            }
        });
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public static final /* synthetic */ GroovyFileBase access$getGradleFile(GradleKotlinVersionInfoProvider $this, @NotNull Module module) {
        return $this.getGradleFile(module);
    }
}

