/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u001c\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"gradlePropertyFiles", "", "", "configureFacetByGradleModule", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "sourceSetNode", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "ideModule", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "detectPlatformByLibrary", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "detectPlatformByPlugin", "findKotlinCoroutinesProperty", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class KotlinGradleSourceSetDataServiceKt {
    private static final List<String> gradlePropertyFiles = CollectionsKt.listOf((Object[])new String[]{"local.properties", "gradle.properties"});

    /*
     * Enabled aggressive block sorting
     */
    private static final TargetPlatformKind<?> detectPlatformByPlugin(DataNode<ModuleData> moduleNode) {
        block5: {
            TargetPlatformKind targetPlatformKind;
            block7: {
                block6: {
                    String string;
                    String string2 = string = KotlinGradleProjectResolverExtensionKt.getPlatformPluginId(moduleNode);
                    if (string2 == null) break block5;
                    switch (string2.hashCode()) {
                        case 107431447: {
                            if (!string.equals("kotlin-platform-js")) return null;
                            break block6;
                        }
                        case -964592237: {
                            if (!string.equals("kotlin-platform-jvm")) return null;
                            break;
                        }
                        case 1252084665: {
                            if (!string.equals("kotlin-platform-common")) return null;
                            break block7;
                        }
                    }
                    targetPlatformKind = TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_6);
                    return targetPlatformKind;
                }
                targetPlatformKind = TargetPlatformKind.JavaScript.INSTANCE;
                return targetPlatformKind;
            }
            targetPlatformKind = TargetPlatformKind.Common.INSTANCE;
            return targetPlatformKind;
        }
        return null;
    }

    private static final TargetPlatformKind<?> detectPlatformByLibrary(DataNode<ModuleData> moduleNode) {
        Object v0;
        block1: {
            Iterable $receiver$iv = TargetPlatformKind.Companion.getALL_PLATFORMS();
            for (Object element$iv : $receiver$iv) {
                TargetPlatformKind it = (TargetPlatformKind)element$iv;
                if (!(DifferentStdlibGradleVersionInspectionKt.getResolvedKotlinStdlibVersionByModuleData(moduleNode, FacetUtilsKt.getMavenLibraryIds(it)) != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final KotlinFacet configureFacetByGradleModule(DataNode<ModuleData> moduleNode, DataNode<GradleSourceSetData> sourceSetNode, Module ideModule, IdeModifiableModelsProvider modelsProvider) {
        List<String> defaultCompilerArguments;
        Object object;
        KotlinFacet kotlinFacet;
        block10: {
            block9: {
                Object object2;
                Object it;
                String string;
                TargetPlatformKind<?> platformKind;
                NodeWithData nodeWithData;
                NodeWithData p1;
                Key key = BuildScriptClasspathData.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BuildScriptClasspathData.KEY");
                Object object3 = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(moduleNode, key));
                if (object3 == null || (object3 = (BuildScriptClasspathData)((NodeWithData)object3).getData()) == null || (object3 = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)(p1 = (nodeWithData = object3)))) == null) {
                    return null;
                }
                Object compilerVersion = object3;
                TargetPlatformKind<?> targetPlatformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByPlugin(moduleNode);
                if (targetPlatformKind == null) {
                    targetPlatformKind = platformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByLibrary(moduleNode);
                }
                if ((string = KotlinGradleProjectResolverExtensionKt.getCoroutines(moduleNode)) == null) {
                    Project project = ideModule.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ideModule.project");
                    string = KotlinGradleSourceSetDataServiceKt.findKotlinCoroutinesProperty(project);
                }
                LanguageFeature.State coroutinesProperty = CoroutineSupport.INSTANCE.byCompilerArgument(string);
                kotlinFacet = FacetUtilsKt.getOrCreateFacet(ideModule, modelsProvider, false);
                FacetUtilsKt.configureFacet(kotlinFacet, (String)compilerVersion, coroutinesProperty, platformKind, modelsProvider);
                object = sourceSetNode;
                if (object == null || (object = (GradleSourceSetData)object.getData()) == null || (object = object.getId()) == null) break block9;
                Object object4 = it = (object2 = object);
                int n = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)it), (char)':', (int)0, (boolean)false, (int)6, null) + 1;
                Object object5 = object4;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object5).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                object = string2;
                if (string2 != null) break block10;
            }
            object = "main";
        }
        GradleSourceSetData sourceSetName = object;
        Map<String, List<String>> map2 = KotlinGradleProjectResolverExtensionKt.getCurrentCompilerArgumentsBySourceSet(moduleNode);
        List<String> currentCompilerArguments = map2 != null ? map2.get(sourceSetName) : null;
        Object object6 = KotlinGradleProjectResolverExtensionKt.getDefaultCompilerArgumentsBySourceSet(moduleNode);
        if (object6 == null || (object6 = object6.get(sourceSetName)) == null) {
            object6 = defaultCompilerArguments = CollectionsKt.emptyList();
        }
        if (currentCompilerArguments != null) {
            FacetUtilsKt.parseCompilerArgumentsToFacet(currentCompilerArguments, defaultCompilerArguments, kotlinFacet);
        }
        return kotlinFacet;
    }

    private static final String findKotlinCoroutinesProperty(Project project) {
        for (String propertyFileName : gradlePropertyFiles) {
            String string;
            VirtualFile propertyFile;
            if (project.getBaseDir().findChild(propertyFileName) == null) {
                continue;
            }
            Properties properties2 = new Properties();
            properties2.load(propertyFile.getInputStream());
            String string2 = properties2.getProperty("kotlin.coroutines");
            if (string2 == null) continue;
            String it = string = string2;
            return it;
        }
        return CoroutineSupport.INSTANCE.getCompilerArgument(LanguageFeature.Coroutines.getDefaultState());
    }

    @Nullable
    public static final /* synthetic */ KotlinFacet access$configureFacetByGradleModule(@NotNull DataNode moduleNode, @Nullable DataNode sourceSetNode, @NotNull Module ideModule, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return KotlinGradleSourceSetDataServiceKt.configureFacetByGradleModule((DataNode<ModuleData>)moduleNode, (DataNode<GradleSourceSetData>)sourceSetNode, ideModule, modelsProvider);
    }
}

