/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.NotPropertiesService;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertToBlockBodyIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UsePropertyAccessSyntaxInspection;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.NotPropertyListKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0016\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bJH\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010%\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/UsePropertyAccessSyntaxIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "propertyName", "Lorg/jetbrains/kotlin/name/Name;", "checkWillResolveToProperty", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "property", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "facade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "detectPropertyNameToUse", "callExpression", "findSyntheticProperty", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "isApplicableTo", "replaceWithPropertyGet", "replaceWithPropertySet", "idea"})
public final class UsePropertyAccessSyntaxIntention
extends SelfTargetingOffsetIndependentIntention<KtCallExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.detectPropertyNameToUse(element2) != null;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Name name2 = this.detectPropertyNameToUse(element2);
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        this.applyTo(element2, name2);
    }

    @NotNull
    public final KtExpression applyTo(@NotNull KtCallExpression element2, @NotNull Name propertyName) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        List<KtValueArgument> arguments2 = element2.getValueArguments();
        switch (arguments2.size()) {
            case 0: {
                ktExpression = this.replaceWithPropertyGet(element2, propertyName);
                break;
            }
            case 1: {
                ktExpression = this.replaceWithPropertySet(element2, propertyName);
                break;
            }
            default: {
                String string = "More than one argument in call to accessor";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return ktExpression;
    }

    @Nullable
    public final Name detectPropertyNameToUse(@NotNull KtCallExpression callExpression2) {
        boolean isSetUsage;
        KotlinType expectedType;
        Object notProperties;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)callExpression2, (String)"callExpression");
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
        if ((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtSuperExpression) {
            return null;
        }
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression callee = ktNameReferenceExpression;
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(callExpression2);
        BindingContext bindingContext2 = resolutionFacade.analyze(callExpression2, BodyResolveMode.PARTIAL_FOR_COMPLETION);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
            return null;
        }
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        IntentionBasedInspection intentionBasedInspection = this.getInspection();
        if (!(intentionBasedInspection instanceof UsePropertyAccessSyntaxInspection)) {
            intentionBasedInspection = null;
        }
        if ((object = (UsePropertyAccessSyntaxInspection)intentionBasedInspection) == null || (object = object.getFqNameList()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = notProperties = NotPropertiesService.Companion.getNotProperties((PsiElement)callExpression2);
        }
        if (NotPropertyListKt.shouldNotConvertToProperty(function2, (Set<FqNameUnsafe>)notProperties)) {
            return null;
        }
        LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)callExpression2, bindingContext2, resolutionFacade);
        SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = this.findSyntheticProperty(function2, resolutionFacade.getFrontendService(SyntheticScopes.class));
        if (syntheticJavaPropertyDescriptor == null) {
            return null;
        }
        SyntheticJavaPropertyDescriptor property2 = syntheticJavaPropertyDescriptor;
        DataFlowInfo dataFlowInfo = BindingContextUtilsKt.getDataFlowInfoBefore(bindingContext2, (PsiElement)callee);
        KtExpression qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(callExpression2);
        KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.EXPECTED_EXPRESSION_TYPE, qualifiedExpression);
        if (kotlinType == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
            kotlinType = expectedType = (KotlinType)simpleType2;
        }
        if (!this.checkWillResolveToProperty(resolvedCall3, property2, bindingContext2, resolutionScope, dataFlowInfo, expectedType, resolutionFacade)) {
            return null;
        }
        boolean bl = isSetUsage = callExpression2.getValueArguments().size() == 1;
        if (isSetUsage && BindingContextUtilsKt.isUsedAsExpression(qualifiedExpression, bindingContext2)) {
            PsiElement parent2 = qualifiedExpression.getParent();
            if (!(parent2 instanceof KtDeclarationWithBody) || Intrinsics.areEqual((Object)qualifiedExpression, (Object)((KtDeclarationWithBody)parent2).getBodyExpression()) ^ true) {
                return null;
            }
            KotlinType kotlinType2 = function2.getReturnType();
            if (Intrinsics.areEqual((Object)(kotlinType2 != null ? Boolean.valueOf(TypeUtilsKt.isUnit(kotlinType2)) : null), (Object)true) ^ true) {
                return null;
            }
        }
        if (isSetUsage && Intrinsics.areEqual((Object)property2.getType(), (Object)((ValueParameterDescriptor)CollectionsKt.single(function2.getValueParameters())).getType()) ^ true) {
            boolean bl2;
            block22: {
                KtExpression ktExpression2;
                KtExpression qualifiedExpressionCopy = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)qualifiedExpression);
                KtExpression ktExpression3 = qualifiedExpressionCopy;
                if (!(ktExpression3 instanceof KtQualifiedExpression)) {
                    ktExpression3 = null;
                }
                if ((ktExpression2 = (KtQualifiedExpression)ktExpression3) == null || (ktExpression2 = ktExpression2.getSelectorExpression()) == null) {
                    ktExpression2 = qualifiedExpressionCopy;
                }
                if (ktExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                }
                KtCallExpression callExpressionCopy = (KtCallExpression)ktExpression2;
                Name name2 = property2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.name");
                KtExpression newExpression2 = this.applyTo(callExpressionCopy, name2);
                DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext2, "Temporary trace", false, null, 12, null);
                BindingContext newBindingContext = AnalyzerUtilKt.analyzeInContext$default(newExpression2, resolutionScope, callExpression2, bindingTrace, dataFlowInfo, expectedType, true, null, null, 192, null);
                Iterable $receiver$iv = newBindingContext.getDiagnostics();
                for (Object element$iv : $receiver$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    if (!Intrinsics.areEqual((Object)((Object)it.getSeverity()), (Object)((Object)Severity.ERROR))) continue;
                    bl2 = true;
                    break block22;
                }
                bl2 = false;
            }
            if (bl2) {
                return null;
            }
        }
        return property2.getName();
    }

    private final boolean checkWillResolveToProperty(ResolvedCall<? extends CallableDescriptor> resolvedCall2, SyntheticJavaPropertyDescriptor property2, BindingContext bindingContext2, LexicalScope resolutionScope, DataFlowInfo dataFlowInfo, KotlinType expectedType, ResolutionFacade facade) {
        Project project = resolvedCall2.getCall().getCallElement().getProject();
        DelegatingCall newCall2 = new DelegatingCall(project, property2, resolvedCall2, resolvedCall2.getCall()){
            private final KtExpression newCallee;
            final /* synthetic */ Project $project;
            final /* synthetic */ SyntheticJavaPropertyDescriptor $property;
            final /* synthetic */ ResolvedCall $resolvedCall;

            @NotNull
            public KtExpression getCalleeExpression() {
                return this.newCallee;
            }

            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @NotNull
            public List<ValueArgument> getValueArguments() {
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                return CollectionsKt.emptyList();
            }
            {
                this.$project = $captured_local_variable$0;
                this.$property = $captured_local_variable$1;
                this.$resolvedCall = $captured_local_variable$2;
                super($super_call_param$3);
                Project project = $captured_local_variable$0;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                Object[] objectArray = new Object[1];
                Name name2 = $captured_local_variable$1.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.name");
                objectArray[0] = name2;
                this.newCallee = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0", objectArray, false, 4, null);
            }
        };
        DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext2, "Temporary trace", false, null, 12, null);
        BasicCallResolutionContext context = BasicCallResolutionContext.create(bindingTrace, resolutionScope, newCall2, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false);
        ResolutionFacade $receiver$iv = facade;
        CallResolver callResolver = $receiver$iv.getFrontendService(CallResolver.class);
        OverloadResolutionResults<VariableDescriptor> result2 = callResolver.resolveSimpleProperty(context);
        return result2.isSuccess() && Intrinsics.areEqual((Object)result2.getResultingDescriptor().getOriginal(), (Object)property2);
    }

    private final SyntheticJavaPropertyDescriptor findSyntheticProperty(FunctionDescriptor function2, SyntheticScopes syntheticScopes) {
        SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = SyntheticJavaPropertyDescriptor.Companion.findByGetterOrSetter(function2, syntheticScopes);
        if (syntheticJavaPropertyDescriptor != null) {
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor2;
            SyntheticJavaPropertyDescriptor it = syntheticJavaPropertyDescriptor2 = syntheticJavaPropertyDescriptor;
            return it;
        }
        Iterator<? extends FunctionDescriptor> iterator2 = function2.getOverriddenDescriptors().iterator();
        while (iterator2.hasNext()) {
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor3;
            FunctionDescriptor overridden;
            FunctionDescriptor functionDescriptor2 = overridden = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"overridden");
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor4 = this.findSyntheticProperty(functionDescriptor2, syntheticScopes);
            if (syntheticJavaPropertyDescriptor4 == null) continue;
            SyntheticJavaPropertyDescriptor it = syntheticJavaPropertyDescriptor3 = syntheticJavaPropertyDescriptor4;
            return it;
        }
        return null;
    }

    private final KtExpression replaceWithPropertyGet(KtCallExpression callExpression2, Name propertyName) {
        Object object;
        PsiElement $receiver$iv = (PsiElement)callExpression2;
        KtExpression newExpression2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callExpression2, false, 2, null).createExpression(RenderingUtilsKt.render(propertyName));
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression2);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return (KtExpression)object;
    }

    private final KtExpression replaceWithPropertySet(KtCallExpression callExpression2, Name propertyName) {
        Object object;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
        KtExpression call2 = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression2;
        PsiElement callParent = call2.getParent();
        KtCallExpression callToConvert = callExpression2;
        if (callParent instanceof KtDeclarationWithBody && Intrinsics.areEqual((Object)call2, (Object)((KtDeclarationWithBody)callParent).getBodyExpression())) {
            KtCallExpression ktCallExpression;
            Object object2;
            KtExpression firstStatement;
            KtExpression ktExpression;
            PsiElement psiElement2 = callParent;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"callParent");
            ConvertToBlockBodyIntention.Companion.convert((KtDeclarationWithBody)psiElement2);
            KtExpression ktExpression2 = ((KtDeclarationWithBody)callParent).getBodyExpression();
            if (!(ktExpression2 instanceof KtBlockExpression)) {
                ktExpression2 = null;
            }
            if (!((ktExpression = (firstStatement = (object2 = (KtBlockExpression)ktExpression2) != null && (object2 = ((KtBlockExpression)object2).getStatements()) != null ? (KtExpression)CollectionsKt.first((List)object2) : null)) instanceof KtQualifiedExpression)) {
                ktExpression = null;
            }
            KtQualifiedExpression ktQualifiedExpression2 = (KtQualifiedExpression)ktExpression;
            KtExpression ktExpression3 = ktQualifiedExpression2 != null ? ktQualifiedExpression2.getSelectorExpression() : null;
            if (!(ktExpression3 instanceof KtCallExpression)) {
                ktExpression3 = null;
            }
            if ((ktCallExpression = (KtCallExpression)ktExpression3) == null) {
                KtExpression ktExpression4 = firstStatement;
                if (!(ktExpression4 instanceof KtCallExpression)) {
                    ktExpression4 = null;
                }
                ktCallExpression = (KtCallExpression)ktExpression4;
            }
            if (ktCallExpression == null) {
                throw (Throwable)new IllegalStateException("Unexpected contents of function after conversion: " + ((KtDeclarationWithBody)callParent).getText());
            }
            callToConvert = ktCallExpression;
        }
        KtQualifiedExpression qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callToConvert);
        KtValueArgument argument2 = (KtValueArgument)CollectionsKt.single(callToConvert.getValueArguments());
        if (qualifiedExpression != null) {
            Object object3;
            String string;
            KtQualifiedExpression ktQualifiedExpression3 = qualifiedExpression;
            if (ktQualifiedExpression3 instanceof KtDotQualifiedExpression) {
                string = "$0.$1=$2";
            } else if (ktQualifiedExpression3 instanceof KtSafeQualifiedExpression) {
                string = "$0?.$1=$2";
            } else {
                throw (Throwable)new IllegalStateException(qualifiedExpression.toString());
            }
            String pattern = string;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callToConvert, false, 2, null);
            Object[] objectArray = new Object[3];
            objectArray[0] = qualifiedExpression.getReceiverExpression();
            objectArray[1] = propertyName;
            KtExpression ktExpression = argument2.getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"argument.getArgumentExpression()!!");
            objectArray[2] = ktExpression;
            KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, pattern, objectArray, false, 4, null);
            PsiElement $receiver$iv = (PsiElement)qualifiedExpression;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression2);
            if (result$iv instanceof KtExpression) {
                object3 = result$iv;
            } else {
                PsiElement psiElement3 = result$iv;
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object3 = ((KtParenthesizedExpression)psiElement3).getExpression();
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            return (KtExpression)object3;
        }
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callToConvert, false, 2, null);
        Object[] objectArray = new Object[2];
        objectArray[0] = propertyName;
        KtExpression ktExpression = argument2.getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"argument.getArgumentExpression()!!");
        objectArray[1] = ktExpression;
        KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0=$1", objectArray, false, 4, null);
        PsiElement $receiver$iv = (PsiElement)callToConvert;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression3);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return (KtExpression)object;
    }

    public UsePropertyAccessSyntaxIntention() {
        super(KtCallExpression.class, "Use property access syntax", null, 4, null);
    }
}

