/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinIndexUtil;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinExactPackagesIndex
extends StringStubIndexExtension<KtFile> {
    private static final StubIndexKey<String, KtFile> KEY = KotlinIndexUtil.createIndexKey(KotlinExactPackagesIndex.class);
    private static final KotlinExactPackagesIndex ourInstance = new KotlinExactPackagesIndex();

    @NotNull
    public static KotlinExactPackagesIndex getInstance() {
        KotlinExactPackagesIndex kotlinExactPackagesIndex = ourInstance;
        if (kotlinExactPackagesIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "getInstance"));
        }
        return kotlinExactPackagesIndex;
    }

    private KotlinExactPackagesIndex() {
    }

    @NotNull
    public StubIndexKey<String, KtFile> getKey() {
        StubIndexKey<String, KtFile> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "getKey"));
        }
        return stubIndexKey;
    }

    @NotNull
    public Collection<KtFile> get(@NotNull String fqName2, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "get"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "get"));
        }
        Collection collection = StubIndex.getElements(KEY, (Object)fqName2, (Project)project, (GlobalSearchScope)scope2, KtFile.class);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinExactPackagesIndex", "get"));
        }
        return collection;
    }
}

