/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

public class FragmentDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ValidFragment", "Fragment not instantiatable", "From the Fragment documentation:\n*Every* fragment must have an empty constructor, so it can be instantiated when restoring its activity's state. It is strongly recommended that subclasses do not have other constructors with parameters, since these constructors will not be called when the fragment is re-instantiated; instead, arguments can be supplied by the caller with `setArguments(Bundle)` and later retrieved by the Fragment with `getArguments()`.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(FragmentDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/app/Fragment.html#Fragment()");

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment");
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass node) {
        if (node instanceof UAnonymousClass) {
            String message = "Fragments should be static such that they can be re-instantiated by the system, and anonymous classes are not static";
            context.reportUast(ISSUE, (UElement)node, context.getUastNameLocation((UElement)node), message);
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)node)) {
            return;
        }
        if (!evaluator.isPublic((PsiModifierListOwner)node)) {
            String message = String.format("This fragment class should be public (%1$s)", node.getQualifiedName());
            context.reportUast(ISSUE, (UElement)node, context.getUastNameLocation((UElement)node), message);
            return;
        }
        if (node.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)node)) {
            String message = String.format("This fragment inner class should be static (%1$s)", node.getQualifiedName());
            context.reportUast(ISSUE, (UElement)node, context.getUastNameLocation((UElement)node), message);
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        for (PsiMethod constructor : node.getConstructors()) {
            Location location;
            hasConstructor = true;
            if (constructor.getParameterList().getParametersCount() == 0) {
                if (evaluator.isPublic((PsiModifierListOwner)constructor)) {
                    hasDefaultConstructor = true;
                    continue;
                }
                location = context.getNameLocation((PsiElement)constructor);
                context.report(ISSUE, (PsiElement)constructor, location, "The default constructor must be public");
                hasDefaultConstructor = true;
                continue;
            }
            location = context.getNameLocation((PsiElement)constructor);
            String message = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
            context.report(ISSUE, (PsiElement)constructor, location, message);
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message = String.format("This fragment should provide a default constructor (a public constructor with no arguments) (`%1$s`)", node.getQualifiedName());
            context.reportUast(ISSUE, (UElement)node, context.getNameLocation((PsiElement)node), message);
        }
    }
}

