/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class PanelContentUI
implements ContentUI {
    private JPanel myPanel;

    PanelContentUI() {
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanel;
    }

    @Override
    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/execution/dashboard/PanelContentUI", "setManager"));
        }
        manager.addContentManagerListener(new ContentManagerAdapter(){

            @Override
            public void selectionChanged(ContentManagerEvent event) {
                PanelContentUI.this.initUI();
                if (ContentManagerEvent.ContentOperation.add == event.getOperation()) {
                    PanelContentUI.this.showContent(event.getContent());
                } else if (ContentManagerEvent.ContentOperation.remove == event.getOperation()) {
                    PanelContentUI.this.hideContent();
                }
            }
        });
    }

    private void initUI() {
        if (this.myPanel != null) {
            return;
        }
        this.myPanel = new JPanel(new BorderLayout());
    }

    private void showContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/dashboard/PanelContentUI", "showContent"));
        }
        if (this.myPanel.getComponentCount() != 1 || this.myPanel.getComponent(0) != content.getComponent()) {
            this.myPanel.removeAll();
            this.myPanel.add((Component)content.getComponent(), "Center");
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }
    }

    private void hideContent() {
        this.myPanel.removeAll();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @Override
    public boolean isSingleSelection() {
        return true;
    }

    @Override
    public boolean isToSelectAddedContent() {
        return true;
    }

    @Override
    public boolean canBeEmptySelection() {
        return false;
    }

    @Override
    public void beforeDispose() {
    }

    @Override
    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/dashboard/PanelContentUI", "canChangeSelectionTo"));
        }
        return true;
    }

    @Override
    @NotNull
    public String getCloseActionName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/PanelContentUI", "getCloseActionName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getCloseAllButThisActionName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/PanelContentUI", "getCloseAllButThisActionName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getPreviousContentActionName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/PanelContentUI", "getPreviousContentActionName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getNextContentActionName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/PanelContentUI", "getNextContentActionName"));
        }
        return "";
    }

    public void dispose() {
    }
}

