/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableBase<UI extends ConfigurableUi<S>, S>
implements SearchableConfigurable,
Configurable.NoScroll {
    private final String id;
    private final String displayName;
    private final String helpTopic;
    private UI ui;

    protected ConfigurableBase(@NotNull String id, @NotNull String displayName, @Nullable String helpTopic) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ConfigurableBase", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/openapi/options/ConfigurableBase", "<init>"));
        }
        this.id = id;
        this.displayName = displayName;
        this.helpTopic = helpTopic;
    }

    @Override
    @NotNull
    public final String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableBase", "getId"));
        }
        return string;
    }

    @Override
    @Nls
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public final String getHelpTopic() {
        return this.helpTopic;
    }

    @NotNull
    protected abstract S getSettings();

    @Override
    public void reset() {
        if (this.ui != null) {
            this.ui.reset(this.getSettings());
        }
    }

    @Override
    @Nullable
    public final JComponent createComponent() {
        if (this.ui == null) {
            this.ui = this.createUi();
        }
        return this.ui.getComponent();
    }

    protected abstract UI createUi();

    @Override
    public final boolean isModified() {
        return this.ui != null && this.ui.isModified(this.getSettings());
    }

    @Override
    public final void apply() throws ConfigurationException {
        if (this.ui != null) {
            this.ui.apply(this.getSettings());
        }
    }

    @Override
    public void disposeUIResources() {
        UI ui = this.ui;
        if (ui != null) {
            this.ui = null;
            if (ui instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)ui));
            }
        }
    }
}

