/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.util.config.AbstractProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ListProperty<T>
extends AbstractProperty<List<T>> {
    private final String myName;

    public ListProperty(@NonNls String name) {
        this.myName = name;
    }

    public static <T> ListProperty<T> create(@NonNls String name) {
        return new ListProperty<T>(name);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public List<T> getDefault(AbstractProperty.AbstractPropertyContainer container) {
        return Collections.emptyList();
    }

    @Override
    public List<T> copy(List<T> value) {
        return Collections.unmodifiableList(value);
    }

    public ArrayList<T> getModifiableList(AbstractProperty.AbstractPropertyContainer container) {
        ArrayList modifiableList;
        List list = (List)this.get(container);
        if (list instanceof ArrayList) {
            modifiableList = (ArrayList)list;
        } else {
            modifiableList = new ArrayList(list);
            this.set(container, modifiableList);
        }
        for (int i2 = modifiableList.size() - 1; i2 >= 0; --i2) {
            if (modifiableList.get(i2) != null) continue;
            modifiableList.remove(i2);
        }
        return modifiableList;
    }

    public void clearList(AbstractProperty.AbstractPropertyContainer container) {
        this.getModifiableList(container).clear();
    }

    public Iterator<T> getIterator(AbstractProperty.AbstractPropertyContainer container) {
        return ((List)this.get(container)).iterator();
    }
}

