/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceHtmlTagWithCssAction
implements LocalQuickFix {
    @NonNls
    private final String myName;
    @NonNls
    private static final Map<String, String> ourTagToCssMap = new HashMap();
    @NonNls
    private static final String BODY = "body";
    @NonNls
    private static final String HTML = "html";
    @NonNls
    private static final String HEAD = "head";

    public ReplaceHtmlTagWithCssAction(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.css.quickfix.text", (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "getText"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.css.quickfix.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "getFamilyName"));
        }
        return string;
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, boolean blocklevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "generateContainingElements"));
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, blocklevel ? "div" : "span");
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    private static void addCssAttribute(XmlTag tag, String name) {
        String s = tag.getAttributeValue("style");
        String addString = ourTagToCssMap.get(name);
        if (s == null) {
            s = addString;
        } else {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (Character.isSpaceChar(s.charAt(i))) continue;
                if (s.charAt(i) == ';') break;
                s = s + ';';
                break;
            }
            s = s + " " + addString;
        }
        tag.setAttribute("style", s);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        boolean toReplaceWithSpan;
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction", "applyFix"));
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && ourTagToCssMap.containsKey(((XmlTag)parent).getLocalName().toLowerCase())); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        boolean bl = toReplaceWithSpan = parentTag == null || HtmlUtil.isInlineTagContainer((String)parentTag.getLocalName());
        if (!toReplaceWithSpan) {
            String name = parentTag.getLocalName().toLowerCase();
            if (BODY.equals(name) || HTML.equals(name) || HEAD.equals(name)) {
                toReplaceWithSpan = true;
            } else {
                int childrenTagCount = 0;
                for (PsiElement child : parentTag.getChildren()) {
                    if (child instanceof XmlTag) {
                        ++childrenTagCount;
                    }
                    if (!(child instanceof XmlText)) continue;
                    childrenTagCount += 2;
                }
                toReplaceWithSpan = childrenTagCount > 1;
            }
        }
        String tagName = ((XmlTag)parent).getLocalName().toLowerCase();
        if (!toReplaceWithSpan) {
            ReplaceHtmlTagWithCssAction.addCssAttribute(parentTag, tagName);
            PsiElement[] elements = tag.getChildren();
            boolean started = false;
            for (PsiElement psiElement : elements) {
                if (psiElement instanceof XmlToken) {
                    XmlToken xmlToken = (XmlToken)psiElement;
                    IElementType type = xmlToken.getTokenType();
                    if (type == XmlTokenType.XML_TAG_END) {
                        started = true;
                        continue;
                    }
                    if (type == XmlTokenType.XML_END_TAG_START) break;
                }
                if (!started) continue;
                parentTag.addBefore(psiElement, (PsiElement)tag);
            }
            tag.delete();
        } else {
            PsiElement[] elements = ReplaceHtmlTagWithCssAction.generateContainingElements(project, HtmlUtil.isHtmlBlockTag((String)tagName));
            int cnt = 0;
            for (PsiElement psiElement : tag.getChildren()) {
                IElementType type;
                if (!(psiElement instanceof XmlToken) || (type = ((XmlToken)psiElement).getTokenType()) != XmlTokenType.XML_NAME) continue;
                psiElement.replace(elements[cnt++]);
            }
            ReplaceHtmlTagWithCssAction.addCssAttribute(tag, tagName);
        }
    }

    static {
        ourTagToCssMap.put("center", "text-align: center;");
        ourTagToCssMap.put("i", "font-style: italic;");
        ourTagToCssMap.put("b", "font-weight: bold;");
        ourTagToCssMap.put("big", "font-size: large;");
        ourTagToCssMap.put("small", "font-size: small;");
        ourTagToCssMap.put("tt", "font-family: monospace;");
        ourTagToCssMap.put("u", "text-decoration: underline;");
        ourTagToCssMap.put("s", "text-decoration: line-through;");
        ourTagToCssMap.put("strike", "text-decoration: line-through;");
        ourTagToCssMap.put("xmp", "white-space: pre;");
    }
}

