/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import org.jetbrains.annotations.NotNull;

public class CssPsiTreeChangeProcessor
extends PsiTreeChangePreprocessorBase {
    public static final SimpleModificationTracker CSS_MODIFICATION_TRACKER = new SimpleModificationTracker();

    public CssPsiTreeChangeProcessor(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "<init>"));
        }
        super(psiManager);
    }

    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "acceptsEvent"));
        }
        return event.getFile() instanceof StylesheetFile || CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)event.getFile());
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "onTreeChanged"));
        }
        if (event.getParent() instanceof PsiFileSystemItem) {
            CSS_MODIFICATION_TRACKER.incModificationCount();
        } else {
            PsiElement child = event.getChild();
            if (child != null && !(child instanceof SyntheticElement) && CssPsiUtil.getStylesheetLanguage((PsiElement)child) != null) {
                CSS_MODIFICATION_TRACKER.incModificationCount();
            }
        }
        super.onTreeChanged(event);
    }

    public boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "isOutOfCodeBlock"));
        }
        if (CssPsiUtil.getStylesheetLanguage((PsiElement)element) == null) {
            return false;
        }
        int blockCount = 0;
        for (PsiElement p : SyntaxTraverser.psiApi().parents((Object)element)) {
            if (p instanceof CssSelectorList) {
                return true;
            }
            if (!(p instanceof CssBlock)) continue;
            ++blockCount;
        }
        return blockCount != 1;
    }
}

