/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.include;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    @Override
    @NotNull
    public String getId() {
        String string = CSSLanguage.INSTANCE.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/include/CssFileIncludeProvider", "getId"));
        }
        return string;
    }

    @Override
    public boolean acceptFile(VirtualFile file) {
        return file.isInLocalFileSystem() && file.getFileType() == CssFileType.INSTANCE;
    }

    @Override
    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/psi/css/include/CssFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)CssFileType.INSTANCE);
    }

    @Override
    protected boolean hasImports(@NotNull CharSequence hostFileText) {
        if (hostFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileText", "com/intellij/psi/css/include/CssFileIncludeProvider", "hasImports"));
        }
        return CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@import", (int)0) >= 0;
    }

    @Override
    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/include/CssFileIncludeProvider", "addImports"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/psi/css/include/CssFileIncludeProvider", "addImports"));
        }
        if (hostFileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileExt", "com/intellij/psi/css/include/CssFileIncludeProvider", "addImports"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "com/intellij/psi/css/include/CssFileIncludeProvider", "addImports"));
        }
        if (importUriExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUriExt", "com/intellij/psi/css/include/CssFileIncludeProvider", "addImports"));
        }
        boolean addExtension = !hostFileExt.equalsIgnoreCase(importUriExt);
        result.add(new FileIncludeInfo(addExtension ? importUri + "." + hostFileExt : importUri));
    }

    @Override
    @NotNull
    protected Language getLanguage() {
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/include/CssFileIncludeProvider", "getLanguage"));
        }
        return cSSLanguage;
    }
}

