/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.WSUtilsBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvokeExternalCodeUtil {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.invokeexternalcode");
    public static final Map<String, String> ourBasePath2TempEndorsedDirectory = new HashMap<String, String>();
    public static final String CLASS_PATH_SEPARATOR = System.getProperty("path.separator");

    private InvokeExternalCodeUtil() {
    }

    private static String buildDescriptionFromCommandsAndLaunchDir(File dir, String[] commands) {
        StringBuilder b = new StringBuilder();
        if (dir != null) {
            b.append(dir.getAbsolutePath()).append(">");
        }
        int initialLen = b.length();
        for (String s : commands) {
            if (initialLen != b.length()) {
                b.append(" ");
            }
            b.append(s);
        }
        return b.toString();
    }

    public static String toAntPath(@NotNull String outputPath) {
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/ws/utils/InvokeExternalCodeUtil", "toAntPath"));
        }
        return outputPath.replace(File.separatorChar, '/');
    }

    public static void navigateToPackage(@NotNull Module moduleForFile, @NotNull String packagePrefix, @NotNull String outputPath) {
        if (moduleForFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleForFile", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        InvokeExternalCodeUtil.navigateToPackage(moduleForFile, packagePrefix, outputPath, true);
    }

    public static void navigateToPackage(@NotNull Module moduleForFile, @NotNull String packagePrefix, @NotNull String outputPath, boolean requestFocus) {
        PsiDirectory[] directories;
        if (moduleForFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleForFile", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/ws/utils/InvokeExternalCodeUtil", "navigateToPackage"));
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)moduleForFile.getProject()).findPackage(packagePrefix);
        if (aPackage != null && (directories = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)moduleForFile))).length > 0) {
            PsiDirectory chosenDirectory = directories[0];
            VirtualFile relativeFile = UriUtil.findRelativeFile((String)outputPath, null);
            if (relativeFile != null) {
                for (PsiDirectory dir : directories) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)dir.getVirtualFile(), (boolean)false)) continue;
                    chosenDirectory = dir;
                    break;
                }
            }
            chosenDirectory.navigate(requestFocus);
        }
    }

    public static void invokeExternalProcess(ExternalProcessHandler handler, Project project) throws ExternalCodeException {
        InvokeExternalCodeUtil.invokeExternalProcess(handler, project, null, null, null, null);
    }

    public static void invokeExternalProcess2(ExternalProcessHandler handler, Project project, Runnable actionAtSuccess, Consumer<Exception> actionAtFailure, Computable<Boolean> isRerunAvailable, Runnable editAndRunAgain) {
        assert (actionAtSuccess != null);
        InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, isRerunAvailable, editAndRunAgain);
    }

    public static void invokeExternalProcess(ExternalProcessHandler handler, Project project, Runnable actionAtSuccess, Consumer<Exception> actionAtFailure, Computable<Boolean> isRerunAvailable, Runnable editAndRunAgain) throws ExternalCodeException {
        if (actionAtSuccess != null) {
            InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, isRerunAvailable, editAndRunAgain);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ExternalCodeException[] result = new ExternalCodeException[1];
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    InvokeExternalCodeUtil.doInvoke(handler);
                }
                catch (ExternalCodeException e) {
                    result[0] = e;
                }
            }, "Launching " + handler.getName(), true, project);
            if (result[0] != null) {
                throw result[0];
            }
        } else {
            InvokeExternalCodeUtil.doInvoke(handler);
        }
    }

    public static void runViaConsole(final @NotNull ExternalProcessHandler handler, @NotNull Project project, @NotNull Runnable actionAtSuccess, @NotNull Consumer<Exception> actionAtFailure, @Nullable Computable<Boolean> rerunAvailable, Runnable editAndRunAgain) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ws/utils/InvokeExternalCodeUtil", "runViaConsole"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/InvokeExternalCodeUtil", "runViaConsole"));
        }
        if (actionAtSuccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtSuccess", "com/intellij/ws/utils/InvokeExternalCodeUtil", "runViaConsole"));
        }
        if (actionAtFailure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtFailure", "com/intellij/ws/utils/InvokeExternalCodeUtil", "runViaConsole"));
        }
        try {
            final OSProcessHandler processHandler = new OSProcessHandler(InvokeExternalCodeUtil.startProcess(handler), handler.describeExecution());
            final StringBuilder output = new StringBuilder();
            final StringBuilder errorOutput = new StringBuilder();
            ProcessListener processListener = new ProcessListener(){

                public void startNotified(ProcessEvent event) {
                }

                public void processTerminated(ProcessEvent event) {
                    processHandler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                    if (handler instanceof ExternalProcessHandlerBase) {
                        ((ExternalProcessHandlerBase)((Object)handler)).onProcessTerminated();
                    }
                }

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.append(event.getText());
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        errorOutput.append(event.getText());
                    }
                }
            };
            processHandler.addProcessListener(processListener);
            final ConsoleView myConsoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            myConsoleView.setHelpId(handler.getName());
            myConsoleView.addMessageFilter(new Filter(){

                public Filter.Result applyFilter(String line, int entireLength) {
                    return null;
                }
            });
            myConsoleView.attachToProcess((ProcessHandler)processHandler);
            DefaultActionGroup toolbarActions = new DefaultActionGroup();
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)myConsoleView.getComponent(), "Center");
            content.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false).getComponent(), "West");
            final RunContentDescriptor myDescriptor = new RunContentDescriptor((ExecutionConsole)myConsoleView, (ProcessHandler)processHandler, (JComponent)content, handler.getName());
            Computable isRerunAvailable = () -> processHandler.isProcessTerminated() && rerunAvailable != null && (Boolean)rerunAvailable.compute() != false ? Boolean.TRUE : Boolean.FALSE;
            CloseAction closeAction = CommonWsUtils.createRunnerAction(myDescriptor, project);
            Runnable rerun = () -> {
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$2"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$2"));
                }
                if (actionAtSuccess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtSuccess", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$2"));
                }
                if (actionAtFailure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtFailure", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$2"));
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                closeAction.actionPerformed(null);
                InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, rerunAvailable, editAndRunAgain);
            };
            toolbarActions.add((AnAction)new RerunAction(myConsoleView, rerun, (Computable<Boolean>)isRerunAvailable));
            toolbarActions.add((AnAction)new EditAndRerunAction(() -> {
                closeAction.actionPerformed(null);
                editAndRunAgain.run();
            }, (Computable<Boolean>)isRerunAvailable));
            toolbarActions.add((AnAction)closeAction);
            Runnable action = () -> {
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$5"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$5"));
                }
                if (actionAtFailure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtFailure", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$5"));
                }
                if (actionAtSuccess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtSuccess", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$runViaConsole$5"));
                }
                processHandler.startNotify();
                processHandler.waitFor();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (handler == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$null$4"));
                    }
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$null$4"));
                    }
                    if (actionAtFailure == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtFailure", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$null$4"));
                    }
                    if (actionAtSuccess == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAtSuccess", "com/intellij/ws/utils/InvokeExternalCodeUtil", "lambda$null$4"));
                    }
                    boolean showRunContent = true;
                    boolean wasErrorOutput = false;
                    try {
                        InvokeExternalCodeUtil.doFilter(handler, output.toString(), errorOutput.toString());
                        if (CompilerWorkspaceConfiguration.getInstance((Project)project).CLOSE_MESSAGE_VIEW_IF_SUCCESS) {
                            showRunContent = false;
                        }
                    }
                    catch (ExternalCodeException ex) {
                        actionAtFailure.consume((Object)ex);
                        wasErrorOutput = true;
                    }
                    if (showRunContent) {
                        RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                        CommonWsUtils.showRunContent(contentManager, myDescriptor);
                        Disposable disposable = Disposer.newDisposable();
                        project.getMessageBus().connect(disposable).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

                            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                                if (executor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/ws/utils/InvokeExternalCodeUtil$3", "contentSelected"));
                                }
                            }

                            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                                if (executor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/ws/utils/InvokeExternalCodeUtil$3", "contentRemoved"));
                                }
                                if (descriptor == myDescriptor) {
                                    Disposer.dispose((Disposable)myConsoleView);
                                }
                            }
                        });
                    }
                    if (!wasErrorOutput) {
                        Disposer.dispose((Disposable)myConsoleView);
                        actionAtSuccess.run();
                    }
                });
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(project, handler.getName(), action, null, null, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return true;
                }

                public void processSentToBackground() {
                }
            });
        }
        catch (IOException e) {
            actionAtFailure.consume((Object)e);
        }
    }

    private static Process startProcess(ExternalProcessHandler handler) throws IOException {
        String[] commands = handler.getCommands();
        if (LOG.isDebugEnabled()) {
            for (String command : commands) {
                LOG.debug(command);
            }
        }
        return Runtime.getRuntime().exec(commands, null, handler.getLaunchDir());
    }

    public static void doInvoke(ExternalProcessHandler handler) throws ExternalCodeException {
        try {
            Process process = InvokeExternalCodeUtil.startProcess(handler);
            StreamReaderThread streamReaderThreadOut = new StreamReaderThread(process.getInputStream());
            StreamReaderThread streamReaderThreadErr = new StreamReaderThread(process.getErrorStream());
            Future outThreadReadControl = ApplicationManager.getApplication().executeOnPooledThread((Runnable)streamReaderThreadOut);
            Future errThreadReadControl = ApplicationManager.getApplication().executeOnPooledThread((Runnable)streamReaderThreadErr);
            process.waitFor();
            try {
                outThreadReadControl.get();
                errThreadReadControl.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            String message = streamReaderThreadErr.builder.toString();
            String outMessage = streamReaderThreadOut.builder.toString();
            InvokeExternalCodeUtil.doFilter(handler, outMessage, message);
        }
        catch (IOException e) {
            throw new ExternalCodeException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ExternalCodeException(e.getMessage());
        }
    }

    private static void doFilter(ExternalProcessHandler handler, String outMessage, String message) throws ExternalCodeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("err:" + message);
            LOG.debug("out:" + outMessage);
        }
        if (handler.getOutputConsumer() != null && !handler.getOutputConsumer().handle(outMessage, message)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(message, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.startsWith("log4j:") || line.startsWith("Note:") || line.startsWith("Info:") || line.startsWith("BUILD FAILED") || line.startsWith(": FINEST,")) continue;
            throw new ExternalCodeException(line);
        }
    }

    public static String buildClasspathForModule(Module moduleForFile) {
        PathsList classPath = InvokeExternalCodeUtil.configureClasspath(moduleForFile);
        return classPath.getPathsString();
    }

    private static PathsList configureClasspath(Module moduleForFile) {
        JavaParameters parameters = new JavaParameters();
        try {
            parameters.configureByModule(moduleForFile, 2);
        }
        catch (CantRunException e) {
            LOG.error((Throwable)e);
        }
        return parameters.getClassPath();
    }

    public static String[] buildClasspathStringsForModule(Module moduleForFile) {
        List pathList = InvokeExternalCodeUtil.configureClasspath(moduleForFile).getPathList();
        return ArrayUtil.toStringArray((Collection)pathList);
    }

    public static class ExternalCodeException
    extends Exception {
        public ExternalCodeException(String message) {
            super(message);
            LOG.info((Throwable)this);
        }

        public ExternalCodeException(IOException ex) {
            super(ex);
            LOG.info((Throwable)this);
        }
    }

    private static class RerunAction
    extends BasicRerunAction {
        public RerunAction(ConsoleView consoleView, Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AllIcons.Actions.Rerun, rerun, isRerunAvailablePredicate);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consoleView.getComponent());
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(((Boolean)this.myRerunAvailablePredicate.compute()).booleanValue());
        }
    }

    private static class EditAndRerunAction
    extends BasicRerunAction {
        public EditAndRerunAction(Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(WSUtilsBundle.message("edit.refresh.action.text", new Object[0]), WSUtilsBundle.message("edit.refresh.action.text", new Object[0]), AllIcons.Actions.EditSource, rerun, isRerunAvailablePredicate);
        }
    }

    private static class BasicRerunAction
    extends AnAction {
        private final Runnable myRerunTask;
        protected final Computable<Boolean> myRerunAvailablePredicate;

        public BasicRerunAction(String text, String description, Icon icon, Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(text, description, icon);
            this.myRerunAvailablePredicate = isRerunAvailablePredicate;
            this.myRerunTask = rerun;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myRerunTask.run();
        }
    }

    public static class JavaExternalProcessHandler
    extends ExternalProcessHandlerBase
    implements ExternalProcessHandler {
        @NotNull
        private final Sdk jdk;
        private final String[] classPath;
        protected final String className;
        private final String[] parameters;
        private final boolean myIncludeToolsJar;
        private Map<String, String> commandLineProperties;
        private final Module myModule;

        public JavaExternalProcessHandler(@NotNull String name, @NotNull @NonNls String _className, String[] _classPath, String[] _parameters, Module module, boolean includeToolsJar) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/utils/InvokeExternalCodeUtil$JavaExternalProcessHandler", "<init>"));
            }
            if (_className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_className", "com/intellij/ws/utils/InvokeExternalCodeUtil$JavaExternalProcessHandler", "<init>"));
            }
            super(name);
            this.myModule = module;
            if (LOG.isDebugEnabled()) {
                LOG.debug("About to execute " + _className);
                LOG.debug("Module " + module);
            }
            Sdk _jdk = JavaExternalProcessHandler.evaluateJdkForModule(module);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finally using jdk:" + CommonWsUtils.getVMExecutablePathForSdk(_jdk));
            }
            this.jdk = _jdk;
            this.className = _className;
            this.classPath = _classPath != null ? _classPath : ArrayUtil.EMPTY_STRING_ARRAY;
            this.parameters = _parameters;
            this.myIncludeToolsJar = includeToolsJar;
            HttpConfigurable.getInstance().getJvmProperties(false, null).forEach(p -> this.addCommandLineProperty((String)p.first, (String)p.second));
        }

        public void addCommandLineProperty(@NonNls String property, String value) {
            if (this.commandLineProperties == null) {
                this.commandLineProperties = new HashMap<String, String>(2);
            }
            this.commandLineProperties.put(property, value);
        }

        public static Sdk evaluateJdkForModule(Module module) {
            Sdk _jdk;
            Sdk sdk = _jdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using module jdk:" + (CommonWsUtils.isAcceptableSdk(_jdk) ? CommonWsUtils.getVMExecutablePathForSdk(_jdk) : null));
            }
            if (_jdk == null && module != null) {
                _jdk = ProjectRootManager.getInstance((Project)module.getProject()).getProjectSdk();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using project jdk:" + (CommonWsUtils.isAcceptableSdk(_jdk) ? CommonWsUtils.getVMExecutablePathForSdk(_jdk) : null));
                }
            }
            if (!CommonWsUtils.isAcceptableSdk(_jdk)) {
                _jdk = CommonWsUtils.getInternalJdk();
            }
            return _jdk;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$JavaExternalProcessHandler", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        protected List<String> buildCommands() {
            boolean hasClassPath = this.classPath != null && this.classPath.length > 0 || this.myIncludeToolsJar || this.commandLineProperties != null;
            ArrayList<String> parametersList = new ArrayList<String>(this.parameters.length + 3 + (hasClassPath ? 2 : 0) + (this.commandLineProperties != null ? this.commandLineProperties.size() : 0));
            parametersList.add(CommonWsUtils.getVMExecutablePathForSdk(this.jdk));
            if (hasClassPath) {
                parametersList.add("-classpath");
                StringBuilder builder = new StringBuilder();
                for (String u : this.classPath) {
                    if (builder.length() > 0) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    u = FileUtils.removeFileProtocolPrefixIfPresent(u);
                    builder.append(u);
                }
                if (this.myIncludeToolsJar) {
                    if (builder.length() > 0) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    builder.append(CommonWsUtils.getToolsJarPathForSdk(this.jdk));
                }
                HashSet modules = new HashSet();
                if (this.myModule != null) {
                    ModuleUtilCore.getDependencies((Module)this.myModule, modules);
                }
                for (Module module : modules) {
                    VirtualFile output = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
                    if (output == null) continue;
                    if (builder.length() > 0) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    builder.append(output.getPath());
                }
                parametersList.add(builder.toString());
            }
            if (this.commandLineProperties != null) {
                for (String key : this.commandLineProperties.keySet()) {
                    parametersList.add("-D" + key + "=" + this.commandLineProperties.get(key));
                }
            }
            parametersList.add("-Xmx" + this.getMemorySizeToLaunchVM() + "M");
            this.addInvokedClass(parametersList);
            ContainerUtil.addAll(parametersList, (Object[])this.parameters);
            ArrayList<String> arrayList = parametersList;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$JavaExternalProcessHandler", "buildCommands"));
            }
            return arrayList;
        }

        protected int getMemorySizeToLaunchVM() {
            return 128;
        }

        protected void addInvokedClass(List<String> parametersList) {
            parametersList.add(this.className);
        }
    }

    public static class ANTExternalProcessHandler
    implements ExternalProcessHandler {
        private final ExternalProcessHandler myJavaExternalProcessHandler;
        private final String myName;
        private final String myAntFileText;

        public ANTExternalProcessHandler(@NotNull String name, String antFileText, String[] additionalClassPathForTasks, Module targetModule) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/utils/InvokeExternalCodeUtil$ANTExternalProcessHandler", "<init>"));
            }
            this.myName = name;
            this.myAntFileText = antFileText;
            try {
                File tempFile = FileUtil.createTempFile((String)"build", (String)".xml");
                tempFile.deleteOnExit();
                FileUtil.writeToFile((File)tempFile.getAbsoluteFile(), (String)antFileText);
                LinkedList<String> parameters = new LinkedList<String>();
                String homeDir = PathManager.getHomePath() + "/lib/ant";
                homeDir = homeDir.replace('\\', '/');
                parameters.add("-Dant.home=" + homeDir);
                if (additionalClassPathForTasks != null && additionalClassPathForTasks.length > 0) {
                    parameters.add("-cp");
                    StringBuilder additionalClassPath = new StringBuilder();
                    for (String a : additionalClassPathForTasks) {
                        if (additionalClassPath.length() > 0) {
                            additionalClassPath.append(CLASS_PATH_SEPARATOR);
                        }
                        additionalClassPath.append(a);
                    }
                    parameters.add(additionalClassPath.toString());
                }
                parameters.add("-f");
                parameters.add(tempFile.getCanonicalPath());
                this.myJavaExternalProcessHandler = new JavaExternalProcessHandler(this.myName, "org.apache.tools.ant.launch.Launcher", new String[]{homeDir + "/lib/ant-launcher.jar"}, ArrayUtil.toStringArray(parameters), targetModule, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$ANTExternalProcessHandler", "getName"));
            }
            return string;
        }

        @Override
        public String[] getCommands() {
            return this.myJavaExternalProcessHandler.getCommands();
        }

        @Override
        @Nullable
        public File getLaunchDir() {
            return this.myJavaExternalProcessHandler.getLaunchDir();
        }

        @Override
        public void setLaunchDir(@Nullable File launchDir) {
            this.myJavaExternalProcessHandler.setLaunchDir(launchDir);
        }

        @Override
        public OutputConsumer getOutputConsumer() {
            return this.myJavaExternalProcessHandler.getOutputConsumer();
        }

        @Override
        public void setOutputConsumer(OutputConsumer outputConsumer) {
            this.myJavaExternalProcessHandler.setOutputConsumer(outputConsumer);
        }

        @Override
        public String describeExecution() {
            return this.myJavaExternalProcessHandler.describeExecution() + "\nAnt file:\n" + this.myAntFileText;
        }
    }

    public static class BatchExternalProcessHandler
    extends ExternalProcessHandlerBase
    implements ExternalProcessHandler {
        private final List<String> myParams;
        private String myBaseBatchFileName;

        public BatchExternalProcessHandler(@NotNull String name, @NotNull String baseBatchFileName, @NotNull List<String> params) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/utils/InvokeExternalCodeUtil$BatchExternalProcessHandler", "<init>"));
            }
            if (baseBatchFileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBatchFileName", "com/intellij/ws/utils/InvokeExternalCodeUtil$BatchExternalProcessHandler", "<init>"));
            }
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/ws/utils/InvokeExternalCodeUtil$BatchExternalProcessHandler", "<init>"));
            }
            super(name);
            this.myBaseBatchFileName = baseBatchFileName;
            this.myParams = params;
        }

        @Override
        @NotNull
        protected List<String> buildCommands() {
            ArrayList<String> commands = new ArrayList<String>(this.myParams.size() + 2);
            if (SystemInfo.isWindows) {
                commands.add("cmd");
                commands.add("/c");
            }
            this.myBaseBatchFileName = this.myBaseBatchFileName + (SystemInfo.isWindows ? ".bat" : ".sh");
            commands.add(this.myBaseBatchFileName);
            commands.addAll(this.myParams);
            ArrayList<String> arrayList = commands;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$BatchExternalProcessHandler", "buildCommands"));
            }
            return arrayList;
        }
    }

    static abstract class ExternalProcessHandlerBase {
        protected final String myName;
        protected String[] myCommands;
        protected File myLaunchDir;
        protected OutputConsumer myOutputConsumer;

        protected ExternalProcessHandlerBase(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/utils/InvokeExternalCodeUtil$ExternalProcessHandlerBase", "<init>"));
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$ExternalProcessHandlerBase", "getName"));
            }
            return string;
        }

        @NotNull
        protected abstract List<String> buildCommands();

        @NotNull
        public String[] getCommands() {
            if (this.myCommands == null) {
                List<String> commands = this.buildCommands();
                this.myCommands = ArrayUtil.toStringArray(commands);
            }
            if (this.myCommands == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/InvokeExternalCodeUtil$ExternalProcessHandlerBase", "getCommands"));
            }
            return this.myCommands;
        }

        @Nullable
        public File getLaunchDir() {
            return this.myLaunchDir;
        }

        public void setLaunchDir(@Nullable File launchDir) {
            this.myLaunchDir = launchDir;
        }

        @Nullable
        public OutputConsumer getOutputConsumer() {
            return this.myOutputConsumer;
        }

        public void setOutputConsumer(@Nullable OutputConsumer outputConsumer) {
            this.myOutputConsumer = outputConsumer;
        }

        public String describeExecution() {
            return InvokeExternalCodeUtil.buildDescriptionFromCommandsAndLaunchDir(this.myLaunchDir, this.getCommands());
        }

        public void onProcessTerminated() {
        }
    }

    static class StreamReaderThread
    implements Runnable {
        private final InputStream in;
        private StringBuilder builder;

        StreamReaderThread(InputStream stream) {
            this.in = stream;
        }

        @Override
        public void run() {
            char[] buf = new char[128];
            this.builder = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(this.in);){
                int read;
                while ((read = reader.read(buf)) != -1) {
                    this.builder.append(buf, 0, read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface OutputConsumer {
        public boolean handle(String var1, String var2) throws ExternalCodeException;
    }
}

