/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JspTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/JspTypedHandler", "charTyped"));
        }
        FileType originalFileType = JspTypedHandler.getOriginalFileType(file);
        if (c == '=' && originalFileType == StdFileTypes.JSP) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()));
            if (jspFile != null) {
                JspTypedHandler.handleJspEqual(jspFile, editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Nullable
    private static FileType getOriginalFileType(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? virtualFile.getFileType() : null;
    }

    private static void handleJspEqual(JspFile file, Editor editor) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        int current = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(current);
        if (element == null && (element = file.findElementAt(editor.getDocument().getTextLength() - 1)) == null) {
            return;
        }
        if (current >= 3 && chars.charAt(current - 3) == '<' && chars.charAt(current - 2) == '%') {
            int ptr;
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            for (ptr = current; ptr < chars.length() && Character.isWhitespace(chars.charAt(ptr)); ++ptr) {
            }
            if (ptr + 1 >= chars.length() || chars.charAt(ptr) != '%' || chars.charAt(ptr + 1) != '>') {
                editor.getDocument().insertString(current, (CharSequence)"%>");
            }
        }
    }
}

