/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.impl.TldAttributeDescriptor;
import com.intellij.lang.jsp.JspxFileViewProviderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ELDeferredExpressionsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection", "buildVisitor"));
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            @Override
            public void visitELExpressionHolder(ELExpressionHolder expressionHolder) {
                XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlAttribute.class);
                if (attribute == null) {
                    return;
                }
                FileViewProvider viewProvider = attribute.getContainingFile().getViewProvider();
                if (viewProvider instanceof JspxFileViewProviderImpl && ((JspxFileViewProviderImpl)viewProvider).isFacelets()) {
                    return;
                }
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (!(descriptor instanceof TldAttributeDescriptor)) {
                    return;
                }
                TldAttributeDescriptor tldAttributeDescriptor = (TldAttributeDescriptor)descriptor;
                if (expressionHolder.isJSFELHolder()) {
                    if (!tldAttributeDescriptor.isDeferred()) {
                        problemsHolder.registerProblem((PsiElement)expressionHolder, "Dynamic expression (${} syntax) is required here", new LocalQuickFix[]{new MyLocalQuickFix("Replace #{} syntax with ${}", "$")});
                    }
                } else if (tldAttributeDescriptor.isDeferred() && !tldAttributeDescriptor.isDynamic()) {
                    problemsHolder.registerProblem((PsiElement)expressionHolder, "Deferred expression (#{} syntax) is required here", new LocalQuickFix[]{new MyLocalQuickFix("Replace ${} syntax with #{}", "#")});
                }
            }
        };
        if (eLElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection", "buildVisitor"));
        }
        return eLElementVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("EL Deferred Expressions Inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection", "getDisplayName"));
        }
        return "EL Deferred Expressions Inspection";
    }

    @NotNull
    public String getShortName() {
        if ("ELDeferredExpressionsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection", "getShortName"));
        }
        return "ELDeferredExpressionsInspection";
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myFixName;
        private final String myReplacement;

        public MyLocalQuickFix(String fixName, String replacement) {
            this.myFixName = fixName;
            this.myReplacement = replacement;
        }

        @NotNull
        public String getName() {
            String string = this.myFixName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection$MyLocalQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JspInspectionGroupNames.JSP_INSPECTIONS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/jsp/ELDeferredExpressionsInspection$MyLocalQuickFix", "applyFix"));
            }
            ELExpressionHolder element = (ELExpressionHolder)descriptor.getPsiElement();
            PsiElement firstChild = element.getFirstChild();
            assert (firstChild != null);
            PsiElement psiElement = JavaPsiFacade.getElementFactory((Project)element.getProject()).createDummyHolder(this.myReplacement + "{}", (IElementType)ELElementType.JSP_EL_HOLDER, (PsiElement)element);
            PsiElement child = psiElement.getFirstChild();
            assert (child != null);
            firstChild.replace(child);
        }
    }
}

