/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine;

import java.util.Optional;
import org.junit.jupiter.engine.DiscoveryFilterApplier;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;

@API(value=API.Usage.Experimental)
public class JupiterTestEngine
extends HierarchicalTestEngine<JupiterEngineExecutionContext> {
    public static final String ENGINE_ID = "junit-jupiter";

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.junit.jupiter");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("junit-jupiter-engine");
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        Preconditions.notNull((Object)discoveryRequest, (String)"discovery request must not be null");
        JupiterEngineDescriptor engineDescriptor = new JupiterEngineDescriptor(uniqueId);
        this.resolveDiscoveryRequest(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    private void resolveDiscoveryRequest(EngineDiscoveryRequest discoveryRequest, JupiterEngineDescriptor engineDescriptor) {
        DiscoverySelectorResolver resolver = new DiscoverySelectorResolver();
        resolver.resolveSelectors(discoveryRequest, (TestDescriptor)engineDescriptor);
        this.applyDiscoveryFilters(discoveryRequest, engineDescriptor);
    }

    private void applyDiscoveryFilters(EngineDiscoveryRequest discoveryRequest, JupiterEngineDescriptor engineDescriptor) {
        new DiscoveryFilterApplier().applyAllFilters(discoveryRequest, (TestDescriptor)engineDescriptor);
    }

    protected JupiterEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new JupiterEngineExecutionContext(request.getEngineExecutionListener(), request.getConfigurationParameters());
    }
}

