/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable String base) {
            URL uRL;
            block6: {
                block4: {
                    URL uRL2;
                    block5: {
                        if (relativePath == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/util/xmlb/JDOMXIncluder$1", "resolvePath"));
                        }
                        try {
                            if (base == null) break block4;
                            uRL2 = new URL(new URL(base), relativePath);
                            if (uRL2 != null) break block5;
                        }
                        catch (MalformedURLException ex) {
                            throw new XIncludeException(ex);
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/JDOMXIncluder$1", "resolvePath"));
                    }
                    return uRL2;
                }
                uRL = new URL(relativePath);
                if (uRL != null) break block6;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/JDOMXIncluder$1", "resolvePath"));
            }
            return uRL;
        }
    };
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;
    @NonNls
    public static Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");

    private JDOMXIncluder(boolean ignoreMissing, PathResolver pathResolver) {
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    public static Document resolve(Document original, String base, boolean ignoreMissing, PathResolver pathResolver) throws XIncludeException {
        return new JDOMXIncluder(ignoreMissing, pathResolver).doResolve(original, base);
    }

    private Document doResolve(Document original, String base) {
        if (original == null) {
            throw new NullPointerException("Document must not be null");
        }
        Document result2 = original.clone();
        Element root = result2.getRootElement();
        List<Content> resolved = this.doResolve(root, base);
        Element newRoot = null;
        for (Content o : resolved) {
            if (o instanceof Element) {
                if (newRoot != null) {
                    throw new XIncludeException("Tried to include multiple roots");
                }
                newRoot = (Element)o;
                continue;
            }
            if (o instanceof Comment || o instanceof ProcessingInstruction) continue;
            if (o instanceof Text) {
                throw new XIncludeException("Tried to include text node outside of root element");
            }
            if (o instanceof EntityRef) {
                throw new XIncludeException("Tried to include a general entity reference outside of root element");
            }
            throw new XIncludeException("Unexpected type " + o.getClass());
        }
        if (newRoot == null) {
            throw new XIncludeException("No root element");
        }
        List<Content> newContent = result2.getContent();
        Iterator<Content> iterator2 = resolved.iterator();
        int rootPosition = newContent.indexOf(result2.getRootElement());
        while (iterator2.hasNext()) {
            Content o = iterator2.next();
            if (o instanceof Comment || o instanceof ProcessingInstruction) {
                newContent.add(rootPosition, o);
                ++rootPosition;
                continue;
            }
            if (!(o instanceof Element)) continue;
            break;
        }
        result2.setRootElement(newRoot);
        int addPosition = rootPosition + 1;
        while (iterator2.hasNext()) {
            Content o = iterator2.next();
            if (!(o instanceof Comment) && !(o instanceof ProcessingInstruction)) continue;
            newContent.add(addPosition, o);
            ++addPosition;
        }
        return result2;
    }

    private List<Content> doResolve(@NotNull Element original, String base) throws XIncludeException {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/xmlb/JDOMXIncluder", "doResolve"));
        }
        Stack<String> bases = new Stack<String>();
        if (base != null) {
            bases.push(base);
        }
        List<Content> result2 = this.resolve(original, bases);
        bases.pop();
        return result2;
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(XINCLUDE_NAMESPACE);
    }

    private List<Content> resolve(Element original, Stack<String> bases) throws XIncludeException {
        if (JDOMXIncluder.isIncludeElement(original)) {
            return this.resolveXIncludeElement(original, bases);
        }
        Element resolvedElement = this.resolveNonXIncludeElement(original, bases);
        ArrayList<Content> resultList = new ArrayList<Content>(1);
        resultList.add(resolvedElement);
        return resultList;
    }

    private List<Content> resolveXIncludeElement(Element element, Stack<String> bases) throws XIncludeException {
        String base = "";
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        assert (JDOMXIncluder.isIncludeElement(element));
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        Attribute baseAttribute = element.getAttribute("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = baseAttribute.getValue();
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        boolean parse = true;
        String parseAttribute = element.getAttributeValue("parse");
        if (parseAttribute != null) {
            if (parseAttribute.equals("text")) {
                parse = false;
            }
            assert (parseAttribute.equals("xml")) : parseAttribute + "is not a legal value for the parse attribute";
        }
        if (parse) {
            assert (!bases.contains(remote.toExternalForm())) : "Circular XInclude Reference to " + remote.toExternalForm();
            Element fallbackElement = element.getChild("fallback", element.getNamespace());
            List<Content> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
            if (!remoteParsed.isEmpty()) {
                remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
            }
            for (int i = 0; i < remoteParsed.size(); ++i) {
                Content o = remoteParsed.get(i);
                if (!(o instanceof Element)) continue;
                Element e = (Element)o;
                List<Content> nodes = this.resolve(e, bases);
                remoteParsed.addAll(i, nodes);
                remoteParsed.remove(i += nodes.size());
                --i;
                e.detach();
            }
            for (Content o : remoteParsed) {
                if (!(o instanceof Content)) continue;
                Content content = o;
                content.detach();
            }
            return remoteParsed;
        }
        try {
            String encoding = element.getAttributeValue("encoding");
            String s = StreamUtil.readText(URLUtil.openResourceStream(remote), encoding);
            ArrayList<Content> resultList = new ArrayList<Content>(1);
            resultList.add(new Text(s));
            return resultList;
        }
        catch (IOException e) {
            throw new XIncludeException(e);
        }
    }

    @Nullable
    private static List<Content> extractNeededChildren(Element element, List<Content> remoteElements) {
        String xpointer = element.getAttributeValue("xpointer");
        if (xpointer != null) {
            Matcher matcher = XPOINTER_PATTERN.matcher(xpointer);
            boolean b = matcher.matches();
            assert (b) : "Unsupported XPointer: " + xpointer;
            String pointer = matcher.group(1);
            matcher = CHILDREN_PATTERN.matcher(pointer);
            b = matcher.matches();
            assert (b) : "Unsupported pointer: " + pointer;
            String rootTagName = matcher.group(1);
            assert (remoteElements.size() == 1);
            assert (remoteElements.get(0) instanceof Element);
            Element e = (Element)remoteElements.get(0);
            if (e.getName().equals(rootTagName)) {
                String subTagName = matcher.group(2);
                if (subTagName != null) {
                    e = e.getChild(subTagName.substring(1));
                }
                return new ArrayList<Content>(e.getContent());
            }
            return Collections.emptyList();
        }
        return remoteElements;
    }

    @NotNull
    private List<Content> parseRemote(Stack<String> bases, URL remote, @Nullable Element fallbackElement) {
        List<Content> list2;
        try {
            Document doc = JDOMUtil.loadResourceDocument(remote);
            bases.push(remote.toExternalForm());
            Element root = doc.getRootElement();
            List<Content> list3 = this.resolve(root, bases);
            bases.pop();
            list2 = list3;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                List<Content> list4 = Collections.emptyList();
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/JDOMXIncluder", "parseRemote"));
                }
                return list4;
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                List<Content> list5 = Collections.emptyList();
                if (list5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/JDOMXIncluder", "parseRemote"));
                }
                return list5;
            }
            throw new XIncludeException(e);
        }
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/JDOMXIncluder", "parseRemote"));
        }
        return list2;
    }

    private Element resolveNonXIncludeElement(Element original, Stack<String> bases) throws XIncludeException {
        Element result2 = new Element(original.getName(), original.getNamespace());
        for (Attribute a : original.getAttributes()) {
            result2.setAttribute(a.clone());
        }
        for (Content o : original.getContent()) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (JDOMXIncluder.isIncludeElement(element)) {
                    result2.addContent(this.resolveXIncludeElement(element, bases));
                    continue;
                }
                result2.addContent(this.resolveNonXIncludeElement(element, bases));
                continue;
            }
            result2.addContent(o.clone());
        }
        return result2;
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable String var2);
    }
}

