/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.confusing.ClashingTraitMethodsInspectionBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;

public class ClashingTraitMethodsInspection
extends ClashingTraitMethodsInspectionBase {
    @Override
    @NotNull
    protected LocalQuickFix getFix() {
        MyQuickFix myQuickFix = new MyQuickFix();
        if (myQuickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection", "getFix"));
        }
        return myQuickFix;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("declare.explicit.implementations.of.trait", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection$MyQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Declare explicit implementation of clashing traits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection$MyQuickFix", "getFamilyName"));
            }
            return "Declare explicit implementation of clashing traits";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection$MyQuickFix", "applyFix"));
            }
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof GrTypeDefinition && ((GrTypeDefinition)parent).getNameIdentifierGroovy() == element) {
                final GrTypeDefinition aClass = (GrTypeDefinition)parent;
                new WriteCommandAction(project, new PsiFile[]{aClass.getContainingFile()}){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspection$MyQuickFix$1", "run"));
                        }
                        List<ClashingTraitMethodsInspectionBase.ClashingMethod> clashingMethods = ClashingTraitMethodsInspectionBase.collectClassingMethods(aClass);
                        for (ClashingTraitMethodsInspectionBase.ClashingMethod method : clashingMethods) {
                            PsiMethod traitMethod = method.getSignature().getMethod();
                            ClashingTraitMethodsInspectionBase.LOG.assertTrue(traitMethod instanceof GrTraitMethod);
                            OverrideImplementUtil.overrideOrImplement((PsiClass)aClass, (PsiMethod)traitMethod);
                        }
                    }
                }.execute();
            }
        }
    }
}

