/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.CustomSeamComponent;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.model.xml.core.Init;
import com.intellij.seam.model.xml.core.Manager;
import com.intellij.seam.model.xml.core.PojoCache;
import com.intellij.seam.model.xml.core.ResourceBundle;
import com.intellij.seam.model.xml.core.ResourceLoader;
import com.intellij.seam.model.xml.drools.ManagedWorkingMemory;
import com.intellij.seam.model.xml.drools.RuleAgent;
import com.intellij.seam.model.xml.drools.RuleBase;
import com.intellij.seam.model.xml.framework.EntityHome;
import com.intellij.seam.model.xml.framework.EntityQuery;
import com.intellij.seam.model.xml.framework.HibernateEntityHome;
import com.intellij.seam.model.xml.framework.HibernateEntityQuery;
import com.intellij.seam.model.xml.jms.ManagedQueueSender;
import com.intellij.seam.model.xml.jms.ManagedTopicPublisher;
import com.intellij.seam.model.xml.jms.QueueConnection;
import com.intellij.seam.model.xml.jms.TopicConnection;
import com.intellij.seam.model.xml.mail.MailSession;
import com.intellij.seam.model.xml.mail.Meldware;
import com.intellij.seam.model.xml.mail.MeldwareUser;
import com.intellij.seam.model.xml.pdf.DocumentStore;
import com.intellij.seam.model.xml.pdf.KeyStoreConfig;
import com.intellij.seam.model.xml.persistence.EntityManagerFactory;
import com.intellij.seam.model.xml.persistence.Filter;
import com.intellij.seam.model.xml.persistence.HibernateSessionFactory;
import com.intellij.seam.model.xml.persistence.ManagedHibernateSession;
import com.intellij.seam.model.xml.persistence.ManagedPersistenceContext;
import com.intellij.seam.model.xml.remoting.Debug;
import com.intellij.seam.model.xml.remoting.RemotingConfig;
import com.intellij.seam.model.xml.security.Identity;
import com.intellij.seam.model.xml.spring.ContextLoader;
import com.intellij.seam.model.xml.spring.SpringTransaction;
import com.intellij.seam.model.xml.spring.TaskExecutorDispatcher;
import com.intellij.seam.model.xml.theme.ThemeSelector;
import com.intellij.seam.model.xml.web.Ajax4jsfFilter;
import com.intellij.seam.model.xml.web.AuthenticationFilter;
import com.intellij.seam.model.xml.web.CharacterEncodingFilter;
import com.intellij.seam.model.xml.web.ContextFilter;
import com.intellij.seam.model.xml.web.ExceptionFilter;
import com.intellij.seam.model.xml.web.LoggingFilter;
import com.intellij.seam.model.xml.web.MultipartFilter;
import com.intellij.seam.model.xml.web.RedirectFilter;
import com.intellij.seam.model.xml.web.ServletSession;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SeamComponentsExtender
extends DomExtender<SeamComponents> {
    private static final Map<Pair<String, String>, Class> myCustomNamespacedComponentsMap = new com.intellij.util.containers.HashMap();
    private static final Map<Pair<String, String>, Pair<String, Class>> myCustomComponentsRegistryMap = new com.intellij.util.containers.HashMap();

    public void registerExtensions(@NotNull SeamComponents seamComponents, @NotNull DomExtensionsRegistrar registrar) {
        if (seamComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seamComponents", "com/intellij/seam/model/xml/SeamComponentsExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/seam/model/xml/SeamComponentsExtender", "registerExtensions"));
        }
        SeamComponentsExtender.registerStaticExtensions(registrar);
        XmlFile xmlFile = DomUtil.getFile((DomElement)seamComponents);
        Project project = xmlFile.getProject();
        Map<PsiPackage, String> myNamespaceToPackageName = SeamComponentsExtender.getNamespaceToPackageName(JavaPsiFacade.getInstance((Project)project), project);
        for (PsiPackage psiPackage : myNamespaceToPackageName.keySet()) {
            for (PsiClass psiClass : psiPackage.getClasses()) {
                SeamComponentsExtender.registerSeamComponent(psiClass, myNamespaceToPackageName.get(psiPackage), registrar);
            }
        }
        for (Pair pair : myCustomComponentsRegistryMap.keySet()) {
            Pair<String, Class> classesPair = myCustomComponentsRegistryMap.get(pair);
            SeamComponentsExtender.registerExtensions(registrar, project, (String)pair.getFirst(), (String)pair.getSecond(), (String)classesPair.getFirst(), (Class)classesPair.getSecond());
        }
    }

    private static void registerStaticExtensions(DomExtensionsRegistrar registrar) {
        registrar.registerCollectionChildrenExtension(new XmlName("init", "http://jboss.com/products/seam/core"), Init.class);
        registrar.registerCollectionChildrenExtension(new XmlName("manager", "http://jboss.com/products/seam/core"), Manager.class);
        registrar.registerCollectionChildrenExtension(new XmlName("pojo-cache", "http://jboss.com/products/seam/core"), PojoCache.class);
        registrar.registerCollectionChildrenExtension(new XmlName("managed-working-memory", "http://jboss.com/products/seam/drools"), ManagedWorkingMemory.class);
        registrar.registerCollectionChildrenExtension(new XmlName("rule-agent", "http://jboss.com/products/seam/drools"), RuleAgent.class);
        registrar.registerCollectionChildrenExtension(new XmlName("rule-base", "http://jboss.com/products/seam/drools"), RuleBase.class);
        registrar.registerCollectionChildrenExtension(new XmlName("entity-query", "http://jboss.com/products/seam/framework"), EntityQuery.class);
        registrar.registerCollectionChildrenExtension(new XmlName("hibernate-entity-home", "http://jboss.com/products/seam/framework"), HibernateEntityHome.class);
        registrar.registerCollectionChildrenExtension(new XmlName("hibernate-entity-query", "http://jboss.com/products/seam/framework"), HibernateEntityQuery.class);
        registrar.registerCollectionChildrenExtension(new XmlName("managed-queue-sender", "http://jboss.com/products/seam/jms"), ManagedQueueSender.class);
        registrar.registerCollectionChildrenExtension(new XmlName("managed-topic-publisher", "http://jboss.com/products/seam/jms"), ManagedTopicPublisher.class);
        registrar.registerCollectionChildrenExtension(new XmlName("queue-connection", "http://jboss.com/products/seam/jms"), QueueConnection.class);
        registrar.registerCollectionChildrenExtension(new XmlName("topic-connection", "http://jboss.com/products/seam/jms"), TopicConnection.class);
        registrar.registerCollectionChildrenExtension(new XmlName("mail-session", "http://jboss.com/products/seam/mail"), MailSession.class);
        registrar.registerCollectionChildrenExtension(new XmlName("meldware", "http://jboss.com/products/seam/mail"), Meldware.class);
        registrar.registerCollectionChildrenExtension(new XmlName("meldware-user", "http://jboss.com/products/seam/mail"), MeldwareUser.class);
        registrar.registerCollectionChildrenExtension(new XmlName("document-store", "http://jboss.com/products/seam/pdf"), DocumentStore.class);
        registrar.registerCollectionChildrenExtension(new XmlName("key-store-config", "http://jboss.com/products/seam/pdf"), KeyStoreConfig.class);
        registrar.registerCollectionChildrenExtension(new XmlName("entity-manager-factory", "http://jboss.com/products/seam/persistence"), EntityManagerFactory.class);
        registrar.registerCollectionChildrenExtension(new XmlName("filter", "http://jboss.com/products/seam/persistence"), Filter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("hibernate-session-factory", "http://jboss.com/products/seam/persistence"), HibernateSessionFactory.class);
        registrar.registerCollectionChildrenExtension(new XmlName("managed-hibernate-session", "http://jboss.com/products/seam/persistence"), ManagedHibernateSession.class);
        registrar.registerCollectionChildrenExtension(new XmlName("managed-persistence-context", "http://jboss.com/products/seam/persistence"), ManagedPersistenceContext.class);
        registrar.registerCollectionChildrenExtension(new XmlName("debug", "http://jboss.com/products/seam/remoting"), Debug.class);
        registrar.registerCollectionChildrenExtension(new XmlName("remoting-config", "http://jboss.com/products/seam/remoting"), RemotingConfig.class);
        registrar.registerCollectionChildrenExtension(new XmlName("identity", "http://jboss.com/products/seam/security"), Identity.class);
        registrar.registerCollectionChildrenExtension(new XmlName("context-loader", "http://jboss.com/products/seam/spring"), ContextLoader.class);
        registrar.registerCollectionChildrenExtension(new XmlName("spring-transaction", "http://jboss.com/products/seam/spring"), SpringTransaction.class);
        registrar.registerCollectionChildrenExtension(new XmlName("task-executor-dispatcher", "http://jboss.com/products/seam/spring"), TaskExecutorDispatcher.class);
        registrar.registerCollectionChildrenExtension(new XmlName("theme-selector", "http://jboss.com/products/seam/theme"), ThemeSelector.class);
        registrar.registerCollectionChildrenExtension(new XmlName("ajax-4-jsf-filter", "http://jboss.com/products/seam/web"), Ajax4jsfFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("authentication-filter", "http://jboss.com/products/seam/web"), AuthenticationFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("character-encoding-filter", "http://jboss.com/products/seam/web"), CharacterEncodingFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("context-filter", "http://jboss.com/products/seam/web"), ContextFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("exception-filter", "http://jboss.com/products/seam/web"), ExceptionFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("logging-filter", "http://jboss.com/products/seam/web"), LoggingFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("multipart-filter", "http://jboss.com/products/seam/web"), MultipartFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("redirect-filter", "http://jboss.com/products/seam/web"), RedirectFilter.class);
        registrar.registerCollectionChildrenExtension(new XmlName("servlet-session", "http://jboss.com/products/seam/web"), ServletSession.class);
    }

    private static void registerExtensions(DomExtensionsRegistrar registrar, Project project, String tagName, String namespace, String className, Class aClass) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            registrar.registerCollectionChildrenExtension(new XmlName(tagName, namespace), (Type)aClass);
        }
    }

    private static void registerSeamComponent(PsiClass psiClass, String namespace, DomExtensionsRegistrar registrar) {
        String xmlName = SeamComponentsExtender.getXmlName(psiClass);
        Class aClass = myCustomNamespacedComponentsMap.get(Pair.create((Object)xmlName, (Object)namespace));
        Class componentClass = aClass == null ? CustomSeamComponent.class : aClass;
        DomExtension domExtension = registrar.registerCollectionChildrenExtension(new XmlName(xmlName, namespace), (Type)componentClass);
        domExtension.putUserData(CustomSeamComponent.COMPONENT_TYPE, (Object)psiClass);
    }

    private static String getXmlName(PsiClass psiClass) {
        return StringUtil.join((Collection)NameUtil.nameToWordsLowerCase((String)psiClass.getName()), (String)"-");
    }

    private static Map<PsiPackage, String> getNamespaceToPackageName(JavaPsiFacade facade, Project project) {
        HashMap<PsiPackage, String> namespaceToPackageName = new HashMap<PsiPackage, String>();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass namespaceAnnotationClass = facade.findClass("org.jboss.seam.annotations.Namespace", scope);
        if (namespaceAnnotationClass != null) {
            for (PsiPackage target : AnnotatedPackagesSearch.search((PsiClass)namespaceAnnotationClass, (SearchScope)scope)) {
                PsiAnnotationMemberValue psiAnnotationMemberValue;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)target, (String[])new String[]{"org.jboss.seam.annotations.Namespace"});
                if (annotation == null || !((psiAnnotationMemberValue = annotation.findAttributeValue("value")) instanceof PsiLiteralExpression)) continue;
                namespaceToPackageName.put(target, StringUtil.stripQuotesAroundValue((String)psiAnnotationMemberValue.getText()));
            }
        }
        return namespaceToPackageName;
    }

    static {
        myCustomNamespacedComponentsMap.put((Pair<String, String>)Pair.create((Object)"entity-home", (Object)"http://jboss.com/products/seam/framework"), EntityHome.class);
        myCustomNamespacedComponentsMap.put((Pair<String, String>)Pair.create((Object)"resource-loader", (Object)"http://jboss.com/products/seam/core"), ResourceLoader.class);
        myCustomComponentsRegistryMap.put((Pair<String, String>)Pair.create((Object)"resource-bundle", (Object)"http://jboss.com/products/seam/core"), (Pair<String, Class>)new Pair((Object)"org.jboss.seam.core.ResourceBundle", ResourceBundle.class));
    }
}

