/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSRecordType
extends JSType {
    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(String var1);

    public static boolean areCallSignaturesEqual(@NotNull CallSignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/JSRecordType", "areCallSignaturesEqual"));
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof CallSignature)) {
            return false;
        }
        CallSignature other = (CallSignature)otherRaw;
        return other.hasNew() == first.hasNew() && other.getFunctionType().isEquivalentTo(first.getFunctionType(), null, allowResolve);
    }

    public PropertySignature findPropertySignature(@NotNull String var1);

    public static boolean areIndexSignaturesEqual(@NotNull IndexSignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/JSRecordType", "areIndexSignaturesEqual"));
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof IndexSignature)) {
            return false;
        }
        IndexSignature other = (IndexSignature)otherRaw;
        return first.getMemberParameterType().isEquivalentTo(other.getMemberParameterType(), null, allowResolve) && first.getMemberType().isEquivalentTo(other.getMemberType(), null, allowResolve);
    }

    public static boolean arePropertySignaturesEqual(@NotNull PropertySignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/JSRecordType", "arePropertySignaturesEqual"));
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof PropertySignature)) {
            return false;
        }
        PropertySignature other = (PropertySignature)otherRaw;
        return first.getMemberName().equals(other.getMemberName()) && (first.getType() != null ? first.getType().isEquivalentTo(other.getType(), null, allowResolve) : other.getType() == null) && other.isOptional() == other.isOptional();
    }

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        public JSType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static interface PropertySignature
    extends TypeMember {
        @NotNull
        public String getMemberName();

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public boolean isOptional();

        @Nullable
        public JSType getType();
    }

    public static interface TypeMember {
        public boolean isEquivalentTo(@Nullable TypeMember var1, boolean var2);

        @Nullable
        public PsiElement getSource();

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }
}

