/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.micp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.URL;
import java.util.Vector;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.micp.MICP;
import org.w3c.www.protocol.http.micp.MICPReadWrite;
import org.w3c.www.protocol.http.micp.ReplyWaiter;

public class MICPFilter
extends Thread
implements PropRequestFilter,
PropertyMonitoring,
MICP {
    public static final String STATE_HOW = "org.w3c.www.protocol.micp.how";
    public static final String DEBUG_P = "org.w3c.www.protocol.http.micp.debug";
    public static final String ADDRESS_P = "org.w3c.www.protocol.http.micp.address";
    public static final String PORT_P = "org.w3c.www.protocol.http.micp.port";
    public static final String TIMEOUT_P = "org.w3c.www.protocol.http.micp.timeout";
    public static final String DISABLE_CACHE_P = "org.w3c.www.protocol.http.micp.disable-cache";
    public static final String PROXY_P = "org.w3c.www.protocol.http.micp.proxy";
    protected ObservableProperties props = null;
    protected CacheFilter cache = null;
    protected long timeoutValue = 500L;
    protected boolean debug = false;
    int port = -1;
    protected boolean disableCache = true;
    protected Vector waiters = null;
    protected InetAddress addr = null;
    protected byte[] localproxy = null;
    protected long localsrc = -1L;
    protected byte[] localaddr = null;
    protected MulticastSocket socket = null;
    protected int ttl = 1;
    private MICPReadWrite micprw = null;
    private byte[] sendbuf = null;
    private int sendid = 0;
    private ReplyWaiter[] queue = null;

    private final synchronized int nextId() {
        return ++this.sendid;
    }

    protected final synchronized ReplyWaiter lookupWaiter(int n) {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == null || this.queue[i].id != n) continue;
            return this.queue[i];
        }
        return null;
    }

    protected final synchronized void removeWaiter(ReplyWaiter replyWaiter) {
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] != replyWaiter) continue;
            this.queue[i] = null;
            return;
        }
    }

    protected final synchronized ReplyWaiter addWaiter(int n) {
        ReplyWaiter replyWaiter = new ReplyWaiter(this, n);
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] != null) continue;
            this.queue[i] = replyWaiter;
            return this.queue[i];
        }
        ReplyWaiter[] replyWaiterArray = new ReplyWaiter[this.queue.length + 5];
        System.arraycopy(this.queue, 0, replyWaiterArray, 0, this.queue.length);
        replyWaiterArray[this.queue.length] = replyWaiter;
        this.queue = replyWaiterArray;
        return replyWaiter;
    }

    public URL waitOn(int n) {
        ReplyWaiter replyWaiter = this.addWaiter(n);
        return replyWaiter.waitReply();
    }

    protected void handle(byte[] byArray, int n) throws IOException {
        if (n <= 12) {
            return;
        }
        int n2 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        if (n < n2) {
            return;
        }
        long l = ((byArray[4] & 0xFF) << 24) + ((byArray[5] & 0xFF) << 16) + ((byArray[6] & 0xFF) << 8) + (byArray[7] & 0xFF);
        int n3 = ((byArray[8] & 0xFF000000) << 24) + ((byArray[9] & 0xFF0000) << 16) + ((byArray[10] & 0xFF00) << 8) + (byArray[11] & 0xFF);
        String string = new String(byArray, 12, n - 12);
        if (byArray[1] == 1) {
            if (l == this.localsrc || this.localproxy == null) {
                return;
            }
        } else if (l == this.localsrc) {
            ReplyWaiter replyWaiter = this.lookupWaiter(n3);
            if (replyWaiter != null) {
                replyWaiter.wakeup(string);
            }
            return;
        }
    }

    protected int locateProxy(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        int n = this.nextId();
        int n2 = -1;
        while ((n2 = this.micprw.encode(1, (int)(this.localsrc & 0xFFFFFFFFFFFFFFFFL), n, string, this.sendbuf)) < 0) {
            this.sendbuf = new byte[-n2 + 1];
        }
        if (this.debug) {
            System.out.println("mICP: query for " + string);
        }
        DatagramPacket datagramPacket = new DatagramPacket(this.sendbuf, n2, this.addr, this.port);
        this.socket.send(datagramPacket);
        return n;
    }

    public boolean propertyChanged(String string) {
        if (this.debug) {
            System.out.println("mICPFilter:" + string + ": property changed.");
        }
        return true;
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        return false;
    }

    public Reply ingoingFilter(Request request) {
        if (request.getMethod().equals("GET") && !request.hasState("org.w3c.www.protocol.http.cache.dont") && !request.hasState("org.w3c.www.protocol.http.cache.revalidation")) {
            URL uRL = null;
            try {
                int n = this.locateProxy(request.getURL());
                uRL = this.waitOn(n);
            }
            catch (Exception exception) {
                return null;
            }
            if (uRL != null) {
                if (this.debug) {
                    System.out.println("*** routing " + request.getURL() + " to " + uRL);
                }
                if (this.disableCache) {
                    request.setState("org.w3c.www.protocol.http.cache.dont", Boolean.TRUE);
                }
                request.setState(STATE_HOW, uRL);
                request.setProxy(uRL);
            }
        }
        return null;
    }

    public Reply outgoingFilter(Request request, Reply reply) {
        return null;
    }

    public void sync() {
    }

    public void run() {
        byte[] byArray = new byte[4096];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
                this.handle(datagramPacket.getData(), datagramPacket.getLength());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        Object object;
        this.micprw = new MICPReadWrite();
        this.queue = new ReplyWaiter[16];
        this.sendbuf = new byte[512];
        this.props = httpManager.getProperties();
        this.props.registerObserver(this);
        this.debug = this.props.getBoolean(DEBUG_P, false);
        if (this.debug) {
            System.out.println("[" + this.getClass().getName() + "]: debugging on");
        }
        this.port = this.props.getInteger(PORT_P, 2005);
        this.timeoutValue = this.props.getInteger(TIMEOUT_P, (int)this.timeoutValue);
        this.disableCache = this.props.getBoolean(DISABLE_CACHE_P, this.disableCache);
        String string = this.props.getString(ADDRESS_P, null);
        String string2 = this.props.getString(PROXY_P, null);
        if (string2 == null) {
            object = this.props.getString("org.w3c.jigsaw.host", null);
            int n = this.props.getInteger("org.w3c.jigsaw.port", -1);
            if (object != null && n != -1) {
                string2 = "http://" + (String)object + ":" + n;
            }
        }
        if (string2 != null) {
            this.localproxy = string2.getBytes();
        }
        try {
            object = Class.forName("org.w3c.www.protocol.http.cache.CacheFilter");
            this.cache = (CacheFilter)httpManager.getGlobalFilter((Class)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cache == null) {
            throw new PropRequestFilterException("no cache filter.");
        }
        try {
            this.localaddr = InetAddress.getLocalHost().getAddress();
            this.localsrc = ((this.localaddr[0] & 0xFF) << 24) + ((this.localaddr[1] & 0xFF) << 16) + ((this.localaddr[2] & 0xFF) << 8) + (this.localaddr[3] & 0xFF);
            this.addr = InetAddress.getByName(string);
            this.socket = new MulticastSocket(this.port);
            this.socket.setTimeToLive(this.ttl);
            this.socket.joinGroup(this.addr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PropRequestFilterException(exception.getMessage());
        }
        this.setName("mICP");
        this.setDaemon(true);
        this.start();
        httpManager.setFilter(this);
    }
}

