/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/jps/build/JpsJsModuleUtils;", "", "()V", "getDependencyModulesAndSources", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "result", "", "", "getLibraryFiles", "getLibraryFilesAndDependencies", "", "getOutputFile", "Ljava/io/File;", "outputDir", "moduleName", "getOutputMetaFile", "jps-plugin"})
public final class JpsJsModuleUtils {
    public static final JpsJsModuleUtils INSTANCE;

    @NotNull
    public final List<String> getLibraryFilesAndDependencies(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        ArrayList result = new ArrayList();
        this.getLibraryFiles(target, result);
        this.getDependencyModulesAndSources(target, result);
        return result;
    }

    public final void getLibraryFiles(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String string = JpsPathUtil.urlToPath((String)root.getUrl());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string);
            }
        }
    }

    public final void getDependencyModulesAndSources(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        JpsUtils.getAllDependencies(target).processModules((Consumer)new Consumer<JpsModule>(target, result){
            final /* synthetic */ ModuleBuildTarget $target;
            final /* synthetic */ List $result;

            public void consume(@NotNull JpsModule module) {
                JpsModuleSourceRoot it;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                if (Intrinsics.areEqual((Object)module.getModuleType(), (Object)JpsJavaModuleType.INSTANCE) ^ true) {
                    return;
                }
                if (Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) ^ true || this.$target.isTests()) {
                    boolean bl;
                    block7: {
                        $receiver$iv = module.getSourceRoots();
                        for (T element$iv : $receiver$iv) {
                            it = (JpsModuleSourceRoot)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getRootType(), (Object)JavaSourceRootType.SOURCE)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                    if (bl) {
                        JavaModuleBuildTargetType javaModuleBuildTargetType = JavaModuleBuildTargetType.PRODUCTION;
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaModuleBuildTargetType, (String)"JavaModuleBuildTargetType.PRODUCTION");
                        this.addTarget(module, javaModuleBuildTargetType);
                    }
                }
                if (Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) ^ true && this.$target.isTests()) {
                    boolean bl;
                    block8: {
                        $receiver$iv = module.getSourceRoots();
                        for (T element$iv : $receiver$iv) {
                            it = (JpsModuleSourceRoot)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getRootType(), (Object)JavaSourceRootType.TEST_SOURCE)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (bl) {
                        JavaModuleBuildTargetType javaModuleBuildTargetType = JavaModuleBuildTargetType.TEST;
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaModuleBuildTargetType, (String)"JavaModuleBuildTargetType.TEST");
                        this.addTarget(module, javaModuleBuildTargetType);
                    }
                }
            }

            public final void addTarget(@NotNull JpsModule module, @NotNull JavaModuleBuildTargetType targetType) {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
                ModuleBuildTarget moduleBuildTarget = new ModuleBuildTarget(module, targetType);
                File outputDir2 = KotlinBuilderModuleScriptGenerator.INSTANCE.getOutputDirSafe(moduleBuildTarget);
                String string = module.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                File metaInfoFile = JpsJsModuleUtils.getOutputMetaFile(outputDir2, string);
                if (metaInfoFile.exists()) {
                    String string2 = metaInfoFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"metaInfoFile.absolutePath");
                    this.$result.add(string2);
                }
            }
            {
                this.$target = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final File getOutputFile(@NotNull File outputDir2, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir2, moduleName + ".js");
    }

    @JvmStatic
    @NotNull
    public static final File getOutputMetaFile(@NotNull File outputDir2, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir2, moduleName + ".meta.js");
    }

    private JpsJsModuleUtils() {
        INSTANCE = this;
    }

    static {
        new JpsJsModuleUtils();
    }
}

