/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.common.persistence.mapping;

import com.intellij.javaee.model.common.persistence.mapping.CascadeType;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NamedEnum;
import java.util.Collection;

public enum CascadeTypeMode implements NamedEnum
{
    ALL("all"),
    PERSIST("persist"),
    MERGE("merge"),
    REMOVE("remove"),
    REFRESH("refresh"),
    DETACH("detach");

    private final String value;

    private CascadeTypeMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.getValue();
    }

    public GenericValue<Boolean> getCascadeTypeModeValue(CascadeType cascadeType) {
        switch (this) {
            case ALL: {
                return cascadeType.getCascadeAll();
            }
            case MERGE: {
                return cascadeType.getCascadeMerge();
            }
            case PERSIST: {
                return cascadeType.getCascadePersist();
            }
            case REFRESH: {
                return cascadeType.getCascadeRefresh();
            }
            case REMOVE: {
                return cascadeType.getCascadeRemove();
            }
            case DETACH: {
                return cascadeType.getCascadeDetach();
            }
        }
        throw new AssertionError();
    }

    public static <T extends Collection<CascadeTypeMode>> T addCascadeTypes(CascadeType cascadeType, T result) {
        for (CascadeTypeMode mode : CascadeTypeMode.values()) {
            if (!Boolean.TRUE.equals(mode.getCascadeTypeModeValue(cascadeType).getValue())) continue;
            result.add((CascadeTypeMode)mode);
        }
        return result;
    }
}

