/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class StatefulButtonUI
extends BasicButtonUI {
    private static final JBColor DISABLED_TEXT = new JBColor(0x999999, 0x777777);
    private static final JBColor COLOR_1 = new JBColor(0xEEEEEE, 0x555A5C);
    private static final JBColor COLOR_2 = new JBColor(0xC0C0C0, 4277832);
    private static final JBColor SELECTION_COLOR_1 = new JBColor(4818404, 3690347);
    private static final JBColor SELECTION_COLOR_2 = new JBColor(4224201, 2306371);
    private static final JBColor SELECTED_BUTTON_FOREGROUND = new JBColor(0xF0F0F0, 0xBBBBBB);
    private static final JBColor DISABLED_TEXT_SHADOW = new JBColor(0xFFFFFF, 0);

    public static ComponentUI createUI(JComponent c) {
        return new StatefulButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    public static boolean isHelpButton(JComponent button) {
        return SystemInfo.isMac && button instanceof JButton && "help".equals(button.getClientProperty("JButton.buttonType"));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (StatefulButtonUI.isHelpButton(c)) {
            ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
            int off = JBUI.scale((int)22);
            int x = (w - off) / 2;
            int y = (h - off) / 2;
            g.fillOval(x, y, off, off);
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
        } else {
            Border border = c.getBorder();
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            boolean square = StatefulButtonUI.isSquare(c);
            if (c.isEnabled() && border != null) {
                Insets ins = border.getBorderInsets(c);
                int yOff = (ins.top + ins.bottom) / 4;
                if (!square) {
                    if (StatefulButtonUI.isDefaultButton(c)) {
                        ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getSelectedButtonColor1(), (float)0.0f, (float)h, (Color)this.getSelectedButtonColor2()));
                    } else {
                        ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
                    }
                }
                int rad = JBUI.scale((int)(square ? 3 : 5));
                g.fillRoundRect(JBUI.scale((int)(square ? 2 : 4)), yOff, w - 2 * JBUI.scale((int)4), h - 2 * yOff, rad, rad);
            }
            config.restore();
            super.paint(g, c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        if (StatefulButtonUI.isHelpButton(c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && StatefulButtonUI.isDefaultButton(button)) {
            fg = SELECTED_BUTTON_FOREGROUND;
        }
        g.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor((Color)DISABLED_TEXT_SHADOW);
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
        g.setColor((Color)DISABLED_TEXT);
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        Border border = c.getBorder();
        if (border != null && StatefulButtonUI.isSquare(c)) {
            int xOff = 1;
            Insets ins = border.getBorderInsets(c);
            int yOff = (ins.top + ins.bottom) / 4;
            Rectangle iconRect2 = new Rectangle(iconRect);
            iconRect2.x += xOff;
            iconRect2.y += yOff;
            super.paintIcon(g, c, iconRect2);
        } else {
            super.paintIcon(g, c, iconRect);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (StatefulButtonUI.isDefaultButton(c) && !SystemInfo.isMac && !c.getFont().isBold()) {
            c.setFont(new FontUIResource(c.getFont().deriveFont(1)));
        }
    }

    protected Color getButtonColor1() {
        return COLOR_1;
    }

    protected Color getButtonColor2() {
        return COLOR_2;
    }

    protected Color getSelectedButtonColor1() {
        return SELECTION_COLOR_1;
    }

    protected Color getSelectedButtonColor2() {
        return SELECTION_COLOR_2;
    }
}

