/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileOpUtils;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.tools.idea.avdmanager.AvdCamera;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNetworkLatency;
import com.android.tools.idea.avdmanager.AvdNetworkSpeed;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableObject;
import com.android.tools.idea.ui.properties.core.ObservableString;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdOptionsModel
extends WizardModel {
    static final int MAX_NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors() / 2;
    private final AvdInfo myAvdInfo;
    private BoolProperty myUseQemu2 = new BoolValueProperty(true);
    private StringProperty myAvdId = new StringValueProperty();
    private StringProperty myAvdDisplayName = new StringValueProperty();
    private ObjectProperty<Storage> myInternalStorage = new ObjectValueProperty<Storage>(AvdWizardUtils.DEFAULT_INTERNAL_STORAGE);
    private ObjectProperty<ScreenOrientation> mySelectedAvdOrientation = new ObjectValueProperty<ScreenOrientation>(ScreenOrientation.PORTRAIT);
    private ObjectProperty<AvdCamera> mySelectedAvdFrontCamera = new ObjectValueProperty<AvdCamera>(AvdWizardUtils.DEFAULT_CAMERA);
    private ObjectProperty<AvdCamera> mySelectedAvdBackCamera = new ObjectValueProperty<AvdCamera>(AvdWizardUtils.DEFAULT_CAMERA);
    private BoolProperty myHasDeviceFrame = new BoolValueProperty(true);
    private BoolProperty myUseExternalSdCard = new BoolValueProperty();
    private BoolProperty myUseBuiltInSdCard = new BoolValueProperty(true);
    private ObjectProperty<AvdNetworkSpeed> mySelectedNetworkSpeed = new ObjectValueProperty<AvdNetworkSpeed>(AvdWizardUtils.DEFAULT_NETWORK_SPEED);
    private ObjectProperty<AvdNetworkLatency> mySelectedNetworkLatency = new ObjectValueProperty<AvdNetworkLatency>(AvdWizardUtils.DEFAULT_NETWORK_LATENCY);
    private StringProperty mySystemImageName = new StringValueProperty();
    private StringProperty mySystemImageDetails = new StringValueProperty();
    private OptionalProperty<Integer> myCpuCoreCount = new OptionalValueProperty<Integer>(MAX_NUMBER_OF_CORES);
    private ObjectProperty<Storage> myVmHeapStorage = new ObjectValueProperty<Storage>(new Storage(16L, Storage.Unit.MiB));
    private StringProperty myExternalSdCardLocation = new StringValueProperty();
    private OptionalProperty<Storage> mySdCardStorage = new OptionalValueProperty<Storage>(new Storage(100L, Storage.Unit.MiB));
    private BoolProperty myUseHostGpu = new BoolValueProperty(true);
    private OptionalProperty<GpuMode> myHostGpuMode = new OptionalValueProperty<GpuMode>(GpuMode.AUTO);
    private BoolProperty myEnableHardwareKeyboard = new BoolValueProperty(true);
    private BoolProperty myIsInEditMode = new BoolValueProperty();
    private OptionalProperty<File> myBackupSkinFile = new OptionalValueProperty<File>();
    private OptionalProperty<SystemImageDescription> mySystemImage = new OptionalValueProperty<SystemImageDescription>();
    private OptionalProperty<Device> myDevice = new OptionalValueProperty<Device>();
    private ObservableString existingSdLocation = new StringValueProperty();
    private ObservableObject<Storage> myOriginalSdCard;
    private AvdDeviceData myAvdDeviceData;
    private AvdInfo myCreatedAvd;

    public AvdOptionsModel(@Nullable AvdInfo avdInfo) {
        this.myAvdInfo = avdInfo;
        this.myAvdDeviceData = new AvdDeviceData();
        if (this.myAvdInfo != null) {
            this.updateValuesWithAvdInfo(this.myAvdInfo);
        }
        this.myDevice.addListener(sender -> {
            if (((Optional)this.myDevice.get()).isPresent()) {
                this.myAvdDeviceData.updateValuesFromDevice(this.myDevice.getValue(), this.mySystemImage.getValueOrNull());
                this.myVmHeapStorage.set(AvdOptionsModel.calculateInitialVmHeap(this.myAvdDeviceData));
            }
        });
        this.mySystemImage.addListener(sender -> {
            if (((Optional)this.myDevice.get()).isPresent()) {
                this.myAvdDeviceData.updateSkinFromDeviceAndSystemImage(this.myDevice.getValue(), this.mySystemImage.getValueOrNull());
            }
        });
    }

    @Nullable
    private static Storage getStorageFromIni(@Nullable String iniString) {
        if (iniString == null) {
            return null;
        }
        String numString = iniString.substring(0, iniString.length() - 1);
        char unitChar = iniString.charAt(iniString.length() - 1);
        Storage.Unit selectedUnit = null;
        for (Storage.Unit u : Storage.Unit.values()) {
            if (u.toString().charAt(0) != unitChar) continue;
            selectedUnit = u;
            break;
        }
        if (selectedUnit == null) {
            selectedUnit = Storage.Unit.MiB;
            numString = iniString;
        }
        try {
            long numLong = Long.parseLong(numString);
            return new Storage(numLong, selectedUnit);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    private static String toIniString(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        String string = String.format(Locale.US, "%f", value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull File value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        String string = value.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        return string;
    }

    @NotNull
    public static String toIniString(@NotNull Storage storage, boolean convertToMb) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        Storage.Unit unit = convertToMb ? Storage.Unit.MiB : storage.getAppropriateUnits();
        String unitString = convertToMb ? "" : unit.toString().substring(0, 1);
        String string = String.format("%1$d%2$s", storage.getSizeAsUnit(unit), unitString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull Boolean b) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        String string = b != false ? "yes" : "no";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "toIniString"));
        }
        return string;
    }

    private static boolean fromIniString(@Nullable String s) {
        return "yes".equals(s);
    }

    @NotNull
    private static String calculateAvdName(@Nullable AvdInfo avdInfo, @NotNull Map<String, String> hardwareProperties, @NotNull Device device) {
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateAvdName"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateAvdName"));
        }
        if (avdInfo != null) {
            String string = avdInfo.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateAvdName"));
            }
            return string;
        }
        String candidateBase = hardwareProperties.get("avd.ini.displayname");
        if (candidateBase == null || candidateBase.isEmpty()) {
            String deviceName = device.getDisplayName().replace(' ', '_');
            String manufacturer = device.getManufacturer().replace(' ', '_');
            candidateBase = String.format("AVD_for_%1$s_by_%2$s", deviceName, manufacturer);
        }
        String string = AvdWizardUtils.cleanAvdName(AvdManagerConnection.getDefaultAvdManagerConnection(), candidateBase, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateAvdName"));
        }
        return string;
    }

    @NotNull
    public BoolProperty useQemu2() {
        BoolProperty boolProperty = this.myUseQemu2;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "useQemu2"));
        }
        return boolProperty;
    }

    @NotNull
    public StringProperty avdId() {
        StringProperty stringProperty = this.myAvdId;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "avdId"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty avdDisplayName() {
        StringProperty stringProperty = this.myAvdDisplayName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "avdDisplayName"));
        }
        return stringProperty;
    }

    @NotNull
    public ObjectProperty<ScreenOrientation> selectedAvdOrientation() {
        ObjectProperty<ScreenOrientation> objectProperty = this.mySelectedAvdOrientation;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "selectedAvdOrientation"));
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<AvdCamera> selectedFrontCamera() {
        ObjectProperty<AvdCamera> objectProperty = this.mySelectedAvdFrontCamera;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "selectedFrontCamera"));
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<AvdCamera> selectedBackCamera() {
        ObjectProperty<AvdCamera> objectProperty = this.mySelectedAvdBackCamera;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "selectedBackCamera"));
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty hasDeviceFrame() {
        BoolProperty boolProperty = this.myHasDeviceFrame;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "hasDeviceFrame"));
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<AvdNetworkSpeed> selectedNetworkSpeed() {
        ObjectProperty<AvdNetworkSpeed> objectProperty = this.mySelectedNetworkSpeed;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "selectedNetworkSpeed"));
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<AvdNetworkLatency> selectedNetworkLatency() {
        ObjectProperty<AvdNetworkLatency> objectProperty = this.mySelectedNetworkLatency;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "selectedNetworkLatency"));
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Storage> internalStorage() {
        ObjectProperty<Storage> objectProperty = this.myInternalStorage;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "internalStorage"));
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty useExternalSdCard() {
        BoolProperty boolProperty = this.myUseExternalSdCard;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "useExternalSdCard"));
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty useBuiltInSdCard() {
        BoolProperty boolProperty = this.myUseBuiltInSdCard;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "useBuiltInSdCard"));
        }
        return boolProperty;
    }

    @NotNull
    public StringProperty systemImageName() {
        StringProperty stringProperty = this.mySystemImageName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "systemImageName"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty systemImageDetails() {
        StringProperty stringProperty = this.mySystemImageDetails;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "systemImageDetails"));
        }
        return stringProperty;
    }

    @NotNull
    public ObjectProperty<Storage> vmHeapStorage() {
        ObjectProperty<Storage> objectProperty = this.myVmHeapStorage;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "vmHeapStorage"));
        }
        return objectProperty;
    }

    @NotNull
    public OptionalProperty<Integer> cpuCoreCount() {
        OptionalProperty<Integer> optionalProperty = this.myCpuCoreCount;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "cpuCoreCount"));
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<Storage> sdCardStorage() {
        OptionalProperty<Storage> optionalProperty = this.mySdCardStorage;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "sdCardStorage"));
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty externalSdCardLocation() {
        StringProperty stringProperty = this.myExternalSdCardLocation;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "externalSdCardLocation"));
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty useHostGpu() {
        BoolProperty boolProperty = this.myUseHostGpu;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "useHostGpu"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<GpuMode> hostGpuMode() {
        OptionalProperty<GpuMode> optionalProperty = this.myHostGpuMode;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "hostGpuMode"));
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty enableHardwareKeyboard() {
        BoolProperty boolProperty = this.myEnableHardwareKeyboard;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "enableHardwareKeyboard"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<File> backupSkinFile() {
        OptionalProperty<File> optionalProperty = this.myBackupSkinFile;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "backupSkinFile"));
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<Device> device() {
        OptionalProperty<Device> optionalProperty = this.myDevice;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "device"));
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty isInEditMode() {
        BoolProperty boolProperty = this.myIsInEditMode;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "isInEditMode"));
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<SystemImageDescription> systemImage() {
        OptionalProperty<SystemImageDescription> optionalProperty = this.mySystemImage;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "systemImage"));
        }
        return optionalProperty;
    }

    @NotNull
    public AvdDeviceData getAvdDeviceData() {
        AvdDeviceData avdDeviceData = this.myAvdDeviceData;
        if (avdDeviceData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "getAvdDeviceData"));
        }
        return avdDeviceData;
    }

    private void updateValuesWithAvdInfo(@NotNull AvdInfo avdInfo) {
        File skinFile;
        String backupSkinPath;
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdOptionsModel", "updateValuesWithAvdInfo"));
        }
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        Device selectedDevice = null;
        String manufacturer = avdInfo.getDeviceManufacturer();
        String deviceId = (String)avdInfo.getProperties().get("hw.device.name");
        for (Device device : devices) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        this.myDevice.setNullableValue(selectedDevice);
        SystemImageDescription systemImageDescription = null;
        ISystemImage selectedImage = avdInfo.getSystemImage();
        if (selectedImage != null) {
            systemImageDescription = new SystemImageDescription(selectedImage);
            this.mySystemImage.setValue(systemImageDescription);
        }
        this.myAvdDeviceData = new AvdDeviceData(selectedDevice, systemImageDescription);
        Map properties = avdInfo.getProperties();
        this.myUseQemu2.set(properties.containsKey("hw.cpu.ncore"));
        String cpuCoreCount = (String)properties.get("hw.cpu.ncore");
        this.myCpuCoreCount.setValue(cpuCoreCount == null ? 1 : Integer.parseInt(cpuCoreCount));
        Storage storage = AvdOptionsModel.getStorageFromIni((String)properties.get("hw.ramSize"));
        if (storage != null) {
            this.myAvdDeviceData.ramStorage().set(storage);
        }
        if ((storage = AvdOptionsModel.getStorageFromIni((String)properties.get("vm.heapSize"))) != null) {
            this.myVmHeapStorage.set(storage);
        }
        if ((storage = AvdOptionsModel.getStorageFromIni((String)properties.get("disk.dataPartition.size"))) != null) {
            this.myInternalStorage.set(storage);
        }
        String sdCardLocation = null;
        if (properties.get("sdcard.path") != null) {
            sdCardLocation = (String)properties.get("sdcard.path");
        } else if (properties.get("sdcard.size") != null) {
            sdCardLocation = FileUtil.join((String[])new String[]{avdInfo.getDataFolderPath(), "sdcard.img"});
        }
        this.existingSdLocation = new StringValueProperty(sdCardLocation);
        String dataFolderPath = avdInfo.getDataFolderPath();
        File sdLocationFile = null;
        if (sdCardLocation != null) {
            sdLocationFile = new File(sdCardLocation);
        }
        if (sdLocationFile != null) {
            if (Objects.equal((Object)sdLocationFile.getParent(), (Object)dataFolderPath)) {
                File sdFile = new File(sdCardLocation);
                Storage sdCardSize = new Storage(sdFile.length());
                this.myUseExternalSdCard.set(false);
                this.myUseBuiltInSdCard.set(true);
                this.myOriginalSdCard = new ObjectValueProperty<Storage>(sdCardSize);
                this.mySdCardStorage.setValue(sdCardSize);
            } else {
                this.myUseExternalSdCard.set(true);
                this.myUseBuiltInSdCard.set(false);
                this.externalSdCardLocation().set(sdCardLocation);
            }
        }
        this.myUseHostGpu.set(AvdOptionsModel.fromIniString((String)properties.get("hw.gpu.enabled")));
        this.mySelectedAvdFrontCamera.set(AvdCamera.fromName((String)properties.get("hw.camera.front")));
        this.mySelectedAvdBackCamera.set(AvdCamera.fromName((String)properties.get("hw.camera.back")));
        this.mySelectedNetworkLatency.set(AvdNetworkLatency.fromName((String)properties.get("runtime.network.latency")));
        this.mySelectedNetworkSpeed.set(AvdNetworkSpeed.fromName((String)properties.get("runtime.network.speed")));
        this.myEnableHardwareKeyboard.set(AvdOptionsModel.fromIniString((String)properties.get("hw.keyboard")));
        this.myAvdDisplayName.set(AvdManagerConnection.getAvdDisplayName(avdInfo));
        this.myHasDeviceFrame.set(AvdOptionsModel.fromIniString((String)properties.get("showDeviceFrame")));
        ScreenOrientation screenOrientation = null;
        String orientation = (String)properties.get("hw.initialOrientation");
        if (!Strings.isNullOrEmpty((String)orientation)) {
            screenOrientation = ScreenOrientation.getByShortDisplayName((String)orientation);
        }
        this.mySelectedAvdOrientation.set(screenOrientation == null ? ScreenOrientation.PORTRAIT : screenOrientation);
        String skinPath = (String)properties.get("skin.path");
        if (skinPath != null) {
            File skinFile2;
            File file = skinFile2 = skinPath.equals(AvdWizardUtils.NO_SKIN.getPath()) ? AvdWizardUtils.NO_SKIN : new File(skinPath);
            if (skinFile2.isDirectory()) {
                this.myAvdDeviceData.customSkinFile().setValue(skinFile2);
            }
        }
        if ((backupSkinPath = (String)properties.get("skin.path.backup")) != null && ((skinFile = new File(backupSkinPath)).isDirectory() || FileUtil.filesEqual((File)skinFile, (File)AvdWizardUtils.NO_SKIN))) {
            this.backupSkinFile().setValue(skinFile);
        }
        String modeString = (String)properties.get("hw.gpu.mode");
        this.myHostGpuMode.setValue(GpuMode.fromGpuSetting((String)modeString));
        this.myIsInEditMode.set(true);
    }

    @NotNull
    private static Storage calculateInitialVmHeap(@NotNull AvdDeviceData deviceData) {
        if (deviceData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceData", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateInitialVmHeap"));
        }
        ScreenSize size = AvdScreenData.getScreenSize((Double)deviceData.diagonalScreenSize().get());
        Density density = AvdScreenData.getScreenDensity((Boolean)deviceData.isTv().get(), (Double)deviceData.screenDpi().get(), (Integer)deviceData.screenResolutionHeight().get());
        int vmHeapSize = 32;
        boolean isScreenXLarge = size.equals((Object)ScreenSize.XLARGE);
        switch (density) {
            case LOW: 
            case MEDIUM: {
                vmHeapSize = isScreenXLarge ? 32 : 16;
                break;
            }
            case TV: 
            case HIGH: 
            case DPI_280: 
            case DPI_360: {
                vmHeapSize = isScreenXLarge ? 64 : 32;
                break;
            }
            case XHIGH: 
            case DPI_400: 
            case DPI_420: 
            case XXHIGH: 
            case DPI_560: 
            case XXXHIGH: {
                vmHeapSize = isScreenXLarge ? 128 : 64;
                break;
            }
        }
        Storage storage = new Storage((long)vmHeapSize, Storage.Unit.MiB);
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "calculateInitialVmHeap"));
        }
        return storage;
    }

    private Map<String, Object> generateUserEditedPropertiesMap() {
        HashMap map = new HashMap();
        map.put((Object)"AvdManager.WizardOnly.DeviceDefinition", this.myDevice);
        map.put((Object)"AvdManager.WizardOnly.SystemImage", this.mySystemImage);
        map.put((Object)"AvdId", this.myAvdId.get());
        map.put((Object)"vm.heapSize", this.myVmHeapStorage.get());
        map.put((Object)"avd.ini.displayname", this.myAvdDisplayName.get());
        map.put((Object)"AvdManager.WizardOnly.DefaultOrientation", this.mySelectedAvdOrientation.get());
        map.put((Object)"hw.ramSize", this.myAvdDeviceData.ramStorage().get());
        map.put((Object)"AvdManager.WizardOnly.isInEditMode", this.myIsInEditMode.get());
        map.put((Object)"hw.keyboard", this.myEnableHardwareKeyboard.get());
        map.put((Object)"hw.initialOrientation", (Object)((ScreenOrientation)this.mySelectedAvdOrientation.get()).getShortDisplayValue());
        map.put((Object)"hw.gpu.enabled", this.myUseHostGpu.get());
        map.put((Object)"showDeviceFrame", this.myHasDeviceFrame.get());
        map.put((Object)"hw.gpu.mode", (Object)this.myHostGpuMode.getValue());
        if (((Boolean)this.myUseQemu2.get()).booleanValue()) {
            if (((Optional)this.myCpuCoreCount.get()).isPresent()) {
                map.put((Object)"hw.cpu.ncore", (Object)this.myCpuCoreCount.getValue());
            } else {
                map.put((Object)"hw.cpu.ncore", (Object)1);
            }
        } else {
            map.remove((Object)"hw.cpu.ncore");
        }
        if (this.myOriginalSdCard != null) {
            map.put((Object)"sdcard.size", this.myOriginalSdCard);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.existingSdLocation.get()))) {
            map.put((Object)"sdcard.path", this.existingSdLocation.get());
        }
        if (!Strings.isNullOrEmpty((String)((String)this.myExternalSdCardLocation.get()))) {
            map.put((Object)"AvdManager.WizardOnly.displaySdLocation", this.myExternalSdCardLocation.get());
        }
        map.put((Object)"AvdManager.WizardOnly.displayUseExistingSd", this.myUseExternalSdCard.get());
        map.put((Object)"disk.dataPartition.size", this.myInternalStorage.get());
        map.put((Object)"runtime.network.speed", (Object)((AvdNetworkSpeed)((Object)this.mySelectedNetworkSpeed.get())).getAsParameter());
        map.put((Object)"runtime.network.latency", (Object)((AvdNetworkLatency)((Object)this.mySelectedNetworkLatency.get())).getAsParameter());
        map.put((Object)"hw.camera.front", (Object)((AvdCamera)((Object)this.mySelectedAvdFrontCamera.get())).getAsParameter());
        map.put((Object)"hw.camera.back", (Object)((AvdCamera)((Object)this.mySelectedAvdBackCamera.get())).getAsParameter());
        if (((Optional)this.myAvdDeviceData.customSkinFile().get()).isPresent()) {
            map.put((Object)"skin.path", (Object)this.myAvdDeviceData.customSkinFile().getValue());
        }
        if (((Optional)this.myBackupSkinFile.get()).isPresent()) {
            map.put((Object)"skin.path.backup", (Object)this.myBackupSkinFile.getValue());
        }
        if (((Optional)this.mySdCardStorage.get()).isPresent()) {
            map.put((Object)"AvdManager.WizardOnly.displaySdCardSize", (Object)this.mySdCardStorage.getValue());
        }
        return map;
    }

    @Override
    protected void handleFinished() {
        ISystemImage image;
        String avdName;
        File skinFile;
        boolean hasSdCard;
        Device device = this.myDevice.getValue();
        SystemImageDescription systemImage = this.mySystemImage.getValue();
        Map hardwareProperties = DeviceManager.getHardwareProperties((Device)device);
        Map userEditedProperties = this.generateUserEditedPropertiesMap();
        String sdCard = null;
        boolean useExisting = (Boolean)this.myUseExternalSdCard.get();
        if (!useExisting && ((Optional)this.sdCardStorage().get()).isPresent() && this.myOriginalSdCard != null && this.sdCardStorage().getValue().equals(this.myOriginalSdCard.get())) {
            useExisting = true;
        }
        if (!useExisting) {
            userEditedProperties.remove("sdcard.path");
            Storage storage = null;
            this.myOriginalSdCard = new ObjectValueProperty<Storage>(this.mySdCardStorage.getValue());
            if (((Optional)this.mySdCardStorage.get()).isPresent()) {
                storage = this.mySdCardStorage.getValue();
                sdCard = AvdOptionsModel.toIniString(storage, false);
            }
            hasSdCard = storage != null && storage.getSize() > 0L;
        } else {
            sdCard = (String)this.existingSdLocation.get();
            userEditedProperties.remove("sdcard.size");
            hasSdCard = true;
        }
        hardwareProperties.put("hw.sdCard", AvdOptionsModel.toIniString(hasSdCard));
        userEditedProperties = Maps.filterEntries(userEditedProperties, input -> !((String)input.getKey()).startsWith("AvdManager.WizardOnly.") && input.getValue() != null);
        hardwareProperties.putAll(Maps.transformEntries((Map)userEditedProperties, (key, value) -> {
            if (value instanceof Storage) {
                if (key.equals("hw.ramSize") || key.equals("vm.heapSize")) {
                    return AvdOptionsModel.toIniString((Storage)value, true);
                }
                return AvdOptionsModel.toIniString((Storage)value, false);
            }
            if (value instanceof Boolean) {
                return AvdOptionsModel.toIniString((Boolean)value);
            }
            if (value instanceof File) {
                return AvdOptionsModel.toIniString((File)value);
            }
            if (value instanceof Double) {
                return AvdOptionsModel.toIniString((Double)value);
            }
            if (value instanceof GpuMode) {
                return ((GpuMode)value).getGpuSetting();
            }
            return value.toString();
        }));
        File file = skinFile = ((Optional)this.myAvdDeviceData.customSkinFile().get()).isPresent() ? this.myAvdDeviceData.customSkinFile().getValue() : AvdWizardUtils.resolveSkinPath(device.getDefaultHardware().getSkinFile(), systemImage, FileOpUtils.create());
        if (((Optional)this.myBackupSkinFile.get()).isPresent()) {
            hardwareProperties.put("skin.path.backup", this.myBackupSkinFile.getValue().getPath());
        }
        if (!hardwareProperties.containsKey("skin.dynamic")) {
            hardwareProperties.put("skin.dynamic", AvdOptionsModel.toIniString(true));
        }
        if (!hardwareProperties.containsKey("hw.keyboard")) {
            hardwareProperties.put("hw.keyboard", AvdOptionsModel.toIniString(false));
        }
        boolean isCircular = (Boolean)this.myAvdDeviceData.isScreenRound().get();
        String tempAvdName = (String)this.myAvdId.get();
        String string = avdName = tempAvdName.isEmpty() ? AvdOptionsModel.calculateAvdName(this.myAvdInfo, hardwareProperties, device) : tempAvdName;
        if (this.myAvdInfo != null && (image = this.myAvdInfo.getSystemImage()) != null) {
            int oldApiLevel = image.getAndroidVersion().getFeatureLevel();
            int newApiLevel = systemImage.getVersion().getFeatureLevel();
            String oldApiName = image.getAndroidVersion().getApiString();
            String newApiName = systemImage.getVersion().getApiString();
            if (oldApiLevel > newApiLevel || oldApiLevel == newApiLevel && image.getAndroidVersion().isPreview() && !systemImage.getVersion().isPreview()) {
                AtomicReference shouldContinue = new AtomicReference();
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String message = String.format(Locale.getDefault(), "You are about to downgrade %1$s from API level %2$s to API level %3$s.\nThis requires a wipe of the userdata partition of the AVD.\nDo you wish to continue with the data wipe?", avdName, oldApiName, newApiName);
                    int result = Messages.showYesNoDialog((Project)null, (String)message, (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog);
                    shouldContinue.set(result == 0);
                }, ModalityState.any());
                if (((Boolean)shouldContinue.get()).booleanValue()) {
                    AvdManagerConnection.getDefaultAvdManagerConnection().wipeUserData(this.myAvdInfo);
                } else {
                    return;
                }
            }
        }
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        this.myCreatedAvd = connection.createOrUpdateAvd(this.myAvdInfo, avdName, device, systemImage, (ScreenOrientation)this.mySelectedAvdOrientation.get(), isCircular, sdCard, skinFile, hardwareProperties, false);
    }

    @NotNull
    public AvdInfo getCreatedAvd() {
        AvdInfo avdInfo = this.myCreatedAvd;
        if (avdInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdOptionsModel", "getCreatedAvd"));
        }
        return avdInfo;
    }
}

