/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.snippets;

import com.android.tools.idea.editors.gfxtrace.service.snippets.FieldPath;
import com.android.tools.idea.editors.gfxtrace.service.snippets.PartPath;
import com.android.tools.idea.editors.gfxtrace.service.snippets.RelativePath;
import com.android.tools.idea.editors.gfxtrace.service.snippets.SnippetsProtos;
import com.android.tools.rpclib.binary.BinaryObject;

public abstract class Pathway
implements BinaryObject {
    public static Pathway wrap(BinaryObject obj) {
        return (Pathway)obj;
    }

    public BinaryObject unwrap() {
        return this;
    }

    public abstract Pathway base();

    public static Pathway param(String typeName, String paramName) {
        return new RelativePath().setTypeName(typeName).field(paramName);
    }

    public static Pathway global(String name) {
        return new RelativePath().setTypeName("State").field(name);
    }

    public Pathway field(String name) {
        return new FieldPath(this, name);
    }

    public Pathway key() {
        return new PartPath(this, SnippetsProtos.PartKind.Key);
    }

    public Pathway elem() {
        return new PartPath(this, SnippetsProtos.PartKind.Elem);
    }

    public boolean isPrefix(Pathway pathway) {
        int otherDepth;
        int thisDepth = this.depth();
        if (thisDepth > (otherDepth = pathway.depth())) {
            return false;
        }
        int diff = otherDepth - thisDepth;
        Pathway p = pathway;
        for (int i = 0; i < diff; ++i) {
            p = p.base();
        }
        return this.equals(p);
    }

    public String toString() {
        return this.stringPath(new StringBuilder()).toString();
    }

    private StringBuilder stringPath(StringBuilder stringBuilder) {
        Pathway parent = this.base();
        if (parent != null) {
            parent.stringPath(stringBuilder);
            this.appendSegmentToPath(stringBuilder);
        } else {
            stringBuilder.append(this.getSegmentString());
        }
        return stringBuilder;
    }

    public void appendSegmentToPath(StringBuilder builder) {
        builder.append("/");
        builder.append(this.getSegmentString());
    }

    public abstract String getSegmentString();

    private int depth() {
        Pathway p = this;
        int i = 0;
        while (p != null) {
            p = p.base();
            ++i;
        }
        return i;
    }
}

