/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.vec;

public class VecD {
    public final double x;
    public final double y;
    public final double z;
    private final int h;

    public VecD() {
        this(0.0, 0.0, 0.0);
    }

    public VecD(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        long hl = Double.doubleToLongBits(x) + 31L * (Double.doubleToLongBits(y) + 31L * Double.doubleToLongBits(z));
        this.h = (int)(hl ^ hl >>> 32);
    }

    public int hashCode() {
        return this.h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VecD)) {
            return false;
        }
        VecD o = (VecD)obj;
        return this.x == o.x && this.y == o.y && this.z == o.z;
    }

    public double get(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public VecD add(VecD v) {
        return new VecD(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public VecD add(double v) {
        return new VecD(this.x + v, this.y + v, this.z + v);
    }

    public VecD addScaled(VecD v, double s) {
        return new VecD(this.x + s * v.x, this.y + s * v.y, this.z + s * v.z);
    }

    public VecD subtract(VecD v) {
        return new VecD(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public VecD subtract(double v) {
        return new VecD(this.x - v, this.y - v, this.z - v);
    }

    public VecD multiply(VecD v) {
        return new VecD(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    public VecD scale(double v) {
        return new VecD(this.x * v, this.y * v, this.z * v);
    }

    public VecD divide(double v) {
        return new VecD(this.x / v, this.y / v, this.z / v);
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double distanceSquared(VecD v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(VecD v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public VecD normalize() {
        double s = this.magnitude();
        return s == 0.0 ? this : this.divide(s);
    }

    public VecD abs() {
        return new VecD(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public VecD min(VecD v) {
        return new VecD(Math.min(this.x, v.x), Math.min(this.y, v.y), Math.min(this.z, v.z));
    }

    public VecD min(double v) {
        return new VecD(Math.min(this.x, v), Math.min(this.y, v), Math.min(this.z, v));
    }

    public VecD max(VecD v) {
        return new VecD(Math.max(this.x, v.x), Math.max(this.y, v.y), Math.max(this.z, v.z));
    }

    public VecD max(double v) {
        return new VecD(Math.max(this.x, v), Math.max(this.y, v), Math.max(this.z, v));
    }

    public double dot(VecD v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public VecD cross(VecD v) {
        return new VecD(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public VecD lerp(VecD v, double a) {
        return new VecD(v.x + (this.x - v.x) * a, v.y + (this.y - v.y) * a, v.z + (this.z - v.z) * a);
    }

    public static VecD fromArray(double[] v) {
        return new VecD(v[0], v[1], v[2]);
    }

    public static void min(double[] target, double[] buffer, int offset) {
        target[0] = Math.min(target[0], buffer[offset + 0]);
        target[1] = Math.min(target[1], buffer[offset + 1]);
        target[2] = Math.min(target[2], buffer[offset + 2]);
    }

    public static void min(double[] target, double x, double y, double z) {
        target[0] = Math.min(target[0], x);
        target[1] = Math.min(target[1], y);
        target[2] = Math.min(target[2], z);
    }

    public static void max(double[] target, double[] buffer, int offset) {
        target[0] = Math.max(target[0], buffer[offset + 0]);
        target[1] = Math.max(target[1], buffer[offset + 1]);
        target[2] = Math.max(target[2], buffer[offset + 2]);
    }

    public static void max(double[] target, double x, double y, double z) {
        target[0] = Math.max(target[0], x);
        target[1] = Math.max(target[1], y);
        target[2] = Math.max(target[2], z);
    }
}

