/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private final AndroidFacet myFacet;
    private final List<String> myKeys;
    private final Set<String> myUntranslatableKeys;
    private final List<Locale> myLocales;
    private final Map<String, ResourceItem> myDefaultValues;
    private final HashBasedTable<String, Locale, ResourceItem> myTranslations;

    public StringResourceData(@NotNull AndroidFacet facet, @NotNull List<String> keys, @NotNull Collection<String> untranslatableKeys, @NotNull Collection<Locale> locales, @NotNull Map<String, ResourceItem> defaultValues, @NotNull Table<String, Locale, ResourceItem> translations) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (untranslatableKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untranslatableKeys", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (locales == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locales", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        if (translations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "translations", "com/android/tools/idea/editors/strings/StringResourceData", "<init>"));
        }
        this.myFacet = facet;
        this.myKeys = Lists.newArrayList(keys);
        this.myUntranslatableKeys = Sets.newHashSet(untranslatableKeys);
        this.myLocales = Lists.newArrayList(locales);
        this.myDefaultValues = Maps.newHashMap(defaultValues);
        this.myTranslations = HashBasedTable.create(translations);
    }

    @NotNull
    public List<String> getKeys() {
        List<String> list = this.myKeys;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getKeys"));
        }
        return list;
    }

    @NotNull
    public Set<String> getUntranslatableKeys() {
        Set<String> set = this.myUntranslatableKeys;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getUntranslatableKeys"));
        }
        return set;
    }

    @NotNull
    public List<Locale> getLocales() {
        List<Locale> list = this.myLocales;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getLocales"));
        }
        return list;
    }

    @NotNull
    public Map<String, ResourceItem> getDefaultValues() {
        Map<String, ResourceItem> map = this.myDefaultValues;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getDefaultValues"));
        }
        return map;
    }

    @NotNull
    public Table<String, Locale, ResourceItem> getTranslations() {
        HashBasedTable<String, Locale, ResourceItem> hashBasedTable = this.myTranslations;
        if (hashBasedTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getTranslations"));
        }
        return hashBasedTable;
    }

    @NotNull
    public String resourceToString(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        ResourceItem item = this.myDefaultValues.get(key);
        String string = item == null ? "" : this.resourceToString(item);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        return string;
    }

    @NotNull
    public String resourceToString(@NotNull String key, @NotNull Locale locale) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        ResourceItem item = (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        String string = item == null ? "" : this.resourceToString(item);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        return string;
    }

    @NotNull
    private String resourceToString(@NotNull ResourceItem item) {
        String string;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), item);
        if (tag == null) {
            ResourceValue value = item.getResourceValue(false);
            if (value == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
                }
                return "";
            }
            string = value.getRawXmlValue();
        } else {
            string = tag.getValue().getText();
        }
        String string2 = Strings.nullToEmpty((String)ValueXmlHelper.unescapeResourceString((String)string, (boolean)false, (boolean)false));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "resourceToString"));
        }
        return string2;
    }

    public void changeKeyName(int index, String name) {
        if (index >= this.myKeys.size()) {
            throw new IllegalArgumentException(String.format("Cannot change key at index %1$d (# of entries: %2$d)", index, this.myKeys.size()));
        }
        if (this.myKeys.contains(name)) {
            throw new IllegalArgumentException("Key " + name + " already exists.");
        }
        String currentName = this.myKeys.get(index);
        ResourceItem defaultValue = this.myDefaultValues.get(currentName);
        Map translations = this.myTranslations.row((Object)currentName);
        this.myKeys.remove(index);
        this.myKeys.add(name);
        Collections.sort(this.myKeys);
        if (defaultValue != null) {
            this.myDefaultValues.remove(currentName);
            this.myDefaultValues.put(name, defaultValue);
        }
        if (!translations.isEmpty()) {
            this.myTranslations.row((Object)name).putAll(translations);
            translations.clear();
        }
    }

    public boolean setDoNotTranslate(String key, boolean doNotTranslate) {
        ResourceItem item = this.myDefaultValues.get(key);
        if (item != null) {
            String translatable;
            if (doNotTranslate) {
                translatable = "false";
                this.myUntranslatableKeys.add(key);
            } else {
                translatable = null;
                this.myUntranslatableKeys.remove(key);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatable, Collections.singletonList(item));
        }
        return false;
    }

    public boolean setTranslation(@NotNull String key, @Nullable Locale locale, @NotNull String value) {
        ResourceItem currentItem;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "setTranslation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/strings/StringResourceData", "setTranslation"));
        }
        ResourceItem resourceItem = currentItem = locale == null ? this.myDefaultValues.get(key) : (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        if (currentItem != null) {
            String oldText = this.resourceToString(currentItem);
            if (!StringUtil.equals((CharSequence)oldText, (CharSequence)value)) {
                boolean changed = StringsWriteUtils.setItemText(this.myFacet.getModule().getProject(), currentItem, value);
                if (changed && value.isEmpty()) {
                    if (locale == null) {
                        this.myDefaultValues.remove(key);
                    } else {
                        this.myTranslations.remove((Object)key, (Object)locale);
                    }
                }
                return changed;
            }
        } else {
            VirtualFile primaryResourceDir = this.myFacet.getPrimaryResourceDir();
            assert (primaryResourceDir != null);
            ResourceItem item = StringsWriteUtils.createItem(this.myFacet, primaryResourceDir, locale, key, value, !this.getUntranslatableKeys().contains(key));
            if (item != null) {
                if (locale == null) {
                    this.myDefaultValues.put(key, item);
                } else {
                    this.myTranslations.put((Object)key, (Object)locale, (Object)item);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "validateKey"));
        }
        if (!this.myKeys.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        Map translationsForKey = this.myTranslations.row((Object)key);
        if (this.myUntranslatableKeys.contains(key)) {
            if (!translationsForKey.isEmpty()) {
                Set<Locale> localesWithTranslation = translationsForKey.keySet();
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (this.myDefaultValues.get(key) == null) {
                return "Key '" + key + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key, StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @Nullable
    public String validateTranslation(@NotNull String key, @Nullable Locale locale) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "validateTranslation"));
        }
        if (!this.myKeys.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        if (locale == null) {
            ResourceItem item = this.myDefaultValues.get(key);
            return item == null ? String.format("Key '%1$s' is missing the default value", key) : null;
        }
        boolean translationMissing = this.isTranslationMissing(key, locale);
        boolean doNotTranslate = this.myUntranslatableKeys.contains(key);
        if (translationMissing && !doNotTranslate) {
            return String.format("Key '%1$s' is missing %2$s translation", key, StringResourceData.getLabel(locale));
        }
        if (doNotTranslate && !translationMissing) {
            return String.format("Key '%1$s' is marked as non-localizable, and should not be translated to %2$s", key, StringResourceData.getLabel(locale));
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    Collection<Locale> getMissingTranslations(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "getMissingTranslations"));
        }
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.myLocales) {
            if (!this.isTranslationMissing(key, locale)) continue;
            missingTranslations.add(locale);
        }
        HashSet hashSet = missingTranslations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "getMissingTranslations"));
        }
        return hashSet;
    }

    @VisibleForTesting
    boolean isTranslationMissing(@NotNull String key, @NotNull Locale locale) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringResourceData", "isTranslationMissing"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/editors/strings/StringResourceData", "isTranslationMissing"));
        }
        ResourceItem item = (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        if (this.isTranslationMissing(item) && locale.hasRegion()) {
            locale = Locale.create(locale.qualifier.getLanguage());
            item = (ResourceItem)this.myTranslations.get((Object)key, (Object)locale);
        }
        return this.isTranslationMissing(item);
    }

    private boolean isTranslationMissing(@Nullable ResourceItem item) {
        return item == null || this.resourceToString(item).isEmpty();
    }

    @VisibleForTesting
    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locales", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
        }
        if (locales.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            String string = StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return string;
        }
        int max = 3;
        List<Locale> sorted = StringResourceData.getLowest(locales, 3);
        if (size <= 3) {
            String string = String.format("%1$s and %2$s", StringResourceData.getLabels(Iterables.limit(sorted, (int)(size - 1))), StringResourceData.getLabel(sorted.get(size - 1)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
            }
            return string;
        }
        String string = String.format("%1$s and %2$d more", StringResourceData.getLabels(sorted), size - 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceData", "summarizeLocales"));
        }
        return string;
    }

    private static List<Locale> getLowest(Collection<Locale> locales, int n) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)n);
        ArrayList input = Lists.newArrayList(locales);
        Comparator<Locale> comparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale l1, Locale l2) {
                return StringResourceData.getLabel(l1).compareTo(StringResourceData.getLabel(l2));
            }
        };
        for (int i = 0; i < locales.size() && i < n; ++i) {
            Locale min = Collections.min(input, comparator);
            result.add(min);
            input.remove(min);
        }
        return result;
    }

    private static String getLabels(Iterable<Locale> locales) {
        return Joiner.on((String)", ").join(Iterables.transform(locales, (Function)new Function<Locale, String>(){

            public String apply(Locale locale) {
                return StringResourceData.getLabel(locale);
            }
        }));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }
}

