/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private List<String> myToBeAppliedPlugins;

    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath(project));
        return file != null ? GradleBuildModel.parseBuildFile(file, project, project.getName()) : null;
    }

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(file, project, "<Unknown>");
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        GradleBuildModel.populateWithParentModuleSubProjectsProperties(buildDslFile);
        GradleBuildModel.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
        buildDslFile.parse();
        GradleBuildModel gradleBuildModel = new GradleBuildModel(buildDslFile);
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "populateWithParentModuleSubProjectsProperties"));
        }
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get(buildDslFile.getProject());
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null) {
            return;
        }
        GradleDslFile parentModuleDslFile = parentModuleModel.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getProperty("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "populateSiblingDslFileWithGradlePropertiesFile"));
        }
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)true);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = GradlePropertiesModel.parsePropertiesFile(propertiesFile, buildDslFile.getProject(), buildDslFile.getName());
        if (propertiesModel == null) {
            return;
        }
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "<init>"));
        }
        super(buildDslFile);
        this.myToBeAppliedPlugins = new ArrayList<String>();
    }

    @NotNull
    public List<String> appliedPlugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getProperty("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
            }
            return immutableList;
        }
        List<String> listProperty = applyDslElement.getListProperty(PLUGIN, String.class);
        if (listProperty == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
            }
            return immutableList;
        }
        LinkedHashSet plugins = Sets.newLinkedHashSet(listProperty);
        plugins.addAll(this.myToBeAppliedPlugins);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)plugins);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
        }
        return immutableList;
    }

    @NotNull
    public GradleBuildModel applyPlugin(String plugin) {
        this.myToBeAppliedPlugins.add(plugin.trim());
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "applyPlugin"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removePlugin(String plugin) {
        plugin = plugin.trim();
        ApplyDslElement applyDslElement = this.myGradleDslFile.getProperty("apply", ApplyDslElement.class);
        if (applyDslElement != null) {
            while (this.appliedPlugins().contains(plugin)) {
                this.myToBeAppliedPlugins.remove(plugin);
                applyDslElement.removeFromExpressionList(PLUGIN, plugin);
            }
        }
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removePlugin"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getProperty("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        AndroidModel androidModel = new AndroidModel(androidDslElement);
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "android"));
        }
        return androidModel;
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getProperty("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        BuildScriptModel buildScriptModel = new BuildScriptModel(buildScriptDslElement);
        if (buildScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "buildscript"));
        }
        return buildScriptModel;
    }

    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getProperty("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        return new DependenciesModel(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getProperty("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        ExtModel extModel = new ExtModel(extDslElement);
        if (extModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "ext"));
        }
        return extModel;
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getProperty("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        JavaModel javaModel = new JavaModel(javaDslElement);
        if (javaModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "java"));
        }
        return javaModel;
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getProperty("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        RepositoriesModel repositoriesModel = new RepositoriesModel(repositoriesDslElement);
        if (repositoriesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "repositories"));
        }
        return repositoriesModel;
    }

    @Override
    public void resetState() {
        this.myToBeAppliedPlugins.clear();
        super.resetState();
    }

    @Override
    public void applyChanges() {
        for (String plugin : this.myToBeAppliedPlugins) {
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, "apply");
            applyMap.addNewLiteral(PLUGIN, plugin);
            applyMap.create();
            applyMap.applyChanges();
            this.myGradleDslFile.addParsedElement("apply", applyMap);
        }
        super.applyChanges();
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "parse"));
            }
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    GradleDslParser.parse(e, this);
                }
            }));
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "addParsedElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "addParsedElement"));
            }
            if ("apply".equals(property) && element instanceof GradleDslExpressionMap) {
                ApplyDslElement applyDslElement = this.getProperty("apply", ApplyDslElement.class);
                if (applyDslElement == null) {
                    applyDslElement = new ApplyDslElement(this);
                    super.addParsedElement("apply", applyDslElement);
                }
                for (Map.Entry<String, GradleDslElement> entry : ((GradleDslExpressionMap)element).getPropertyElements().entrySet()) {
                    applyDslElement.addParsedElement(entry.getKey(), entry.getValue());
                }
                return;
            }
            super.addParsedElement(property, element);
        }

        @Override
        public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (("sourceCompatibility".equals(property) || "targetCompatibility".equals(property)) && (element instanceof GradleDslLiteral || element instanceof GradleDslReference)) {
                JavaDslElement javaDslElement = this.getProperty("java", JavaDslElement.class);
                if (javaDslElement == null) {
                    javaDslElement = new JavaDslElement(this);
                    super.setParsedElement("java", javaDslElement);
                }
                javaDslElement.setParsedElement(property, element);
                return;
            }
            super.setParsedElement(property, element);
        }

        @Override
        protected void reset() {
            super.reset();
        }

        @Override
        protected void apply() {
            super.apply();
        }
    }
}

