/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleModelVersions;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.LibraryAttachments;
import com.android.tools.idea.gradle.project.PluginVersionForcedUpdateDialog;
import com.android.tools.idea.gradle.project.PluginVersionRecommendedUpdateDialog;
import com.android.tools.idea.gradle.project.ProjectDiagnostics;
import com.android.tools.idea.gradle.project.ProjectJdkChecks;
import com.android.tools.idea.gradle.project.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.testing.TestArtifactSearchScopes;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostProjectSetupTasksExecutor {
    private static final GradleVersion GRADLE_VERSION_WITH_SECURITY_FIX = GradleVersion.parse((String)"2.14.1");
    private static boolean ourNewSdkVersionToolsInfoAlreadyShown;
    private static boolean ourCheckedExpiration;
    private static final boolean DEFAULT_GENERATE_SOURCES_AFTER_SYNC = true;
    private static final boolean DEFAULT_CLEAN_PROJECT_AFTER_SYNC = false;
    private static final boolean DEFAULT_USING_CACHED_PROJECT_DATA = false;
    private static final long DEFAULT_LAST_SYNC_TIMESTAMP = -1L;
    @NotNull
    private final Project myProject;
    private volatile boolean myGenerateSourcesAfterSync;
    private boolean myCleanProjectAfterSync;
    private volatile boolean myUsingCachedProjectData;
    private volatile long myLastSyncTimestamp;

    @NotNull
    public static PostProjectSetupTasksExecutor getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        PostProjectSetupTasksExecutor postProjectSetupTasksExecutor = (PostProjectSetupTasksExecutor)ServiceManager.getService((Project)project, PostProjectSetupTasksExecutor.class);
        if (postProjectSetupTasksExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        return postProjectSetupTasksExecutor;
    }

    public PostProjectSetupTasksExecutor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "<init>"));
        }
        this.myGenerateSourcesAfterSync = true;
        this.myCleanProjectAfterSync = false;
        this.myUsingCachedProjectData = false;
        this.myLastSyncTimestamp = -1L;
        this.myProject = project;
    }

    public void onProjectSyncCompletion() {
        boolean userAcceptsUpgrade;
        if (Projects.lastGradleSyncFailed(this.myProject) && this.myUsingCachedProjectData) {
            this.myUsingCachedProjectData = false;
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
            this.reset();
            return;
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        messages.reportDependencySetupErrors();
        messages.reportComponentIncompatibilities();
        ProjectDiagnostics.findAndReportStructureIssues(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!ProjectJdkChecks.hasCorrectJdkVersion(module)) break;
        }
        if (Projects.hasErrors(this.myProject) || Projects.lastGradleSyncFailed(this.myProject)) {
            this.addSdkLinkIfNecessary();
            PostProjectSetupTasksExecutor.checkSdkToolsVersion(this.myProject);
            this.updateGradleSyncState();
            return;
        }
        AndroidGradleModelVersions modelVersions = AndroidGradleModelVersions.find(this.myProject);
        if (modelVersions == null) {
            Logger.getInstance(PostProjectSetupTasksExecutor.class).warn("Unable to obtain application's Android Project");
        } else {
            PostProjectSetupTasksExecutor.log(modelVersions);
        }
        if (modelVersions != null && this.previewForcedToUpgrade(modelVersions) || this.myProject.isDisposed()) {
            return;
        }
        GradleVersion currentModelVersion = null;
        GradleVersion latestModelVersion = null;
        if (modelVersions != null) {
            currentModelVersion = modelVersions.getCurrent();
            latestModelVersion = modelVersions.getLatest();
        }
        GradleVersion gradleVersion = GradleUtil.getGradleVersion(this.myProject);
        if (modelVersions != null && PostProjectSetupTasksExecutor.shouldRecommendUpgrade(latestModelVersion, currentModelVersion, gradleVersion) && (userAcceptsUpgrade = new PluginVersionRecommendedUpdateDialog(this.myProject, currentModelVersion, latestModelVersion).showAndGet()) && this.updateGradlePluginVersion(modelVersions.getLatest(), modelVersions.isExperimentalPlugin())) {
            return;
        }
        new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
        Projects.executeProjectChanges(this.myProject, () -> {
            IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(this.myProject);
            try {
                this.attachSourcesToLibraries((IdeModifiableModelsProvider)modelsProvider);
                this.adjustModuleStructures((IdeModifiableModelsProvider)modelsProvider);
                modelsProvider.commit();
            }
            catch (Throwable t) {
                modelsProvider.dispose();
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
            this.ensureValidSdks();
        });
        Projects.enforceExternalBuild(this.myProject);
        AndroidGradleProjectComponent.getInstance(this.myProject).checkForSupportedModules();
        this.findAndShowVariantConflicts();
        PostProjectSetupTasksExecutor.checkSdkToolsVersion(this.myProject);
        this.addSdkLinkIfNecessary();
        TestArtifactSearchScopes.initializeScopes(this.myProject);
        String taskName = AndroidStudioInitializer.isAndroidStudio() ? "Gradle-aware Make" : ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
        this.setMakeStepInJunitRunConfigurations(taskName);
        this.updateGradleSyncState();
        if (this.myGenerateSourcesAfterSync) {
            if (!this.myCleanProjectAfterSync) {
                Map<String, GradleVersion> previousPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                Projects.storePluginVersionsPerModule(this.myProject);
                if (previousPluginVersionsPerModule != null && !previousPluginVersionsPerModule.isEmpty()) {
                    Map<String, GradleVersion> currentPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                    assert (currentPluginVersionsPerModule != null);
                    for (Map.Entry<String, GradleVersion> entry : currentPluginVersionsPerModule.entrySet()) {
                        String modulePath = entry.getKey();
                        GradleVersion previous = previousPluginVersionsPerModule.get(modulePath);
                        if (previous != null && entry.getValue().compareTo(previous) == 0) continue;
                        this.myCleanProjectAfterSync = true;
                        break;
                    }
                }
            }
            GradleProjectBuilder.getInstance(this.myProject).generateSourcesOnly(this.myCleanProjectAfterSync);
        }
        this.reset();
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
        this.disposeModulesMarkedForRemoval();
    }

    static boolean shouldRecommendUpgrade(@Nullable GradleVersion latestModelVersion, @Nullable GradleVersion currentModelVersion, @Nullable GradleVersion gradleVersion) {
        return PostProjectSetupTasksExecutor.shouldRecommendUpgradeBasedOnModelVersion(latestModelVersion, currentModelVersion) || PostProjectSetupTasksExecutor.shouldRecommendUpgradeBasedOnGradleVersion(gradleVersion);
    }

    private static boolean shouldRecommendUpgradeBasedOnGradleVersion(@Nullable GradleVersion gradleVersion) {
        return gradleVersion != null && gradleVersion.compareTo(GRADLE_VERSION_WITH_SECURITY_FIX) < 0;
    }

    private static boolean shouldRecommendUpgradeBasedOnModelVersion(@Nullable GradleVersion latestModelVersion, @Nullable GradleVersion currentModelVersion) {
        return currentModelVersion != null && latestModelVersion != null && currentModelVersion.compareTo(latestModelVersion) < 0;
    }

    private void reset() {
        this.myGenerateSourcesAfterSync = true;
        this.myCleanProjectAfterSync = false;
    }

    private boolean previewForcedToUpgrade(@NotNull AndroidGradleModelVersions modelVersions) {
        if (modelVersions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersions", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "previewForcedToUpgrade"));
        }
        if (!PostProjectSetupTasksExecutor.shouldPreviewBeForcedToUpgradePluginVersion(modelVersions)) {
            return false;
        }
        this.updateGradleSyncState();
        boolean experimentalPlugin = modelVersions.isExperimentalPlugin();
        boolean userAcceptsForcedUpgrade = new PluginVersionForcedUpdateDialog(this.myProject, experimentalPlugin).showAndGet();
        GradleVersion latest = modelVersions.getLatest();
        if (userAcceptsForcedUpgrade) {
            this.updateGradlePluginVersion(latest, experimentalPlugin);
        } else {
            String[] text = new String[]{"The project is using an incompatible version of the Android Gradle " + (experimentalPlugin ? "Experimental " : "") + "plugin.", "Please update your project to use version " + (experimentalPlugin ? "0.8.2" : "2.2.2") + "."};
            Message msg = new Message("Gradle Sync Issue", Message.Type.ERROR, text);
            String pluginName = experimentalPlugin ? "com.android.tools.build:gradle-experimental:" : "com.android.tools.build:gradle:";
            SearchInBuildFilesHyperlink quickFix = new SearchInBuildFilesHyperlink(pluginName);
            ProjectSyncMessages.getInstance(this.myProject).add(msg, quickFix);
            GradleUtil.invalidateLastSync(this.myProject, "Failed");
        }
        return true;
    }

    private boolean updateGradlePluginVersion(@NotNull GradleVersion latest, boolean experimentalPlugin) {
        if (latest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "latest", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateGradlePluginVersion"));
        }
        if (experimentalPlugin) {
            return GradleUtil.updateGradleExperimentalPluginVersionAndNotifyFailure(this.myProject, latest, "2.14.1", true);
        }
        return GradleUtil.updateGradlePluginVersionAndNotifyFailure(this.myProject, latest, "2.14.1", true);
    }

    @VisibleForTesting
    static boolean shouldPreviewBeForcedToUpgradePluginVersion(@NotNull AndroidGradleModelVersions modelVersions) {
        if (modelVersions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersions", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "shouldPreviewBeForcedToUpgradePluginVersion"));
        }
        GradleVersion current = modelVersions.getCurrent();
        if (current.getPreviewType() != null) {
            return current.compareTo(modelVersions.getLatest()) < 0;
        }
        return false;
    }

    private void disposeModulesMarkedForRemoval() {
        Collection<Module> modulesToDispose = Projects.getModulesToDisposePostSync(this.myProject);
        if (modulesToDispose == null || modulesToDispose.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            ArrayList imlFilesToRemove = Lists.newArrayList();
            ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
            try {
                for (Module module : modulesToDispose) {
                    File imlFile = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
                    imlFilesToRemove.add(imlFile);
                    moduleModel.disposeModule(module);
                }
            }
            finally {
                Projects.setModulesToDisposePostSync(this.myProject, null);
                moduleModel.commit();
            }
            for (File imlFile : imlFilesToRemove) {
                if (!imlFile.isFile()) continue;
                FileUtil.delete((File)imlFile);
            }
        });
    }

    private void adjustModuleStructures(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "adjustModuleStructures"));
        }
        HashSet androidSdks = Sets.newHashSet();
        for (Module module : modelsProvider.getModules()) {
            ModifiableRootModel model = modelsProvider.getModifiableRootModel(module);
            PostProjectSetupTasksExecutor.adjustInterModuleDependencies(module, modelsProvider);
            Sdk sdk = model.getSdk();
            if (sdk != null) {
                if (!AndroidSdkUtils.isAndroidSdk(sdk)) continue;
                androidSdks.add(sdk);
                continue;
            }
            NativeAndroidProject nativeAndroidProject = GradleUtil.getNativeAndroidProject(module);
            if (nativeAndroidProject != null) continue;
            Sdk jdk = IdeSdks.getJdk();
            model.setSdk(jdk);
        }
        for (Sdk sdk : androidSdks) {
            PostProjectSetupTasksExecutor.refreshLibrariesIn(sdk);
        }
        Projects.removeAllModuleCompiledArtifacts(this.myProject);
    }

    private static void adjustInterModuleDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "adjustInterModuleDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "adjustInterModuleDependencies"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject == null) {
            return;
        }
        PostProjectSetupTasksExecutor.updateAarDependencies(module, modelsProvider, androidProject);
    }

    private static void updateAarDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateAarDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateAarDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateAarDependencies"));
        }
        ModifiableRootModel modifiableModel = modelsProvider.getModifiableRootModel(module);
        for (Module dependency : modifiableModel.getModuleDependencies()) {
            PostProjectSetupTasksExecutor.updateTransitiveDependencies(module, modelsProvider, androidProject, dependency);
        }
    }

    private static void updateTransitiveDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidProject androidProject, @Nullable Module dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateTransitiveDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateTransitiveDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "updateTransitiveDependencies"));
        }
        if (dependency == null) {
            return;
        }
        JavaGradleFacet javaGradleFacet = JavaGradleFacet.getInstance(dependency);
        if (javaGradleFacet != null && ((JavaGradleFacetConfiguration)javaGradleFacet.getConfiguration()).BUILDABLE) {
            return;
        }
        AndroidProject dependencyAndroidProject = GradleUtil.getAndroidProject(dependency);
        if (dependencyAndroidProject != null) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(dependency);
            if (androidModel != null) {
                DependencySet dependencies = Dependency.extractFrom(androidModel);
                for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
                    DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, libraryDependency, androidModel.getAndroidProject());
                }
                Project project = module.getProject();
                for (ModuleDependency moduleDependency : dependencies.onModules()) {
                    Module module1 = moduleDependency.getModule(project);
                    PostProjectSetupTasksExecutor.updateTransitiveDependencies(module, modelsProvider, androidProject, module1);
                }
            }
        } else {
            LibraryDependency backup = Projects.getModuleCompiledArtifact(dependency);
            if (backup != null) {
                DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, backup, androidProject);
            }
        }
    }

    private static void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "refreshLibrariesIn"));
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    private void attachSourcesToLibraries(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "attachSourcesToLibraries"));
        }
        LibraryAttachments storedLibraryAttachments = LibraryAttachments.getStoredLibraryAttachments(this.myProject);
        for (Library library : modelsProvider.getAllLibraries()) {
            HashSet sourcePaths = Sets.newHashSet();
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                sourcePaths.add(file.getUrl());
            }
            Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
            for (VirtualFile classFile : library.getFiles(OrderRootType.CLASSES)) {
                String url;
                VirtualFile sourceJar = PostProjectSetupTasksExecutor.findSourceJarForJar(classFile);
                if (sourceJar == null || sourcePaths.contains(url = AbstractDependenciesModuleCustomizer.pathToUrl(sourceJar.getPath()))) continue;
                libraryModel.addRoot(url, OrderRootType.SOURCES);
                sourcePaths.add(url);
            }
            if (storedLibraryAttachments == null) continue;
            storedLibraryAttachments.addUrlsTo(libraryModel);
        }
        if (storedLibraryAttachments != null) {
            storedLibraryAttachments.removeFromProject();
        }
    }

    @Nullable
    private static VirtualFile findSourceJarForJar(@NotNull VirtualFile jarFile) {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "findSourceJarForJar"));
        }
        File jarFilePath = FilePaths.getJarFromJarUrl(jarFile.getUrl());
        return jarFilePath != null ? GradleUtil.findSourceJarForLibrary(jarFilePath) : null;
    }

    private void findAndShowVariantConflicts() {
        boolean atLeastOneSolved;
        List<Conflict> selectionConflicts;
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        if (!(selectionConflicts = conflicts.getSelectionConflicts()).isEmpty() && (atLeastOneSolved = ConflictResolution.solveSelectionConflicts(selectionConflicts))) {
            conflicts = ConflictSet.findConflicts(this.myProject);
        }
        conflicts.showSelectionConflicts();
    }

    private void addSdkLinkIfNecessary() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        int sdkErrorCount = messages.getMessageCount("Failed to set up SDK");
        if (sdkErrorCount > 0) {
            String text = "Open Android SDK Manager and install all missing platforms.";
            Message hint = new Message("Failed to set up SDK", Message.Type.INFO, NonNavigatable.INSTANCE, text);
            messages.add(hint, new OpenAndroidSdkManagerHyperlink());
        }
    }

    private static void checkSdkToolsVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "checkSdkToolsVersion"));
        }
        if (project.isDisposed() || ourNewSdkVersionToolsInfoAlreadyShown) {
            return;
        }
        PostProjectSetupTasksExecutor.checkExpiredPreviewBuild(project);
        File androidHome = IdeSdks.getAndroidSdkPath();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " or later is required.";
            AndroidGradleNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            ourNewSdkVersionToolsInfoAlreadyShown = true;
        }
    }

    private static void checkExpiredPreviewBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "checkExpiredPreviewBuild"));
        }
        if (project.isDisposed() || ourCheckedExpiration) {
            return;
        }
        String ideVersion = ApplicationInfo.getInstance().getFullVersion();
        if (ideVersion.contains("Preview") || ideVersion.contains("Beta") || ideVersion.contains("RC")) {
            Calendar expirationDate = (Calendar)ApplicationInfo.getInstance().getBuildDate().clone();
            expirationDate.add(2, 2);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("http://tools.android.com/download/studio/", "Show Available Versions");
                String message = String.format("This preview build (%1$s) is old; please update to a newer preview or a stable version.", ideVersion);
                AndroidGradleNotification.getInstance(project).showBalloon("Old Preview Build", message, NotificationType.INFORMATION, hyperlink);
                ourNewSdkVersionToolsInfoAlreadyShown = true;
            }
        }
        ourCheckedExpiration = true;
    }

    private static void log(@NotNull AndroidGradleModelVersions versions) {
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "log"));
        }
        String message = String.format("Gradle model version: %1$s, latest version for IDE: %2$s", versions.getCurrent(), versions.getLatest());
        Logger.getInstance(PostProjectSetupTasksExecutor.class).info(message);
    }

    private void ensureValidSdks() {
        boolean checkJdkVersion = true;
        HashSet invalidAndroidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || androidFacet.getAndroidModel() == null) continue;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && !invalidAndroidSdks.contains(sdk) && (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk) || PostProjectSetupTasksExecutor.shouldRemoveAnnotationsJar(sdk))) {
                AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
                AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
                if (additionalData != null && sdkData != null) {
                    IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                    if (target == null) {
                        AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
                        StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
                        sdkHandler.getSdkManager((ProgressIndicator)logger).loadSynchronously(0L, (ProgressIndicator)logger, null, null);
                        target = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger);
                    }
                    if (target != null) {
                        SdkModificator sdkModificator = sdk.getSdkModificator();
                        sdkModificator.removeAllRoots();
                        for (OrderRoot orderRoot : AndroidSdkUtils.getLibraryRootsForTarget(target, sdk.getHomePath(), true)) {
                            sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                        }
                        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                        sdkModificator.commitChanges();
                    }
                }
                if (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk)) {
                    invalidAndroidSdks.add(sdk);
                }
            }
            AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
            assert (androidModel != null);
            if (!checkJdkVersion || ProjectJdkChecks.hasCorrectJdkVersion(module, androidModel)) continue;
            checkJdkVersion = false;
        }
        if (!invalidAndroidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidAndroidSdks);
        }
    }

    private static boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isMissingAndroidLibrary"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "shouldRemoveAnnotationsJar"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationsJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationsJar = AndroidSdkUtils.needsAnnotationsJarInClasspath(target);
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationsJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Collection<Sdk> invalidAndroidSdks) {
        if (invalidAndroidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAndroidSdks", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "reinstallMissingPlatforms"));
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        ArrayList versionsToInstall = Lists.newArrayList();
        ArrayList missingPlatforms = Lists.newArrayList();
        for (Sdk sdk : invalidAndroidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version == null) continue;
            versionsToInstall.add(version);
        }
        if (!versionsToInstall.isEmpty()) {
            String group = String.format("Failed to sync Gradle project '%1$s'", this.myProject.getName());
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join((Iterable)missingPlatforms);
            Message msg = new Message(group, Message.Type.ERROR, text);
            messages.add(msg, new InstallPlatformHyperlink(versionsToInstall.toArray(new AndroidVersion[versionsToInstall.size()])));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setMakeStepInJunitRunConfigurations(@NotNull String makeTaskName) {
        if (makeTaskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "makeTaskName", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "setMakeStepInJunitRunConfigurations"));
        }
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
        JUnitConfigurationType junitConfigurationType = JUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider beforeRunTaskProvider : taskProviders) {
            if (!makeTaskName.equals(beforeRunTaskProvider.getName())) continue;
            targetProvider = beforeRunTaskProvider;
            break;
        }
        if (targetProvider != null) {
            void var9_14;
            RunConfiguration[] junitRunConfigurations;
            for (BeforeRunTaskProvider beforeRunTaskProvider : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate((ConfigurationFactory)beforeRunTaskProvider);
                RunConfiguration runConfiguration = template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
            RunConfiguration[] runConfigurationArray = junitRunConfigurations = runManager.getConfigurations((ConfigurationType)junitConfigurationType);
            int n = runConfigurationArray.length;
            boolean bl = false;
            while (var9_14 < n) {
                RunConfiguration runConfiguration = runConfigurationArray[var9_14];
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
                ++var9_14;
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "setMakeStepInJUnitConfiguration"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "setMakeStepInJUnitConfiguration"));
        }
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
        BeforeRunTask task = targetProvider.createTask(runConfiguration);
        if (task != null) {
            task.setEnabled(true);
            runManager.setBeforeRunTasks(runConfiguration, Collections.singletonList(task), false);
        }
    }

    private void updateGradleSyncState() {
        if (!this.myUsingCachedProjectData) {
            GradleSyncState.getInstance(this.myProject).syncEnded();
            GradleProjectSyncData.save(this.myProject);
        } else {
            long lastSyncTimestamp = this.myLastSyncTimestamp;
            if (lastSyncTimestamp == -1L) {
                lastSyncTimestamp = System.currentTimeMillis();
            }
            GradleSyncState.getInstance(this.myProject).syncSkipped(lastSyncTimestamp);
        }
        this.myUsingCachedProjectData = false;
        this.myLastSyncTimestamp = -1L;
    }

    public void setGenerateSourcesAfterSync(boolean generateSourcesAfterSync, boolean cleanProjectAfterSync) {
        this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
        this.myCleanProjectAfterSync = cleanProjectAfterSync;
    }

    public void setLastSyncTimestamp(long lastSyncTimestamp) {
        this.myLastSyncTimestamp = lastSyncTimestamp;
    }

    public void setUsingCachedProjectData(boolean usingCachedProjectData) {
        this.myUsingCachedProjectData = usingCachedProjectData;
    }

    private static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Revision myVersion;

        InstallSdkToolsHyperlink(@NotNull Revision version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "<init>"));
            }
            super("install.sdk.tools", "Install latest SDK Tools");
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                Revision minBuildToolsRev = new Revision(20, 0, 0);
                requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
            }
            requested.add("tools");
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null && dialog.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }
}

