/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependencyCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsBuildTypeCollection;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavorCollection;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.android.tools.idea.gradle.structure.model.android.PsVariantCollection;
import com.android.tools.idea.gradle.structure.model.android.dependency.PsNewDependencyScopes;
import com.android.tools.idea.gradle.structure.model.repositories.search.AndroidSdkRepositories;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidModule
extends PsModule
implements PsAndroidModel {
    @NotNull
    private final AndroidGradleModel myGradleModel;
    private PsBuildTypeCollection myBuildTypeCollection;
    private PsProductFlavorCollection myProductFlavorCollection;
    private PsVariantCollection myVariantCollection;
    private PsAndroidDependencyCollection myDependencyCollection;

    public PsAndroidModule(@NotNull PsProject parent, @NotNull Module resolvedModel, @NotNull String gradlePath, @NotNull AndroidGradleModel gradleModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "<init>"));
        }
        if (resolvedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedModel", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "<init>"));
        }
        if (gradleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModel", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "<init>"));
        }
        super(parent, resolvedModel, gradlePath);
        this.myGradleModel = gradleModel;
    }

    @Override
    public boolean canDependOn(@NotNull PsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "canDependOn"));
        }
        if (module instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            return androidModule.isLibrary();
        }
        return true;
    }

    public boolean isLibrary() {
        return this.myGradleModel.isLibrary();
    }

    @Nullable
    public PsBuildType findBuildType(@NotNull String buildType) {
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "findBuildType"));
        }
        return this.getOrCreateBuildTypeCollection().findElement(buildType, PsBuildType.class);
    }

    public void forEachBuildType(@NotNull Consumer<PsBuildType> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachBuildType"));
        }
        this.getOrCreateBuildTypeCollection().forEach(consumer);
    }

    @NotNull
    private PsBuildTypeCollection getOrCreateBuildTypeCollection() {
        PsBuildTypeCollection psBuildTypeCollection = this.myBuildTypeCollection == null ? (this.myBuildTypeCollection = new PsBuildTypeCollection(this)) : this.myBuildTypeCollection;
        if (psBuildTypeCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getOrCreateBuildTypeCollection"));
        }
        return psBuildTypeCollection;
    }

    public void forEachProductFlavor(@NotNull Consumer<PsProductFlavor> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachProductFlavor"));
        }
        this.getOrCreateProductFlavorCollection().forEach(consumer);
    }

    @Nullable
    public PsProductFlavor findProductFlavor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "findProductFlavor"));
        }
        return this.getOrCreateProductFlavorCollection().findElement(name, PsProductFlavor.class);
    }

    @NotNull
    private PsProductFlavorCollection getOrCreateProductFlavorCollection() {
        PsProductFlavorCollection psProductFlavorCollection = this.myProductFlavorCollection == null ? (this.myProductFlavorCollection = new PsProductFlavorCollection(this)) : this.myProductFlavorCollection;
        if (psProductFlavorCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getOrCreateProductFlavorCollection"));
        }
        return psProductFlavorCollection;
    }

    public void forEachVariant(@NotNull Consumer<PsVariant> con) {
        if (con == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "con", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachVariant"));
        }
        this.getOrCreateVariantCollection().forEach(con);
    }

    @Nullable
    public PsVariant findVariant(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "findVariant"));
        }
        return this.getOrCreateVariantCollection().findElement(name, PsVariant.class);
    }

    @NotNull
    private PsVariantCollection getOrCreateVariantCollection() {
        PsVariantCollection psVariantCollection = this.myVariantCollection == null ? (this.myVariantCollection = new PsVariantCollection(this)) : this.myVariantCollection;
        if (psVariantCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getOrCreateVariantCollection"));
        }
        return psVariantCollection;
    }

    public void forEachDeclaredDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachDeclaredDependency"));
        }
        this.getOrCreateDependencyCollection().forEachDeclaredDependency(consumer);
    }

    public void forEachDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachDependency"));
        }
        this.getOrCreateDependencyCollection().forEach(consumer);
    }

    public void forEachModuleDependency(@NotNull Consumer<PsModuleAndroidDependency> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "forEachModuleDependency"));
        }
        this.getOrCreateDependencyCollection().forEachModuleDependency(consumer);
    }

    @Nullable
    public PsLibraryAndroidDependency findLibraryDependency(@NotNull String compactNotation) {
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "findLibraryDependency"));
        }
        return (PsLibraryAndroidDependency)this.getOrCreateDependencyCollection().findElement(compactNotation, PsLibraryAndroidDependency.class);
    }

    @Nullable
    public PsLibraryAndroidDependency findLibraryDependency(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "findLibraryDependency"));
        }
        return this.getOrCreateDependencyCollection().findElement(spec);
    }

    @NotNull
    private PsAndroidDependencyCollection getOrCreateDependencyCollection() {
        PsAndroidDependencyCollection psAndroidDependencyCollection = this.myDependencyCollection == null ? (this.myDependencyCollection = new PsAndroidDependencyCollection(this)) : this.myDependencyCollection;
        if (psAndroidDependencyCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getOrCreateDependencyCollection"));
        }
        return psAndroidDependencyCollection;
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        AndroidGradleModel androidGradleModel = this.myGradleModel;
        if (androidGradleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getGradleModel"));
        }
        return androidGradleModel;
    }

    @Override
    public Icon getIcon() {
        return this.myGradleModel.getAndroidProject().isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
    }

    @Override
    @NotNull
    public String getGradlePath() {
        String gradlePath = super.getGradlePath();
        assert (gradlePath != null);
        String string = gradlePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getGradlePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public Module getResolvedModel() {
        Module model = super.getResolvedModel();
        assert (model != null);
        Module module = model;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getResolvedModel"));
        }
        return module;
    }

    @Override
    @NotNull
    public List<ArtifactRepository> getArtifactRepositories() {
        ArrayList repositories = Lists.newArrayList();
        this.populateRepositories(repositories);
        ArtifactRepository repository = AndroidSdkRepositories.getAndroidRepository();
        if (repository != null) {
            repositories.add(repository);
        }
        if ((repository = AndroidSdkRepositories.getGoogleRepository()) != null) {
            repositories.add(repository);
        }
        ArrayList arrayList = repositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "getArtifactRepositories"));
        }
        return arrayList;
    }

    public void addLibraryDependency(@NotNull String library, @NotNull PsNewDependencyScopes newScopes, @NotNull List<String> scopesNames) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "addLibraryDependency"));
        }
        if (newScopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScopes", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "addLibraryDependency"));
        }
        if (scopesNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopesNames", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "addLibraryDependency"));
        }
        this.addLibraryDependencyToParsedModel(scopesNames, library);
        this.myDependencyCollection = null;
        PsAndroidDependencyCollection dependencyCollection = this.getOrCreateDependencyCollection();
        ArrayList targetArtifacts = Lists.newArrayList();
        this.forEachVariant(variant -> {
            if (newScopes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScopes", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "lambda$addLibraryDependency$1"));
            }
            variant.forEachArtifact(artifact -> {
                if (newScopes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScopes", "com/android/tools/idea/gradle/structure/model/android/PsAndroidModule", "lambda$null$0"));
                }
                if (newScopes.contains((PsAndroidArtifact)artifact)) {
                    targetArtifacts.add(artifact);
                }
            });
        });
        assert (!targetArtifacts.isEmpty());
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(library);
        assert (spec != null);
        PsParsedDependencies parsedDependencies = this.getParsedDependencies();
        for (PsAndroidArtifact artifact : targetArtifacts) {
            List<ArtifactDependencyModel> matchingParsedDependencies = parsedDependencies.findLibraryDependencies(spec, artifact::contains);
            for (ArtifactDependencyModel parsedDependency : matchingParsedDependencies) {
                dependencyCollection.addLibraryDependency(spec, artifact, parsedDependency);
            }
        }
        this.fireLibraryDependencyAddedEvent(spec);
        this.setModified(true);
    }
}

