/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.navigation;

import com.google.common.base.Splitter;
import com.intellij.ui.navigation.Place;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Places {
    private Places() {
    }

    @NotNull
    public static String serialize(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/navigation/Places", "serialize"));
        }
        StringBuilder buffer = new StringBuilder();
        Map paths = (Map)place.getEqualityObjects()[0];
        for (Map.Entry entry : paths.entrySet()) {
            buffer.append((String)entry.getKey()).append('=').append(entry.getValue()).append("|");
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/navigation/Places", "serialize"));
        }
        return string;
    }

    @NotNull
    public static Place deserialize(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/structure/navigation/Places", "deserialize"));
        }
        Place place = new Place();
        List entries = Splitter.on((char)'|').omitEmptyStrings().splitToList((CharSequence)text);
        for (String entry : entries) {
            List path = Splitter.on((char)'=').splitToList((CharSequence)entry);
            place.putPath((String)path.get(0), path.get(1));
        }
        Place place2 = place;
        if (place2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/navigation/Places", "deserialize"));
        }
        return place2;
    }
}

