/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class Projects {
    private static final Logger LOG = Logger.getInstance(Projects.class);
    private static final com.intellij.openapi.util.Key<String> GRADLE_VERSION = com.intellij.openapi.util.Key.create((String)"project.gradle.version");
    private static final com.intellij.openapi.util.Key<LibraryDependency> MODULE_COMPILED_ARTIFACT = com.intellij.openapi.util.Key.create((String)"module.compiled.artifact");
    private static final com.intellij.openapi.util.Key<Boolean> HAS_SYNC_ERRORS = com.intellij.openapi.util.Key.create((String)"project.has.sync.errors");
    private static final com.intellij.openapi.util.Key<Boolean> HAS_WRONG_JDK = com.intellij.openapi.util.Key.create((String)"project.has.wrong.jdk");
    private static final com.intellij.openapi.util.Key<DependencySetupErrors> DEPENDENCY_SETUP_ERRORS = com.intellij.openapi.util.Key.create((String)"project.dependency.setup.errors");
    private static final com.intellij.openapi.util.Key<Collection<Module>> MODULES_TO_DISPOSE_POST_SYNC = com.intellij.openapi.util.Key.create((String)"project.modules.to.dispose.post.sync");
    private static final com.intellij.openapi.util.Key<Boolean> SYNC_REQUESTED_DURING_BUILD = com.intellij.openapi.util.Key.create((String)"project.sync.requested.during.build");
    private static final com.intellij.openapi.util.Key<Boolean> SKIP_SYNC_ISSUE_REPORTING = com.intellij.openapi.util.Key.create((String)"project.sync.skip.sync.issue.reporting");
    private static final com.intellij.openapi.util.Key<Map<String, GradleVersion>> PLUGIN_VERSIONS_BY_MODULE = com.intellij.openapi.util.Key.create((String)"project.plugin.versions.by.module");

    private Projects() {
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        String basePath = project.getBasePath();
        assert (basePath != null);
        File file = new File(FileUtil.toCanonicalPath((String)basePath));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        return file;
    }

    public static void setGradleVersionUsed(@NotNull Project project, @Nullable String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setGradleVersionUsed"));
        }
        project.putUserData(GRADLE_VERSION, (Object)gradleVersion);
    }

    @Nullable
    public static String getGradleVersionUsed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getGradleVersionUsed"));
        }
        return (String)project.getUserData(GRADLE_VERSION);
    }

    public static void removeAllModuleCompiledArtifacts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "removeAllModuleCompiledArtifacts"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            Projects.setModuleCompiledArtifact(module, null);
        }
    }

    public static void setModuleCompiledArtifact(@NotNull Module module, @Nullable LibraryDependency compiledArtifact) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "setModuleCompiledArtifact"));
        }
        module.putUserData(MODULE_COMPILED_ARTIFACT, (Object)compiledArtifact);
    }

    @Nullable
    public static LibraryDependency getModuleCompiledArtifact(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getModuleCompiledArtifact"));
        }
        return (LibraryDependency)module.getUserData(MODULE_COMPILED_ARTIFACT);
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, boolean selectModulesToImport, boolean runPostProjectSetupTasks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        Projects.populate(project, projectInfo, Projects.getModulesToImport(project, projectInfo, selectModulesToImport), runPostProjectSetupTasks);
    }

    @NotNull
    private static Collection<DataNode<ModuleData>> getModulesToImport(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, boolean selectModulesToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(project);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.isSettingEnabled() && modules.size() > 1) {
            if (selectModulesToImport) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    Collection<DataNode<ModuleData>> collection = selection;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
                    }
                    return arrayList;
                }
            }
        }
        subview.clearSelection();
        Collection collection = modules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        return collection;
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> modulesToImport, boolean runPostProjectSetupTasks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (modulesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            if (projectInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            if (modulesToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
            messages.removeMessages("Project structure issues", "Missing dependencies between modules", "Failed to set up dependencies", "Variant selection conflicts", "Source folders generated at incorrect location");
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (projectInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (modulesToImport == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(() -> {
                        if (projectInfo == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        if (modulesToImport == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        Projects.disableExcludedModules(projectInfo, modulesToImport);
                        ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                        dataManager.importData(projectInfo, project, true);
                    });
                }
            });
            if (runPostProjectSetupTasks) {
                PostProjectSetupTasksExecutor.getInstance(project).onProjectSyncCompletion();
            }
        });
    }

    private static void disableExcludedModules(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> selectedModules) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "disableExcludedModules"));
        }
        if (selectedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/android/tools/idea/gradle/util/Projects", "disableExcludedModules"));
        }
        Collection allModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (selectedModules.size() != allModules.size()) {
            HashSet moduleToIgnore = Sets.newHashSet((Iterable)allModules);
            moduleToIgnore.removeAll(selectedModules);
            for (DataNode moduleNode : moduleToIgnore) {
                ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
            }
        }
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$executeProjectChanges$5"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "lambda$executeProjectChanges$5"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$4"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "lambda$null$4"));
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                }
            });
        }, ModalityState.defaultModalityState());
    }

    public static void setHasSyncErrors(@NotNull Project project, boolean hasSyncErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setHasSyncErrors"));
        }
        project.putUserData(HAS_SYNC_ERRORS, (Object)hasSyncErrors);
    }

    public static void setHasWrongJdk(@NotNull Project project, boolean hasWrongJdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setHasWrongJdk"));
        }
        project.putUserData(HAS_WRONG_JDK, (Object)hasWrongJdk);
    }

    public static boolean lastGradleSyncFailed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lastGradleSyncFailed"));
        }
        return !GradleSyncState.getInstance(project).isSyncInProgress() && Projects.isBuildWithGradle(project) && Projects.requiredAndroidModelMissing(project);
    }

    public static boolean hasErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasErrors"));
        }
        if (Projects.hasSyncErrors(project) || Projects.hasWrongJdk(project)) {
            return true;
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
        int errorCount = messages.getErrorCount();
        if (errorCount > 0) {
            return false;
        }
        int variantSelectionErrorCount = messages.getMessageCount("Variant selection conflicts");
        return errorCount != variantSelectionErrorCount;
    }

    private static boolean hasSyncErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasSyncErrors"));
        }
        return Projects.getBoolean(project, HAS_SYNC_ERRORS);
    }

    private static boolean hasWrongJdk(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasWrongJdk"));
        }
        return Projects.getBoolean(project, HAS_WRONG_JDK);
    }

    public static boolean requiredAndroidModelMissing(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "requiredAndroidModelMissing"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "open"));
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isDirectGradleInvocationEnabled"));
        }
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isOfflineBuildModeEnabled"));
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean requiresAndroidModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "requiresAndroidModel"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$requiresAndroidModel$6"));
            }
            if (project.isDisposed()) {
                return false;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null || !androidFacet.requiresAndroidModel()) continue;
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getAndroidModel"));
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null ? androidFacet.getAndroidModel() : null;
    }

    public static boolean isLegacyIdeaAndroidProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isLegacyIdeaAndroidProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isLegacyIdeaAndroidModule(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegacyIdeaAndroidModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isLegacyIdeaAndroidModule"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null && !facet.requiresAndroidModel();
    }

    public static void enforceExternalBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "enforceExternalBuild"));
        }
        if (Projects.requiresAndroidModel(project)) {
            // empty if block
        }
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return moduleArray;
            }
            if (modules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isProjectModule"));
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        if (moduleRootDirPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(basePath)) && !Projects.isBuildWithGradle(module);
    }

    public static boolean isBuildWithGradle(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return !project.isDisposed() && (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Boolean>(){

                    @Nullable
                    public CachedValueProvider.Result<Boolean> compute() {
                        return CachedValueProvider.Result.create((Object)Projects.calcIsBuildWithGradle(project), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
                    }
                }) != false;
            }
        });
    }

    private static boolean calcIsBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "calcIsBuildWithGradle"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildWithGradle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        return AndroidGradleFacet.getInstance(module) != null;
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectModule"));
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && Projects.isBuildWithGradle(module)) {
            File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !Projects.isBuildWithGradle(module);
    }

    @Nullable
    public static DependencySetupErrors getDependencySetupErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getDependencySetupErrors"));
        }
        return (DependencySetupErrors)project.getUserData(DEPENDENCY_SETUP_ERRORS);
    }

    public static void setDependencySetupErrors(@NotNull Project project, @Nullable DependencySetupErrors errors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setDependencySetupErrors"));
        }
        project.putUserData(DEPENDENCY_SETUP_ERRORS, (Object)errors);
    }

    @Nullable
    public static AndroidProject getAndroidModel(@NotNull VirtualFile file, @NotNull Project project) {
        AndroidGradleModel androidModel;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/util/Projects", "getAndroidModel"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getAndroidModel"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            if (Projects.requiresAndroidModel(project)) {
                VirtualFile base = project.getBaseDir();
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(base) && (module = ModuleUtilCore.findModuleForFile((VirtualFile)parent, (Project)project)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            LOG.warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getAndroidProject();
        }
        return null;
    }

    @Nullable
    public static Collection<Module> getModulesToDisposePostSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToDisposePostSync"));
        }
        return (Collection)project.getUserData(MODULES_TO_DISPOSE_POST_SYNC);
    }

    public static void setModulesToDisposePostSync(@NotNull Project project, @Nullable Collection<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setModulesToDisposePostSync"));
        }
        project.putUserData(MODULES_TO_DISPOSE_POST_SYNC, modules);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSource", "com/android/tools/idea/gradle/util/Projects", "canImportAsGradleProject"));
        }
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        return target != null && "gradle".equals(target.getExtension());
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setSyncRequestedDuringBuild"));
        }
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isSyncRequestedDuringBuild"));
        }
        return Projects.getBoolean(project, SYNC_REQUESTED_DURING_BUILD);
    }

    public static void setSkipSyncIssueReporting(@NotNull Project project, @Nullable Boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setSkipSyncIssueReporting"));
        }
        project.putUserData(SKIP_SYNC_ISSUE_REPORTING, (Object)value);
    }

    public static boolean getSkipSyncIssueReporting(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getSkipSyncIssueReporting"));
        }
        return Projects.getBoolean(project, SKIP_SYNC_ISSUE_REPORTING);
    }

    private static boolean getBoolean(@NotNull Project project, @NotNull com.intellij.openapi.util.Key<Boolean> key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        Boolean val = (Boolean)project.getUserData(key);
        return val != null && val != false;
    }

    public static void storePluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "storePluginVersionsPerModule"));
        }
        HashMap pluginVersionsPerModule = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleVersion modelVersion;
            AndroidGradleFacet facet;
            AndroidGradleModel model = AndroidGradleModel.get(module);
            if (model == null || (facet = AndroidGradleFacet.getInstance(module)) == null || (modelVersion = model.getModelVersion()) == null) continue;
            pluginVersionsPerModule.put(((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH, modelVersion);
        }
        project.putUserData(PLUGIN_VERSIONS_BY_MODULE, (Object)pluginVersionsPerModule);
    }

    @Nullable
    public static Map<String, GradleVersion> getPluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getPluginVersionsPerModule"));
        }
        return (Map)project.getUserData(PLUGIN_VERSIONS_BY_MODULE);
    }
}

