/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private final AndroidLogcatPreferences myPreferences;
    @NonNls
    private static final Pattern MESSAGE_WITH_HEADER = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/([^ ]+): (.*)$");
    @NonNls
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^\\+ (.*)$");
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);
    private int myLastHeaderLength;

    public AndroidLogcatFormatter(@NotNull AndroidLogcatPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "<init>"));
        }
        this.myLastHeaderLength = 0;
        this.myPreferences = preferences;
    }

    @NotNull
    public static String formatMessageFull(@NotNull LogCatHeader header, @NotNull String message) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        String string = AndroidLogcatFormatter.formatMessage(FULL_FORMAT, header, message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        return string;
    }

    @NotNull
    public static String formatContinuation(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatContinuation"));
        }
        String string = String.format("+ %s", message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatContinuation"));
        }
        return string;
    }

    @NotNull
    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "createCustomFormat"));
        }
        return string;
    }

    @NotNull
    static String formatMessage(@NotNull String format, @NotNull String msg) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (format.isEmpty()) {
            String string = msg;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
            }
            return string;
        }
        LogCatMessage message = AndroidLogcatFormatter.parseMessage(msg);
        String string = AndroidLogcatFormatter.formatMessage(format, message.getHeader(), message.getMessage());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        return string;
    }

    @NotNull
    public static String formatMessage(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        String ids = String.format(Locale.US, "%s-%s", header.getPid(), header.getTid());
        String tag = header.getTag().replace(' ', '\u00a0');
        String string = String.format(Locale.US, format, header.getTimestamp(), ids, header.getAppName(), Character.valueOf(header.getLogLevel().getPriorityLetter()), tag, message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        return string;
    }

    @NotNull
    public static LogCatMessage parseMessage(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "parseMessage"));
        }
        LogCatMessage result = AndroidLogcatFormatter.tryParseMessage(msg);
        if (result == null) {
            throw new IllegalArgumentException("Invalid message doesn't match expected logcat pattern: " + msg);
        }
        LogCatMessage logCatMessage = result;
        if (logCatMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "parseMessage"));
        }
        return logCatMessage;
    }

    @Nullable
    public static LogCatMessage tryParseMessage(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "tryParseMessage"));
        }
        Matcher matcher = MESSAGE_WITH_HEADER.matcher(msg);
        if (!matcher.matches()) {
            return null;
        }
        LogCatHeader header = new LogCatHeader(Log.LogLevel.getByLetter((char)matcher.group(5).charAt(0)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4), matcher.group(6), LogCatTimestamp.fromString((String)matcher.group(1)));
        String message = matcher.group(7);
        return new LogCatMessage(header, message);
    }

    @Nullable
    public static String tryParseContinuation(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "tryParseContinuation"));
        }
        Matcher matcher = CONTINUATION_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public String formatPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        String[] lines = prefix.split("\n");
        StringBuilder sb = new StringBuilder(prefix.length() + (lines.length - 1) * this.myLastHeaderLength);
        for (String line : lines) {
            sb.append(this.formatMessage(line));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String formatMessage(String msg) {
        String continuation = AndroidLogcatFormatter.tryParseContinuation(msg);
        if (continuation != null) {
            return Strings.repeat((String)" ", (int)this.myLastHeaderLength) + continuation;
        }
        LogCatMessage message = AndroidLogcatFormatter.tryParseMessage(msg);
        if (message != null) {
            String formatted = AndroidLogcatFormatter.formatMessage(this.myPreferences.LOGCAT_FORMAT_STRING, msg);
            this.myLastHeaderLength = formatted.indexOf(message.getMessage());
            return formatted;
        }
        return msg;
    }
}

