/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.editor.NlAbstractWindowManager;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesWindowManager
extends NlAbstractWindowManager {
    private static final String PROPERTIES_WINDOW_ID = "Properties";
    private NlPropertiesManager myPropertiesManager;

    public NlPropertiesWindowManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "<init>"));
        }
        super(project, fileEditorManager);
    }

    @NotNull
    public static NlPropertiesWindowManager get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "get"));
        }
        NlPropertiesWindowManager nlPropertiesWindowManager = (NlPropertiesWindowManager)((Object)project.getComponent(NlPropertiesWindowManager.class));
        if (nlPropertiesWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "get"));
        }
        return nlPropertiesWindowManager;
    }

    protected void initToolWindow() {
        this.initToolWindow(PROPERTIES_WINDOW_ID, AllIcons.Toolwindows.ToolWindowStructure);
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
            if (this.myPropertiesManager != null) {
                this.myPropertiesManager.setDesignSurface(null);
            }
        } else {
            if (this.myPropertiesManager == null) {
                this.myPropertiesManager = new NlPropertiesManager(this.myProject, null);
                this.createWindowContent(this.myPropertiesManager.getConfigurationPanel(), this.myPropertiesManager.getConfigurationPanel(), this.myPropertiesManager.getActions());
            }
            this.myPropertiesManager.setDesignSurface(NlPropertiesWindowManager.getDesignSurface(designer));
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    public boolean isActivePropertiesManager(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "isActivePropertiesManager"));
        }
        if (propertiesManager == this.myPropertiesManager) {
            return propertiesManager.getDesignSurface() != null;
        }
        return this.myPropertiesManager == null || this.myPropertiesManager.getDesignSurface() == null;
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    public String getVisibilityKeyName(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "getVisibilityKeyName"));
        }
        return this.getComponentName() + "-" + designer.getClass().getSimpleName();
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "createContent"));
        }
        if (!(designer instanceof NlEditorPanel)) {
            return null;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String value = propertiesComponent.getValue(this.myEditorModeKey);
        ToolWindowAnchor anchor = value == null ? this.getAnchor() : (value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value));
        NlPropertiesManager properties = new NlPropertiesManager(this.myProject, NlPropertiesWindowManager.getDesignSurface(designer));
        return new LightToolWindow((LightToolWindowContent)properties, PROPERTIES_WINDOW_ID, AllIcons.Toolwindows.ToolWindowStructure, properties.getConfigurationPanel(), properties.getConfigurationPanel(), designer.getContentSplitter(), anchor, (LightToolWindowManager)this, this.myProject, propertiesComponent, this.getVisibilityKeyName(designer), 320, properties.getActions());
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("NlPropertiesWindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPropertiesWindowManager", "getComponentName"));
        }
        return "NlPropertiesWindowManager";
    }
}

