/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.ui;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppBarConfigurationDialog
extends JDialog {
    private static final String TAG_COORDINATOR_LAYOUT = "<android.support.design.widget.CoordinatorLayout\n%3$s%4$s    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\">\n  <android.support.design.widget.AppBarLayout\n      %1$s:id=\"@+id/appbar\"\n%4$s      %1$s:layout_height=\"192dp\"\n      %1$s:layout_width=\"match_parent\">\n    <android.support.design.widget.CollapsingToolbarLayout\n        %1$s:layout_width=\"match_parent\"\n        %1$s:layout_height=\"match_parent\"\n        %2$s:toolbarId=\"@+id/toolbar\"\n        %2$s:layout_scrollFlags=\"%5$s\"\n%6$s        %2$s:contentScrim=\"?attr/colorPrimary\">\n%7$s      <android.support.v7.widget.Toolbar\n          %1$s:id=\"@+id/toolbar\"\n          %1$s:layout_height=\"?attr/actionBarSize\"\n          %1$s:layout_width=\"match_parent\">\n      </android.support.v7.widget.Toolbar>\n    </android.support.design.widget.CollapsingToolbarLayout>\n  </android.support.design.widget.AppBarLayout>\n  <android.support.v4.widget.NestedScrollView\n      %1$s:layout_width=\"match_parent\"\n      %1$s:layout_height=\"match_parent\"\n%8$s%9$s      %2$s:layout_behavior=\"android.support.design.widget.AppBarLayout$ScrollingViewBehavior\">\n%10$s  </android.support.v4.widget.NestedScrollView>\n%11$s</android.support.design.widget.CoordinatorLayout>\n";
    private static final String TAG_COORDINATOR_WITH_TABS_LAYOUT = "<android.support.design.widget.CoordinatorLayout\n%3$s    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\">\n  <android.support.design.widget.AppBarLayout\n      %1$s:id=\"@+id/appbar\"\n      %1$s:layout_height=\"wrap_content\"\n      %1$s:layout_width=\"match_parent\">\n    <android.support.v7.widget.Toolbar\n        %1$s:layout_height=\"?attr/actionBarSize\"\n        %1$s:layout_width=\"match_parent\"\n        %2$s:layout_scrollFlags=\"scroll|enterAlways\">\n    </android.support.v7.widget.Toolbar>\n    <android.support.design.widget.TabLayout\n        %1$s:id=\"@+id/tabs\"\n        %1$s:layout_width=\"match_parent\"\n        %1$s:layout_height=\"wrap_content\"\n%4$s        %2$s:tabMode=\"scrollable\">\n%5$s    </android.support.design.widget.TabLayout>\n  </android.support.design.widget.AppBarLayout>\n  <android.support.v4.widget.NestedScrollView\n      %1$s:layout_width=\"match_parent\"\n      %1$s:layout_height=\"match_parent\"\n%6$s      %2$s:layout_behavior=\"android.support.design.widget.AppBarLayout$ScrollingViewBehavior\">\n    %7$s\n  </android.support.v4.widget.NestedScrollView>\n%8$s</android.support.design.widget.CoordinatorLayout>\n";
    private static final String TAG_FLOATING_ACTION_BUTTON = "<android.support.design.widget.FloatingActionButton\n    %1$s:layout_height=\"wrap_content\"\n    %1$s:layout_width=\"wrap_content\"\n    %2$s:layout_anchor=\"@id/appbar\"\n    %2$s:layout_anchorGravity=\"bottom|right|end\"\n    %1$s:src=\"%3$s\"\n    %1$s:layout_marginRight=\"16dp\"\n    %1$s:clickable=\"true\"\n    %2$s:fabSize=\"mini\"/>\n";
    private static final String TAG_IMAGE_VIEW = "<ImageView\n    %1$s:id=\"@+id/app_bar_image\"\n    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\"\n%2$s    %1$s:src=\"%3$s\"\n    %1$s:scaleType=\"centerCrop\"/>\n";
    private static final String TAG_TEXT_VIEW = "<TextView\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:text=\"%1$s\"\n    android:padding=\"16dp\"/>";
    private static final String TAG_TAB_ITEM = "<android.support.design.widget.TabItem\n    %1$s:layout_height=\"wrap_content\"\n    %1$s:layout_width=\"wrap_content\"\n    %1$s:text=\"%2$s\"/>\n";
    private static final String DIALOG_TITLE = "Configure App Bar";
    private static final String DEFAULT_BACKGROUND_IMAGE = "@android:drawable/sym_def_app_icon";
    private static final String DEFAULT_FAB_IMAGE = "@android:drawable/ic_input_add";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String DUMMY_TEXT = "This text is present to test the Application Bar. ";
    private static final int DUMMY_REPETITION = 200;
    private static final String PREVIEW_HEADER = "Preview:";
    private static final String RENDER_ERROR = "An error happened during rendering...";
    private static final String OVERLAP_TOP_FORMAT = "%1$s:behavior_overlapTop=\"%2$s\"";
    private static final double FUDGE_FACTOR = 0.95;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 60;
    private static final int START_WIDTH = 225;
    private static final int START_HEIGHT = 400;
    private final ViewEditor myEditor;
    private JPanel myContentPane;
    private JButton myButtonOK;
    private JButton myButtonCancel;
    private JBLabel myPreview;
    private JCheckBox myCollapsing;
    private JCheckBox myShowBackgroundImage;
    private JCheckBox myFloatingActionButton;
    private JCheckBox myFitStatusBar;
    private JCheckBox myContentOverlap;
    private JCheckBox myWithTabs;
    private JButton myBackgroundImageSelector;
    private JButton myFloatingActionButtonImageSelector;
    private JPanel myPreviewPanel;
    private JBLabel myCollapsedPreview;
    private JBLabel myExpandedPreview;
    private Future<?> myCollapsedPreviewFuture;
    private Future<?> myExpandedPreviewFuture;
    private JBLabel myExpandedLabel;
    private JBLabel myCollapsedLabel;
    private JCheckBox myParallax;
    private JTextField myContentOverlapAmount;
    private JSpinner myTabCount;
    private boolean myWasAccepted;
    private BufferedImage myExpandedImage;
    private BufferedImage myCollapsedImage;
    private String myBackgroundImage;
    private String myFloatingActionButtonImage;

    public AppBarConfigurationDialog(@NotNull ViewEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "<init>"));
        }
        this.myEditor = editor;
        this.$$$setupUI$$$();
        this.setTitle(DIALOG_TITLE);
        this.setContentPane(this.myContentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.myButtonOK);
        this.myBackgroundImage = DEFAULT_BACKGROUND_IMAGE;
        this.myFloatingActionButtonImage = DEFAULT_FAB_IMAGE;
        ActionListener updatePreviewListener = event -> {
            this.updateControls();
            this.generatePreviews();
        };
        this.myWithTabs.addActionListener(updatePreviewListener);
        this.myTabCount.setValue(3);
        this.myCollapsing.addActionListener(updatePreviewListener);
        this.myShowBackgroundImage.addActionListener(updatePreviewListener);
        this.myFloatingActionButton.addActionListener(updatePreviewListener);
        this.myFitStatusBar.addActionListener(updatePreviewListener);
        this.myParallax.addActionListener(updatePreviewListener);
        this.myContentOverlap.addActionListener(updatePreviewListener);
        this.myContentOverlapAmount.addActionListener(updatePreviewListener);
        ((GridLayoutManager)this.myPreviewPanel.getLayout()).setRowStretch(0, 2);
        this.myTabCount.addChangeListener(event -> this.generatePreviews());
        ActionListener actionListener = event -> {
            if (event.getSource() == this.myBackgroundImageSelector) {
                String src = this.myEditor.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myBackgroundImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myFloatingActionButtonImageSelector) {
                String src = this.myEditor.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myFloatingActionButtonImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myButtonOK) {
                this.onOK();
            } else if (event.getSource() == this.myButtonCancel || event.getSource() == this.myContentPane) {
                this.onCancel();
            }
        };
        this.myBackgroundImageSelector.addActionListener(actionListener);
        this.myFloatingActionButtonImageSelector.addActionListener(actionListener);
        this.myButtonOK.addActionListener(actionListener);
        this.myButtonCancel.addActionListener(actionListener);
        this.myContentPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.myPreviewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AppBarConfigurationDialog.this.updatePreviewImages();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppBarConfigurationDialog.this.onCancel();
            }
        });
    }

    public boolean open(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "open"));
        }
        this.myCollapsedPreview.setMinimumSize(new Dimension(225, 400));
        this.myExpandedPreview.setMinimumSize(new Dimension(225, 400));
        this.pack();
        this.myCollapsedPreview.setMinimumSize(null);
        this.myExpandedPreview.setMinimumSize(null);
        Dimension size = this.getSize();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        this.setLocation(screen.x + (screen.width - size.width) / 2, screen.y + (screen.height - size.height) / 2);
        this.updateControls();
        this.myButtonOK.requestFocus();
        this.generatePreviews();
        this.setVisible(true);
        if (this.myWasAccepted) {
            Project project = file.getProject();
            WriteCommandAction action = new WriteCommandAction(project, DIALOG_TITLE, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog$3", "run"));
                    }
                    AppBarConfigurationDialog.this.applyChanges(file);
                }
            };
            action.execute();
        }
        return this.myWasAccepted;
    }

    private void onOK() {
        this.myWasAccepted = true;
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void updateControls() {
        this.myTabCount.setEnabled(this.myWithTabs.isSelected());
        this.myShowBackgroundImage.setEnabled(!this.myWithTabs.isSelected());
        this.myBackgroundImageSelector.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myParallax.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlap.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlapAmount.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected() && this.myContentOverlap.isSelected());
        this.myFloatingActionButtonImageSelector.setEnabled(this.myFloatingActionButton.isSelected());
    }

    private void generatePreviews() {
        PsiFile expandedFile = this.generateXml(false);
        PsiFile collapsedFile = this.generateXml(true);
        this.myExpandedPreviewFuture = AppBarConfigurationDialog.cancel(this.myExpandedPreviewFuture);
        this.myCollapsedPreviewFuture = AppBarConfigurationDialog.cancel(this.myCollapsedPreviewFuture);
        Application application = ApplicationManager.getApplication();
        this.myExpandedPreviewFuture = application.executeOnPooledThread(() -> this.updateExpandedImage(expandedFile));
        this.myCollapsedPreviewFuture = application.executeOnPooledThread(() -> this.updateCollapsedImage(collapsedFile));
    }

    @Nullable
    private static Future<?> cancel(@Nullable Future<?> future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    private PsiFile generateXml(boolean collapsed) {
        StringBuilder text = new StringBuilder(200 * DUMMY_TEXT.length());
        for (int i = 0; i < 200; ++i) {
            text.append(DUMMY_TEXT);
        }
        String content = String.format(TAG_TEXT_VIEW, text.toString());
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(null, collapsed);
        String xml = this.getXml(content, collapsed, namespaces);
        Project project = this.myEditor.getModel().getProject();
        return PsiFileFactory.getInstance((Project)project).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
    }

    private void updatePreviewImages() {
        if (this.myCollapsedImage != null) {
            this.updatePreviewImage(this.myCollapsedImage, this.myCollapsedPreview);
        }
        if (this.myExpandedImage != null) {
            this.updatePreviewImage(this.myExpandedImage, this.myExpandedPreview);
        }
    }

    private void applyChanges(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "applyChanges"));
        }
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(file.getRootTag(), false);
        String xml = this.getXml(AppBarConfigurationDialog.getDesignContent(file), false, namespaces);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        XmlTag tag = elementFactory.createTagFromText((CharSequence)xml);
        if (file.getRootTag() == null) {
            file.add((PsiElement)tag);
        } else {
            file.getRootTag().replace((PsiElement)tag);
        }
    }

    @NotNull
    private String getXml(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXml"));
        }
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXml"));
        }
        String string = this.myWithTabs.isSelected() ? this.getXmlWithTabs(content, collapsed, namespaces) : this.getXmlWithoutTabs(content, collapsed, namespaces);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXml"));
        }
        return string;
    }

    @NotNull
    private String getXmlWithoutTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithoutTabs"));
        }
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithoutTabs"));
        }
        String string = String.format(TAG_COORDINATOR_LAYOUT, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationDialog.formatNamespaces(namespaces), this.getFitsSystemWindows(namespaces), this.getToolbarScrollBehavior(), this.getInterpolator(namespaces), this.getBackgroundImage(namespaces), this.getBehaviorOverlapTop(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithoutTabs"));
        }
        return string;
    }

    @NotNull
    private String getXmlWithTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithTabs"));
        }
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithTabs"));
        }
        String string = String.format(TAG_COORDINATOR_WITH_TABS_LAYOUT, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationDialog.formatNamespaces(namespaces), this.getTabLayoutScroll(namespaces), this.getTabItems(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getXmlWithTabs"));
        }
        return string;
    }

    @NotNull
    private String getFitsSystemWindows(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFitsSystemWindows"));
        }
        if (!this.myShowBackgroundImage.isSelected() || !this.myFitStatusBar.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFitsSystemWindows"));
            }
            return "";
        }
        String string = String.format("    %1$s:fitsSystemWindows=\"true\"\n", namespaces.get("http://schemas.android.com/apk/res/android"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFitsSystemWindows"));
        }
        return string;
    }

    @NotNull
    private String getToolbarScrollBehavior() {
        String string = this.myCollapsing.isSelected() ? "scroll|enterAlways|enterAlwaysCollapsed" : "scroll|exitUntilCollapsed";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getToolbarScrollBehavior"));
        }
        return string;
    }

    @NotNull
    private String getTabLayoutScroll(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getTabLayoutScroll"));
        }
        if (!this.myCollapsing.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getTabLayoutScroll"));
            }
            return "";
        }
        String string = String.format("        %1$s:layout_scrollFlags=\"scroll|enterAlways\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getTabLayoutScroll"));
        }
        return string;
    }

    @NotNull
    private String getTabItems(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getTabItems"));
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < (Integer)this.myTabCount.getValue(); ++index) {
            builder.append(String.format(TAG_TAB_ITEM, namespaces.get("http://schemas.android.com/apk/res/android"), "Tab" + (index + 1)));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getTabItems"));
        }
        return string;
    }

    @NotNull
    private String getInterpolator(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getInterpolator"));
        }
        if (!this.myShowBackgroundImage.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getInterpolator"));
            }
            return "";
        }
        String string = String.format("        %2$s:layout_scrollInterpolator=\"@%1$s:anim/decelerate_interpolator\"\n", namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getInterpolator"));
        }
        return string;
    }

    @NotNull
    private String getBackgroundImage(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImage"));
        }
        if (!this.myShowBackgroundImage.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImage"));
            }
            return "";
        }
        String string = String.format(TAG_IMAGE_VIEW, namespaces.get("http://schemas.android.com/apk/res/android"), this.getBackgroundImageCollapseMode(namespaces), this.myBackgroundImage);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImage"));
        }
        return string;
    }

    @NotNull
    private String getBehaviorOverlapTop(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBehaviorOverlapTop"));
        }
        if (!this.myContentOverlap.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBehaviorOverlapTop"));
            }
            return "";
        }
        String string = String.format(OVERLAP_TOP_FORMAT, namespaces.get("http://schemas.android.com/apk/res-auto"), this.myContentOverlapAmount.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBehaviorOverlapTop"));
        }
        return string;
    }

    @NotNull
    private static String getScrollPos(boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getScrollPos"));
        }
        if (!collapsed) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getScrollPos"));
            }
            return "";
        }
        String string = String.format("        %1$s:scrollY=\"830px\"\n", namespaces.get("http://schemas.android.com/tools"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getScrollPos"));
        }
        return string;
    }

    @NotNull
    private String getBackgroundImageCollapseMode(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImageCollapseMode"));
        }
        if (this.myParallax.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImageCollapseMode"));
            }
            return "";
        }
        String string = String.format("    %1$s:layout_collapseMode=\"parallax\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getBackgroundImageCollapseMode"));
        }
        return string;
    }

    @NotNull
    private String getFloatingActionButton(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFloatingActionButton"));
        }
        if (!this.myFloatingActionButton.isSelected()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFloatingActionButton"));
            }
            return "";
        }
        String string = String.format(TAG_FLOATING_ACTION_BUTTON, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), this.myFloatingActionButtonImage);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getFloatingActionButton"));
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getNameSpaces(@Nullable XmlTag root, boolean includeToolsNamespace) {
        HashMap<String, String> reverse = new HashMap<String, String>();
        if (root != null) {
            Map namespaces = root.getLocalNamespaceDeclarations();
            for (String prefix : namespaces.keySet()) {
                reverse.put((String)namespaces.get(prefix), prefix);
            }
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res/android")) {
            reverse.put("http://schemas.android.com/apk/res/android", "android");
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res-auto")) {
            reverse.put("http://schemas.android.com/apk/res-auto", "app");
        }
        if (includeToolsNamespace && !reverse.containsKey("http://schemas.android.com/tools")) {
            reverse.put("http://schemas.android.com/tools", "tools");
        }
        HashMap<String, String> hashMap = reverse;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getNameSpaces"));
        }
        return hashMap;
    }

    @NotNull
    private static String formatNamespaces(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "formatNamespaces"));
        }
        StringBuilder result = new StringBuilder();
        for (String ns : namespaces.keySet()) {
            String prefix = namespaces.get(ns);
            result.append(String.format("    xmlns:%1$s=\"%2$s\"\n", prefix, ns));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "formatNamespaces"));
        }
        return string;
    }

    @NotNull
    private static String getDesignContent(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getDesignContent"));
        }
        XmlTag content = file.getRootTag();
        if (content != null && content.getName().equals("android.support.design.widget.CoordinatorLayout")) {
            XmlTag root = content;
            content = null;
            XmlTag[] xmlTagArray = root.getSubTags();
            int n = xmlTagArray.length;
            for (int i = 0; i < n; ++i) {
                XmlTag tag = xmlTagArray[i];
                if (tag.getName().equals("android.support.design.widget.AppBarLayout") || tag.getName().equals("android.support.design.widget.FloatingActionButton")) continue;
                if (tag.getName().equals("android.support.v4.widget.NestedScrollView")) {
                    content = tag.getSubTags().length > 0 ? tag.getSubTags()[0] : null;
                    break;
                }
                content = tag;
                break;
            }
        }
        if (content == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getDesignContent"));
            }
            return "";
        }
        for (XmlAttribute attribute : content.getAttributes()) {
            if (attribute == null || !attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
        String string = content.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "getDesignContent"));
        }
        return string;
    }

    private void updateCollapsedImage(@NotNull PsiFile collapsedXmlFile) {
        if (collapsedXmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collapsedXmlFile", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "updateCollapsedImage"));
        }
        BufferedImage image = this.updateImage(collapsedXmlFile, this.myCollapsedPreview);
        if (image != null) {
            this.myCollapsedImage = image;
        }
    }

    private void updateExpandedImage(@NotNull PsiFile expandedXmlFile) {
        if (expandedXmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandedXmlFile", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "updateExpandedImage"));
        }
        BufferedImage image = this.updateImage(expandedXmlFile, this.myExpandedPreview);
        if (image != null) {
            this.myExpandedImage = image;
        }
    }

    @Nullable
    private BufferedImage updateImage(@NotNull PsiFile xmlFile, @NotNull JBLabel preview) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "updateImage"));
        }
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "updateImage"));
        }
        BufferedImage image = null;
        try {
            image = this.renderImage(xmlFile);
            if (image == null) {
                return null;
            }
        }
        catch (RuntimeInterruptedException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            AppBarConfigurationDialog.getLogger().error((Throwable)ex);
        }
        BufferedImage finalImage = image;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (preview == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "lambda$updateImage$5"));
            }
            this.updatePreviewImage(finalImage, preview);
        });
        return image;
    }

    private BufferedImage renderImage(@NotNull PsiFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "renderImage"));
        }
        AndroidFacet facet = this.myEditor.getModel().getFacet();
        RenderService renderService = RenderService.get(facet);
        RenderLogger logger = renderService.createLogger();
        RenderTask task = renderService.createTask(xmlFile, this.myEditor.getConfiguration(), logger, null);
        RenderResult result = null;
        if (task != null) {
            task.setRenderingMode(SessionParams.RenderingMode.NORMAL);
            task.setFolderType(ResourceFolderType.LAYOUT);
            result = task.render();
            task.dispose();
        }
        BufferedImage image = result != null ? result.getRenderedImage() : null;
        return image != null && image.getHeight() >= 60 && image.getWidth() >= 40 ? image : null;
    }

    private void updatePreviewImage(@Nullable BufferedImage image, @NotNull JBLabel view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog", "updatePreviewImage"));
        }
        if (image == null) {
            view.setIcon(null);
            this.myPreview.setText(RENDER_ERROR);
            return;
        }
        double width = (double)this.myPreviewPanel.getWidth() / 2.0;
        double height = this.myPreviewPanel.getHeight() - this.myPreview.getHeight() - Math.max(this.myExpandedLabel.getHeight(), this.myCollapsedLabel.getHeight());
        if (width < 40.0 || height < 60.0) {
            view.setIcon(null);
        }
        double scale = Math.min(width / (double)image.getWidth(), height / (double)image.getHeight()) * 0.95;
        image = ImageUtils.scale(image, scale, scale);
        view.setIcon((Icon)new ImageIcon(image));
        this.myPreview.setText(PREVIEW_HEADER);
    }

    private static Logger getLogger() {
        return Logger.getInstance(AppBarConfigurationDialog.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel;
        JSpinner jSpinner;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myButtonOK = jButton4 = new JButton();
        jButton4.setText("OK");
        jPanel4.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonCancel = jButton3 = new JButton();
        jButton3.setText("Cancel");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel5.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(16, 8, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCollapsing = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Collapsing Toolbar");
        jPanel7.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myShowBackgroundImage = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Image Background");
        jPanel7.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFloatingActionButton = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Floating Action Button");
        jPanel7.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWithTabs = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("With Tabs");
        jPanel7.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 12, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myFitStatusBar = jCheckBox3 = new JCheckBox();
        jCheckBox3.setActionCommand("");
        jCheckBox3.setText("Fit Status Bar on Image");
        jCheckBox3.setToolTipText("Makes the toolbar with the image appear below the status bar. The status bar can be set to draw transparent by setting the theme value for: statusBarColor to color/transparent.");
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myParallax = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Parallax Scrolling");
        jCheckBox2.setToolTipText("Makes the image scroll slower than the TabBar (only visible at runtime).");
        jPanel8.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundImageSelector = jButton2 = new JButton();
        Font font = jButton2.getFont();
        if (font != null) {
            jButton2.setFont(new Font(font.getName(), font.getStyle(), 8));
        }
        jButton2.setText("...");
        jPanel7.add((Component)jButton2, new GridConstraints(1, 1, 1, 2, 4, 0, 3, 0, null, null, null));
        this.myFloatingActionButtonImageSelector = jButton = new JButton();
        Font font2 = jButton.getFont();
        if (font2 != null) {
            jButton.setFont(new Font(font2.getName(), font2.getStyle(), 8));
        }
        jButton.setText("...");
        jPanel7.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myContentOverlap = jCheckBox = new JCheckBox();
        jCheckBox.setText("Overlapping content");
        jPanel7.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myContentOverlapAmount = jTextField = new JTextField();
        jTextField.setText("32dp");
        jPanel7.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 1, 0, null, new Dimension(60, -1), null));
        this.myTabCount = jSpinner = new JSpinner();
        jPanel7.add((Component)jSpinner, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        this.myPreview = jBLabel5 = new JBLabel();
        jBLabel5.setText(PREVIEW_HEADER);
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 2, 2, 0, 7, 7, null, null, null));
        this.myExpandedLabel = jBLabel4 = new JBLabel();
        jBLabel4.setAlignmentX(0.0f);
        jBLabel4.setText("Expanded");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myCollapsedLabel = jBLabel3 = new JBLabel();
        jBLabel3.setAlignmentX(0.0f);
        jBLabel3.setText("Collapsed");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myExpandedPreview = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 7, 7, null, null, null));
        this.myCollapsedPreview = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 7, 7, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

