/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.api.StructurePaneComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureTreeDecorator {
    private StructureTreeDecorator() {
    }

    static void decorate(@NotNull ColoredTextContainer container, @NotNull NlComponent component) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "decorate"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "decorate"));
        }
        StructureTreeDecorator.append(container, component);
        container.setIcon(StructureTreeDecorator.getViewHandler(component).getIcon(component));
    }

    @NotNull
    static String toString(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "toString"));
        }
        StringBuilderContainer container = new StringBuilderContainer();
        StructureTreeDecorator.append(container, component);
        String string = ((Object)container).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "toString"));
        }
        return string;
    }

    private static void append(@NotNull ColoredTextContainer container, @NotNull NlComponent component) {
        String attributes;
        StructurePaneComponentHandler handler;
        String title;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "append"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "append"));
        }
        String id = LintUtils.stripIdPrefix((String)component.getId());
        if (!id.isEmpty()) {
            container.append(id, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (!StringUtil.startsWithIgnoreCase((String)id, (String)(title = (handler = StructureTreeDecorator.getViewHandler(component)).getTitle(component)))) {
            container.append(id.isEmpty() ? title : " (" + title + ')', SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (!(attributes = handler.getTitleAttributes(component)).isEmpty()) {
            container.append(' ' + attributes, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @NotNull
    private static StructurePaneComponentHandler getViewHandler(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "getViewHandler"));
        }
        ViewHandler handler = component.getViewHandler();
        ViewHandler viewHandler = handler == null ? ViewHandlerManager.NONE : handler;
        if (viewHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator", "getViewHandler"));
        }
        return viewHandler;
    }

    private static final class StringBuilderContainer
    implements ColoredTextContainer {
        private final StringBuilder myBuilder = new StringBuilder();

        private StringBuilderContainer() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "append"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "append"));
            }
            this.myBuilder.append(fragment);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull Object tag) {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "append"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "append"));
            }
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "append"));
            }
            throw new UnsupportedOperationException();
        }

        public void setIcon(@Nullable Icon icon) {
            throw new UnsupportedOperationException();
        }

        public void setToolTipText(@Nullable String text) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String toString() {
            String string = this.myBuilder.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/StructureTreeDecorator$StringBuilderContainer", "toString"));
            }
            return string;
        }
    }
}

