/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.HashMap;
import icons.MavenIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryBean;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryDescription {
    protected static final MavenRepositoryInfo mavenCentralRepository = new MavenRepositoryInfo("central", "Maven Central repository", "http://repo1.maven.org/maven2");
    protected static final MavenRepositoryInfo jbossCommunityRepository = new MavenRepositoryInfo("jboss.community", "JBoss Community repository", "http://repository.jboss.org/nexus");
    private static final List<MavenRepositoryInfo> defaultRemoteRepositories = Arrays.asList(mavenCentralRepository, jbossCommunityRepository);
    private static Map<String, RepositoryLibraryDescription> registeredLibraries;
    private final String groupId;
    private final String artifactId;
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId, String artifactId, String libraryName) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.libraryName = libraryName;
    }

    @NotNull
    public static synchronized RepositoryLibraryDescription findDescription(@NotNull String groupId, @NotNull String artifactId) {
        String id;
        RepositoryLibraryDescription description;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        if (registeredLibraries == null) {
            registeredLibraries = new HashMap();
            for (RepositoryLibraryBean bean : (RepositoryLibraryBean[])RepositoryLibraryBean.EP_NAME.getExtensions()) {
                String id2 = bean.groupId + ":" + bean.artifactId;
                registeredLibraries.put(id2, new RepositoryLibraryDescription(bean.groupId, bean.artifactId, bean.name));
            }
        }
        if ((description = registeredLibraries.get(id = groupId + ":" + artifactId)) != null) {
            RepositoryLibraryDescription repositoryLibraryDescription = description;
            if (repositoryLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
            }
            return repositoryLibraryDescription;
        }
        RepositoryLibraryDescription repositoryLibraryDescription = new RepositoryLibraryDescription(groupId, artifactId, id);
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public static synchronized RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getArtifactId"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.libraryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = MavenIcons.MavenLogo;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    @NotNull
    public List<MavenRepositoryInfo> getRemoteRepositories() {
        List<MavenRepositoryInfo> list = defaultRemoteRepositories;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getRemoteRepositories"));
        }
        return list;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE");
    }

    public String getDisplayName(String version) {
        if (version.equals("LATEST")) {
            version = "Latest";
        }
        if (version.equals("RELEASE")) {
            version = "Release";
        }
        return this.getDisplayName() + ":" + version;
    }

    public String getMavenCoordinates(String version) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version;
    }
}

