/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.ws.utils.CommonWsUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    @NonNls
    public static final String CLASS_RESOURCE_STRING = "*?.class";
    @NonNls
    private static final String SOAP_ADDRESS = "soap:address";
    private static final Logger LOG = Logger.getInstance((String)("#" + FileUtils.class.getName()));

    private FileUtils() {
    }

    public static File saveStreamContentAsFile(String fullFileName, InputStream stream) throws IOException {
        int read;
        fullFileName = FileUtils.findFreeFileName(fullFileName);
        FileOutputStream ostream = new FileOutputStream(fullFileName);
        byte[] buf = new byte[8192];
        while ((read = stream.read(buf, 0, buf.length)) != -1) {
            ((OutputStream)ostream).write(buf, 0, read);
        }
        ostream.flush();
        ((OutputStream)ostream).close();
        return new File(fullFileName);
    }

    private static String findFreeFileName(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return filename;
        }
        int dot = filename.lastIndexOf(46);
        String name = filename.substring(0, dot);
        String ext = filename.substring(dot);
        int num = 0;
        while ((f = new File(name + ++num + ext)).exists()) {
        }
        return name + num + ext;
    }

    public static File createTempDir(String prefix) throws IOException {
        File tempDir = FileUtil.createTempFile((String)prefix, (String)"");
        tempDir.delete();
        tempDir.mkdir();
        tempDir.deleteOnExit();
        return tempDir;
    }

    @Nullable
    public static VirtualFile findWebXml(Module currentModule, WebFacet webFacet) {
        VirtualFile virtualFile = FileUtils.findWebInf(currentModule, webFacet);
        return virtualFile != null ? virtualFile.findChild("web.xml") : null;
    }

    public static void addClassAsCompilerResource(Project project) {
        if (!CompilerConfiguration.getInstance((Project)project).isResourceFile("A.class")) {
            try {
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(CLASS_RESOURCE_STRING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveText(VirtualFile virtualFile, String text) throws IOException {
        VfsUtil.saveText((VirtualFile)virtualFile, (String)text);
    }

    public static void copyWsdlWithReplacementOfSoapAddress(File generatedFileName, File _file, @NonNls String webServiceUrl) throws IOException {
        FileUtils.copyWsdlWithReplacementOfSoapAddress(generatedFileName, _file, "REPLACE_WITH_ACTUAL_URL", webServiceUrl);
    }

    public static void copyWsdlWithReplacementOfSoapAddress(final File generatedFileName, File _file, final @NonNls String existingPattern, final @NonNls String replacementUrl) throws IOException {
        final boolean generatedAndDestinationFileAreTheSame = _file.equals(generatedFileName);
        final File file = generatedAndDestinationFileAreTheSame ? FileUtil.createTempFile((String)generatedFileName.getName(), (String)".tmp") : _file;
        CommonWsUtils.scanFile(generatedFileName, new CommonWsUtils.FileProcessor(){
            final OutputStream out;
            final String ls;
            {
                this.out = new BufferedOutputStream(new FileOutputStream(file));
                this.ls = System.getProperty("line.separator");
            }

            @Override
            public void fileScanningEnded() throws IOException {
                this.out.close();
                if (generatedAndDestinationFileAreTheSame) {
                    FileUtil.delete((File)generatedFileName);
                    FileUtil.rename((File)file, (File)generatedFileName);
                }
            }

            @Override
            public boolean process(String s) throws IOException {
                int soapAddressIndex = s.indexOf(FileUtils.SOAP_ADDRESS);
                if (soapAddressIndex != -1) {
                    String tagPrefix = s.substring(s.lastIndexOf(60, soapAddressIndex) + 1, soapAddressIndex);
                    Pattern p = Pattern.compile("(.*)(<" + tagPrefix + "soap:address location=\"" + existingPattern + "\"/>)(.*)");
                    Matcher matcher = p.matcher(s);
                    if (matcher.matches()) {
                        s = matcher.group(1) + "<" + tagPrefix + "soap:address location=\"" + replacementUrl + "\"/>" + matcher.group(3);
                    }
                }
                this.out.write((s + this.ls).getBytes());
                return true;
            }
        });
    }

    public static String removeFileProtocolPrefixIfPresent(String u) {
        u = StringUtil.trimStart((String)u, (String)"file:");
        return u;
    }

    @Nullable
    public static VirtualFile findWebInf(Module currentModule) {
        return FileUtils.findWebInf(currentModule, (WebFacet)FacetManager.getInstance((Module)currentModule).getFacetByType(WebFacet.ID));
    }

    @Nullable
    public static VirtualFile findWebInf(Module currentModule, WebFacet webFacet) {
        WebDirectoryElement element = CommonWsUtils.findWebDirectoryByElement("/WEB-INF", webFacet);
        return element != null ? element.getVirtualFile() : null;
    }
}

