/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterceptMethodConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = InterceptMethodConverter.createReferences(genericDomValue, element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element) {
        PsiClass psiClass;
        String stringValue = genericDomValue.getStringValue();
        if (stringValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        HashSet<PsiReference> resolved = new HashSet<PsiReference>();
        CommonSpringBean springBean = (CommonSpringBean)DomUtil.getParentOfType(genericDomValue, SpringBean.class, (boolean)true);
        if (springBean == null) {
            springBean = (CommonSpringBean)DomUtil.getParentOfType(genericDomValue, DomSpringBean.class, (boolean)true);
        }
        PsiClass psiClass2 = psiClass = springBean != null ? PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) : null;
        if (psiClass == null || stringValue.contains(".")) {
            PsiReference reference;
            PsiElement psiElement;
            PsiReference[] javaClassReferences;
            PsiReference[] psiReferenceArray = javaClassReferences = InterceptMethodConverter.getJavaClassReferences(element);
            int n = psiReferenceArray.length;
            for (int i = 0; i < n && (psiElement = (reference = psiReferenceArray[i]).resolve()) != null; ++i) {
                resolved.add(reference);
                if (!(psiElement instanceof PsiClass)) continue;
                psiClass = (PsiClass)psiElement;
            }
            if (psiClass == null || stringValue.endsWith(psiClass.getName())) {
                if (javaClassReferences == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter", "createReferences"));
                }
                return javaClassReferences;
            }
        }
        resolved.add(InterceptMethodConverter.createMethodReference(psiClass, element, stringValue));
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.toObjectArray(resolved, PsiReference.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getJavaClassReferences(PsiElement element) {
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        provider.setSoft(true);
        return provider.getReferencesByElement(element);
    }

    private static PsiReference createMethodReference(final PsiClass psiClass, PsiElement element, String stringValue) {
        String className = psiClass.getName();
        final String methodName = !stringValue.contains(className) ? stringValue : stringValue.substring(stringValue.indexOf(className) + className.length() + 1).trim();
        TextRange textRange = methodName.length() == 0 ? TextRange.from((int)(element.getText().indexOf(className) + className.length() + 1), (int)0) : TextRange.from((int)element.getText().indexOf(methodName), (int)methodName.length());
        return new PsiReferenceBase<PsiElement>(element, textRange, true){

            public PsiElement resolve() {
                if (methodName.length() != 0) {
                    for (PsiMethod psiMethod : psiClass.findMethodsByName(methodName, true)) {
                        if (!psiMethod.hasModifierProperty("public")) continue;
                        return psiMethod;
                    }
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                PsiMethod[] psiMethods = psiClass.getAllMethods();
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(psiMethods.length);
                for (PsiMethod method : psiMethods) {
                    PsiClass containingClass = method.getContainingClass();
                    if (!method.hasModifierProperty("public") || method.isConstructor() || containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                    methods.add(method);
                }
                Object[] objectArray = ArrayUtil.toObjectArray(methods);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter$1", "getVariants"));
                }
                return objectArray;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter$1", "bindToElement"));
                }
                return this.getElement();
            }
        };
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

