/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBColorConstantQuickFix;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBColorQuickFix;

public class UseJBColorInspection
extends DevKitInspectionBase {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection", "buildInternalVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                ProblemDescriptor descriptor = UseJBColorInspection.checkNewExpression(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
                super.visitNewExpression(expression);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiClass colorClass;
                super.visitReferenceExpression(expression);
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    return;
                }
                PsiElement colorField = expression.resolve();
                if (colorField != null && colorField instanceof PsiField && ((PsiField)colorField).hasModifierProperty("static") && (colorClass = ((PsiField)colorField).getContainingClass()) != null && Color.class.getName().equals(colorClass.getQualifiedName())) {
                    String text = expression.getText();
                    if (text.contains(".")) {
                        text = text.substring(text.lastIndexOf(46));
                    }
                    if ((text = StringUtil.trimStart((String)text, (String)".")).equalsIgnoreCase("lightGray")) {
                        text = "LIGHT_GRAY";
                    } else if (text.equalsIgnoreCase("darkGray")) {
                        text = "DARK_GRAY";
                    }
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor((PsiElement)expression, "Change to JBColor." + text.toUpperCase(), (LocalQuickFix)new ConvertToJBColorConstantQuickFix(text.toUpperCase()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    holder.registerProblem(descriptor);
                }
            }
        };
    }

    @Nullable
    private static ProblemDescriptor checkNewExpression(PsiNewExpression expression, InspectionManager manager, boolean isOnTheFly) {
        JavaPsiFacade facade;
        PsiClass jbColorClass;
        Project project = manager.getProject();
        PsiType type = expression.getType();
        PsiExpressionList arguments = expression.getArgumentList();
        if (type != null && arguments != null && type.equalsToText("java.awt.Color") && (jbColorClass = (facade = JavaPsiFacade.getInstance((Project)project)).findClass(JBColor.class.getName(), GlobalSearchScope.allScope((Project)project))) != null && facade.getResolveHelper().isAccessible((PsiMember)jbColorClass, (PsiElement)expression, jbColorClass)) {
            PsiType parentType;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiNewExpression && ((parentType = ((PsiNewExpression)parent.getParent()).getType()) == null || JBColor.class.getName().equals(parentType.getCanonicalText()))) {
                return null;
            }
            return manager.createProblemDescriptor((PsiElement)expression, "Replace with JBColor", (LocalQuickFix)new ConvertToJBColorQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        }
        return null;
    }
}

