/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.inspections.StringDescriptorInspection;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.quickFixes.PopupQuickFix;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.util.List;

public class FormSpellCheckingInspection
extends StringDescriptorInspection {
    public static final String SHORT_NAME = "SpellCheckingInspection";

    public FormSpellCheckingInspection() {
        super(SHORT_NAME);
    }

    @Override
    protected void checkStringDescriptor(Module module, IComponent component, final IProperty prop, final StringDescriptor descriptor, FormErrorCollector collector) {
        String value = descriptor.getResolvedValue();
        if (value == null) {
            return;
        }
        final SpellCheckerManager manager = SpellCheckerManager.getInstance((Project)module.getProject());
        PlainTextSplitter.getInstance().split(value, TextRange.allOf((String)value), textRange -> {
            final String word = textRange.substring(value);
            if (manager.hasProblem(word)) {
                final List suggestions = manager.getSuggestions(word);
                if (suggestions.size() > 0 && prop instanceof IntroStringProperty) {
                    EditorQuickFixProvider changeToProvider = new EditorQuickFixProvider(){

                        @Override
                        public QuickFix createQuickFix(final GuiEditor editor, final RadComponent component1) {
                            return new PopupQuickFix<String>(editor, "Change to...", component1){

                                @Override
                                public void run() {
                                    ListPopup popup = JBPopupFactory.getInstance().createListPopup(this.getPopupStep());
                                    popup.showUnderneathOf((Component)component1.getDelegee());
                                }

                                @Override
                                public ListPopupStep<String> getPopupStep() {
                                    return new BaseListPopupStep<String>("Select Replacement", suggestions){

                                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                                            FormInspectionUtil.updateStringPropertyValue(editor, component1, (IntroStringProperty)prop, descriptor, selectedValue);
                                            return FINAL_CHOICE;
                                        }
                                    };
                                }
                            };
                        }
                    };
                    EditorQuickFixProvider acceptProvider = new EditorQuickFixProvider(){

                        @Override
                        public QuickFix createQuickFix(final GuiEditor editor, RadComponent component1) {
                            return new QuickFix(editor, "Save '" + word + "' to dictionary", component1){

                                @Override
                                public void run() {
                                    manager.acceptWordAsCorrect(word, editor.getProject());
                                }
                            };
                        }
                    };
                    collector.addError(this.getID(), component, prop, "Typo in word '" + word + "'", changeToProvider, acceptProvider);
                } else {
                    collector.addError(this.getID(), component, prop, "Typo in word '" + word + "'", new EditorQuickFixProvider[0]);
                }
            }
        });
    }
}

