/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.BvField;
import com.intellij.beanValidation.model.xml.BvGetter;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBvXmlNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BeanMemberNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ConstraintNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;

public class BeanNode
extends AbstractBvXmlNode {
    private final Bean myBean;

    public BeanNode(SimpleNode parent, Bean bean) {
        super(parent, (PsiElement)bean.getClassAttr().getValue(), (XmlElement)bean.getClassAttr().getXmlAttributeValue());
        this.myBean = bean;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        PsiClass psiClass = (PsiClass)this.myBean.getClassAttr().getValue();
        XmlAttributeValue value = this.myBean.getClassAttr().getXmlAttributeValue();
        if (psiClass != null && value != null) {
            presentation.addText(psiClass.getName(), !value.isValid() ? this.getErrorAttributes() : this.getPlainAttributes());
            presentation.setTooltip(psiClass.getQualifiedName());
            presentation.setIcon(psiClass.getIcon(0));
        } else if (value != null) {
            presentation.addText(value.getValue(), this.getPlainAttributes());
        }
    }

    @Override
    public SimpleNode[] getChildren() {
        ArrayList<AbstractBvXmlNode> children = new ArrayList<AbstractBvXmlNode>();
        for (Constraint constraint : this.myBean.getClazz().getConstraints()) {
            children.add(new ConstraintNode(this, constraint));
        }
        for (BvField field : this.myBean.getFields()) {
            children.add(new BeanMemberNode(field.getName(), this));
        }
        for (BvGetter getter : this.myBean.getGetters()) {
            children.add(new BeanMemberNode(getter.getName(), this));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }
}

