/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBvXmlNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.BVCoreIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiMemberInXmlNode
extends AbstractBvXmlNode {
    private final PsiMember myMember;
    private final XmlAttributeValue myAttr;

    public PsiMemberInXmlNode(@NotNull PsiMember member, SimpleNode parent, XmlAttributeValue value) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/beanValidation/toolWindow/tree/nodes/PsiMemberInXmlNode", "<init>"));
        }
        super(parent, (PsiElement)member, (XmlElement)value);
        this.myMember = member;
        this.myAttr = value;
    }

    public PsiMember getMember() {
        return this.myMember;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setTooltip(this.myMember.getText());
        Icon icon = this.myMember instanceof PsiField ? BVCoreIcons.FieldInXml : BVCoreIcons.GetterInXml;
        presentation.setIcon(icon);
        presentation.addText(this.myMember.getName(), !this.myMember.isValid() ? this.getErrorAttributes() : this.getPlainAttributes());
        PsiFile xmlFile = this.myAttr.getContainingFile();
        if (xmlFile != null) {
            presentation.addText(" (" + xmlFile.getName() + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    protected void doUpdate() {
        this.clearColoredText();
    }
}

