/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PatternOverriddenByNonAnnotatedMethod
extends LocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Pattern Validation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "getGroupDisplayName"));
        }
        return "Pattern Validation";
    }

    @NotNull
    public String getDisplayName() {
        if ("Non-annotated Method overrides @Pattern Method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "getDisplayName"));
        }
        return "Non-annotated Method overrides @Pattern Method";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getPatternAnnotationPair();
            }

            public void visitMethod(PsiMethod method) {
                PsiAnnotation[] annotationFromHierarchy;
                PsiIdentifier psiIdentifier = method.getNameIdentifier();
                if (psiIdentifier == null || !PsiUtilEx.isLanguageAnnotationTarget((PsiModifierListOwner)method)) {
                    return;
                }
                PsiAnnotation[] annotationFrom = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, false);
                if (annotationFrom.length == 0 && (annotationFromHierarchy = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, true)).length > 0) {
                    String annotationClassname = annotationFromHierarchy[annotationFromHierarchy.length - 1].getQualifiedName();
                    String argList = annotationFromHierarchy[annotationFromHierarchy.length - 1].getParameterList().getText();
                    holder.registerProblem((PsiElement)psiIdentifier, "Non-annotated Method overrides @Pattern Method", new LocalQuickFix[]{new AnnotateFix(annotationClassname, argList)});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("PatternOverriddenByNonAnnotatedMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "getShortName"));
        }
        return "PatternOverriddenByNonAnnotatedMethod";
    }
}

