/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicTreeNode
implements TreeNode {
    private final boolean myAllowsChildren;
    private final TreeNode myParent;

    public BasicTreeNode(boolean allowsChildren, TreeNode parent) {
        this.myAllowsChildren = allowsChildren;
        this.myParent = parent;
    }

    @Override
    @Nullable
    public TreeNode getChildAt(int childIndex) {
        TreeNode[] children = this.getChildren();
        return children.length > childIndex && childIndex > -1 ? children[childIndex] : null;
    }

    protected abstract TreeNode[] getChildren();

    @Override
    public boolean getAllowsChildren() {
        return this.myAllowsChildren;
    }

    public Enumeration children() {
        return new Enumeration(){
            int myIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.myIndex == BasicTreeNode.this.getChildCount();
            }

            @Nullable
            public Object nextElement() {
                TreeNode child = BasicTreeNode.this.getChildAt(this.myIndex);
                ++this.myIndex;
                return child;
            }
        };
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        Enumeration enumeration = this.children();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (Comparing.equal(object, (Object)node)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Project getProject() {
        return this.getModel().getProject();
    }

    protected abstract DuplicatesModel getModel();

    @NotNull
    public static SimpleTextAttributes getTextAttributes(boolean selected) {
        SimpleTextAttributes simpleTextAttributes = selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/BasicTreeNode", "getTextAttributes"));
        }
        return simpleTextAttributes;
    }

    @NotNull
    public static SimpleTextAttributes getCommentAttributes(boolean selected) {
        SimpleTextAttributes simpleTextAttributes = selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/BasicTreeNode", "getCommentAttributes"));
        }
        return simpleTextAttributes;
    }
}

