/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.batch.el.SpringBatchMapVariable;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBatchELVariablesProvider
extends SpringElContextsExtension {
    private static final String[] MAP_VARIABLE_NAMES = new String[]{"jobParameters", "jobExecutionContext", "stepExecutionContext"};

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/spring/batch/el/SpringBatchELVariablesProvider", "getContextVariables"));
        }
        LinkedList variables = ContainerUtil.newLinkedList();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement);
        if (SpringBatchELVariablesProvider.hasSpringBatchLibrary(module)) {
            for (String name : MAP_VARIABLE_NAMES) {
                variables.add(new SpringBatchMapVariable(contextElement, name));
            }
        }
        LinkedList linkedList = variables;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/batch/el/SpringBatchELVariablesProvider", "getContextVariables"));
        }
        return linkedList;
    }

    private static boolean hasSpringBatchLibrary(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.batch.core.Job") != null;
    }
}

