/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.database.AndroidRemoteDbInfo;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDataSourceProjectComponent
extends AbstractProjectComponent {
    public AndroidDataSourceProjectComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidDataSourceProjectComponent", "<init>"));
        }
        super(project);
    }

    public void projectOpened() {
        DataSourceConfigUtil.refreshTablesInBackground((Project)this.myProject, AndroidDataSourceStorage.getInstance(this.myProject).getDataSources());
    }

    public void projectClosed() {
        if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
            return;
        }
        String basePath = FileUtil.toCanonicalPath((String)this.myProject.getBasePath());
        if (basePath != null) {
            Set<AndroidRemoteDbInfo> infos = this.collectAllUsedDatabases();
            AndroidRemoteDataBaseManager.getInstance().updateDbUsagesForProject(basePath, infos);
        }
    }

    @NotNull
    private Set<AndroidRemoteDbInfo> collectAllUsedDatabases() {
        HashSet result = new HashSet();
        for (AndroidDataSource source : AndroidDataSourceStorage.getInstance(this.myProject).getDataSources()) {
            AndroidDataSource.State s = source.getState();
            String deviceId = s.deviceId;
            if (deviceId == null) {
                deviceId = "";
            }
            result.add(new AndroidRemoteDbInfo(deviceId, s.packageName, s.databaseName, s.external));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourceProjectComponent", "collectAllUsedDatabases"));
        }
        return hashSet;
    }

    @NotNull
    public String getComponentName() {
        if ("AndroidDataSourceProjectComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSourceProjectComponent", "getComponentName"));
        }
        return "AndroidDataSourceProjectComponent";
    }
}

